/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.query.ParallelDocumentQueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContext;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class PeekingParallelDocumentQueryExecutionContext
implements QueryExecutionContext<Document> {
    private Document buffered;
    protected ParallelDocumentQueryExecutionContext context;

    public static PeekingParallelDocumentQueryExecutionContext create(DocumentQueryClientInternal client, String collectionSelfLink, SqlQuerySpec querySpec, FeedOptions options, String resourceLink, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, int initialPageSize) {
        PeekingParallelDocumentQueryExecutionContext context = new PeekingParallelDocumentQueryExecutionContext(ParallelDocumentQueryExecutionContext.create(client, collectionSelfLink, querySpec, options, resourceLink, partitionedQueryExecutionInfo, initialPageSize));
        return context;
    }

    private PeekingParallelDocumentQueryExecutionContext(ParallelDocumentQueryExecutionContext context) {
        this.context = context;
    }

    private boolean moveNext() {
        try {
            this.buffered = this.context.next();
            return true;
        }
        catch (NoSuchElementException e) {
            this.buffered = null;
            return false;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.buffered != null) {
            return true;
        }
        return this.moveNext();
    }

    @Override
    public Document next() {
        if (this.buffered != null) {
            Document res = this.buffered;
            this.moveNext();
            return res;
        }
        throw new NoSuchElementException();
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return this.context.getResponseHeaders();
    }

    @Override
    public List<Document> fetchNextBlock() throws DocumentClientException {
        return this.context.fetchNextBlock();
    }

    @Override
    public void onNotifyStop() {
        this.context.onNotifyStop();
    }
}

