/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.KeyVaultClientBase;
import com.microsoft.azure.keyvault.models.BackupCertificateResult;
import com.microsoft.azure.keyvault.models.BackupKeyResult;
import com.microsoft.azure.keyvault.models.BackupSecretResult;
import com.microsoft.azure.keyvault.models.BackupStorageResult;
import com.microsoft.azure.keyvault.models.CertificateAttributes;
import com.microsoft.azure.keyvault.models.CertificateBundle;
import com.microsoft.azure.keyvault.models.CertificateCreateParameters;
import com.microsoft.azure.keyvault.models.CertificateImportParameters;
import com.microsoft.azure.keyvault.models.CertificateIssuerItem;
import com.microsoft.azure.keyvault.models.CertificateIssuerSetParameters;
import com.microsoft.azure.keyvault.models.CertificateIssuerUpdateParameters;
import com.microsoft.azure.keyvault.models.CertificateItem;
import com.microsoft.azure.keyvault.models.CertificateMergeParameters;
import com.microsoft.azure.keyvault.models.CertificateOperation;
import com.microsoft.azure.keyvault.models.CertificateOperationUpdateParameter;
import com.microsoft.azure.keyvault.models.CertificatePolicy;
import com.microsoft.azure.keyvault.models.CertificateRestoreParameters;
import com.microsoft.azure.keyvault.models.CertificateUpdateParameters;
import com.microsoft.azure.keyvault.models.Contacts;
import com.microsoft.azure.keyvault.models.DeletedCertificateBundle;
import com.microsoft.azure.keyvault.models.DeletedCertificateItem;
import com.microsoft.azure.keyvault.models.DeletedKeyBundle;
import com.microsoft.azure.keyvault.models.DeletedKeyItem;
import com.microsoft.azure.keyvault.models.DeletedSasDefinitionBundle;
import com.microsoft.azure.keyvault.models.DeletedSasDefinitionItem;
import com.microsoft.azure.keyvault.models.DeletedSecretBundle;
import com.microsoft.azure.keyvault.models.DeletedSecretItem;
import com.microsoft.azure.keyvault.models.DeletedStorageAccountItem;
import com.microsoft.azure.keyvault.models.DeletedStorageBundle;
import com.microsoft.azure.keyvault.models.IssuerAttributes;
import com.microsoft.azure.keyvault.models.IssuerBundle;
import com.microsoft.azure.keyvault.models.IssuerCredentials;
import com.microsoft.azure.keyvault.models.JsonWebKeyCurveName;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyCreateParameters;
import com.microsoft.azure.keyvault.models.KeyImportParameters;
import com.microsoft.azure.keyvault.models.KeyItem;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.models.KeyOperationsParameters;
import com.microsoft.azure.keyvault.models.KeyRestoreParameters;
import com.microsoft.azure.keyvault.models.KeySignParameters;
import com.microsoft.azure.keyvault.models.KeyUpdateParameters;
import com.microsoft.azure.keyvault.models.KeyVaultErrorException;
import com.microsoft.azure.keyvault.models.KeyVerifyParameters;
import com.microsoft.azure.keyvault.models.KeyVerifyResult;
import com.microsoft.azure.keyvault.models.OrganizationDetails;
import com.microsoft.azure.keyvault.models.PageImpl;
import com.microsoft.azure.keyvault.models.SasDefinitionAttributes;
import com.microsoft.azure.keyvault.models.SasDefinitionBundle;
import com.microsoft.azure.keyvault.models.SasDefinitionCreateParameters;
import com.microsoft.azure.keyvault.models.SasDefinitionItem;
import com.microsoft.azure.keyvault.models.SasDefinitionUpdateParameters;
import com.microsoft.azure.keyvault.models.SasTokenType;
import com.microsoft.azure.keyvault.models.SecretAttributes;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.azure.keyvault.models.SecretItem;
import com.microsoft.azure.keyvault.models.SecretRestoreParameters;
import com.microsoft.azure.keyvault.models.SecretSetParameters;
import com.microsoft.azure.keyvault.models.SecretUpdateParameters;
import com.microsoft.azure.keyvault.models.StorageAccountAttributes;
import com.microsoft.azure.keyvault.models.StorageAccountCreateParameters;
import com.microsoft.azure.keyvault.models.StorageAccountItem;
import com.microsoft.azure.keyvault.models.StorageAccountRegenerteKeyParameters;
import com.microsoft.azure.keyvault.models.StorageAccountUpdateParameters;
import com.microsoft.azure.keyvault.models.StorageBundle;
import com.microsoft.azure.keyvault.models.StorageRestoreParameters;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyEncryptionAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyOperation;
import com.microsoft.azure.keyvault.webkey.JsonWebKeySignatureAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyType;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class KeyVaultClientBaseImpl
extends AzureServiceClient
implements KeyVaultClientBase {
    private KeyVaultClientBaseService service;
    private AzureClient azureClient;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;

    @Override
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    @Override
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public KeyVaultClientBaseImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    @Override
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public KeyVaultClientBaseImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    @Override
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    @Override
    public KeyVaultClientBaseImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public KeyVaultClientBaseImpl(ServiceClientCredentials credentials) {
        this("https://{vaultBaseUrl}", credentials);
    }

    private KeyVaultClientBaseImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public KeyVaultClientBaseImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "7.0";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "KeyVaultClientBase", "7.0");
    }

    private void initializeService() {
        this.service = (KeyVaultClientBaseService)this.restClient().retrofit().create(KeyVaultClientBaseService.class);
    }

    @Override
    public KeyBundle createKey(String vaultBaseUrl, String keyName, JsonWebKeyType kty) {
        return (KeyBundle)((ServiceResponse)this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty), serviceCallback);
    }

    @Override
    public Observable<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty) {
        return this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyBundle>> createKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (kty == null) {
            throw new IllegalArgumentException("Parameter kty is required and cannot be null.");
        }
        Object keySize = null;
        Object keyOps = null;
        Object keyAttributes = null;
        Object tags = null;
        Object curve = null;
        KeyCreateParameters parameters = new KeyCreateParameters();
        parameters.withKty(kty);
        parameters.withKeySize(null);
        parameters.withKeyOps(null);
        parameters.withKeyAttributes(null);
        parameters.withTags(null);
        parameters.withCurve(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.createKey(keyName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.createKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public KeyBundle createKey(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, JsonWebKeyCurveName curve) {
        return (KeyBundle)((ServiceResponse)this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty, keySize, keyOps, keyAttributes, tags, curve).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, JsonWebKeyCurveName curve, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty, keySize, keyOps, keyAttributes, tags, curve), serviceCallback);
    }

    @Override
    public Observable<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, JsonWebKeyCurveName curve) {
        return this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty, keySize, keyOps, keyAttributes, tags, curve).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyBundle>> createKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, JsonWebKeyCurveName curve) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (kty == null) {
            throw new IllegalArgumentException("Parameter kty is required and cannot be null.");
        }
        Validator.validate(keyOps);
        Validator.validate((Object)keyAttributes);
        Validator.validate(tags);
        KeyCreateParameters parameters = new KeyCreateParameters();
        parameters.withKty(kty);
        parameters.withKeySize(keySize);
        parameters.withKeyOps(keyOps);
        parameters.withKeyAttributes(keyAttributes);
        parameters.withTags(tags);
        parameters.withCurve(curve);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.createKey(keyName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.createKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> createKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyBundle importKey(String vaultBaseUrl, String keyName, JsonWebKey key) {
        return (KeyBundle)((ServiceResponse)this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key), serviceCallback);
    }

    @Override
    public Observable<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key) {
        return this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyBundle>> importKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKey key) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter key is required and cannot be null.");
        }
        Validator.validate((Object)key);
        Object hsm = null;
        Object keyAttributes = null;
        Object tags = null;
        KeyImportParameters parameters = new KeyImportParameters();
        parameters.withHsm(null);
        parameters.withKey(key);
        parameters.withKeyAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.importKey(keyName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.importKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public KeyBundle importKey(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags) {
        return (KeyBundle)((ServiceResponse)this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags) {
        return this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyBundle>> importKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter key is required and cannot be null.");
        }
        Validator.validate((Object)key);
        Validator.validate((Object)keyAttributes);
        Validator.validate(tags);
        KeyImportParameters parameters = new KeyImportParameters();
        parameters.withHsm(hsm);
        parameters.withKey(key);
        parameters.withKeyAttributes(keyAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.importKey(keyName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.importKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> importKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public DeletedKeyBundle deleteKey(String vaultBaseUrl, String keyName) {
        return (DeletedKeyBundle)((ServiceResponse)this.deleteKeyWithServiceResponseAsync(vaultBaseUrl, keyName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DeletedKeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<DeletedKeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteKeyWithServiceResponseAsync(vaultBaseUrl, keyName), serviceCallback);
    }

    @Override
    public Observable<DeletedKeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName) {
        return this.deleteKeyWithServiceResponseAsync(vaultBaseUrl, keyName).map((Func1)new Func1<ServiceResponse<DeletedKeyBundle>, DeletedKeyBundle>(){

            public DeletedKeyBundle call(ServiceResponse<DeletedKeyBundle> response) {
                return (DeletedKeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DeletedKeyBundle>> deleteKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteKey(keyName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedKeyBundle>>>(){

            public Observable<ServiceResponse<DeletedKeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.deleteKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedKeyBundle> deleteKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeletedKeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyBundle updateKey(String vaultBaseUrl, String keyName, String keyVersion) {
        return (KeyBundle)((ServiceResponse)this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion), serviceCallback);
    }

    @Override
    public Observable<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        return this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyBundle>> updateKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object keyOps = null;
        Object keyAttributes = null;
        Object tags = null;
        KeyUpdateParameters parameters = new KeyUpdateParameters();
        parameters.withKeyOps(null);
        parameters.withKeyAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateKey(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public KeyBundle updateKey(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        return (KeyBundle)((ServiceResponse)this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        return this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyBundle>> updateKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate(keyOps);
        Validator.validate((Object)keyAttributes);
        Validator.validate(tags);
        KeyUpdateParameters parameters = new KeyUpdateParameters();
        parameters.withKeyOps(keyOps);
        parameters.withKeyAttributes(keyAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateKey(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> updateKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyBundle getKey(String vaultBaseUrl, String keyName, String keyVersion) {
        return (KeyBundle)((ServiceResponse)this.getKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion), serviceCallback);
    }

    @Override
    public Observable<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        return this.getKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyBundle>> getKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getKey(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> getKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<KeyItem> getKeyVersions(String vaultBaseUrl, String keyName) {
        ServiceResponse response = (ServiceResponse)this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.body()){

            public Page<KeyItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<KeyItem>> getKeyVersionsAsync(String vaultBaseUrl, String keyName, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<KeyItem>> getKeyVersionsAsync(String vaultBaseUrl, String keyName) {
        return this.getKeyVersionsWithServiceResponseAsync(vaultBaseUrl, keyName).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsWithServiceResponseAsync(String vaultBaseUrl, String keyName) {
        return this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getKeyVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsSinglePageAsync(String vaultBaseUrl, String keyName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getKeyVersions(keyName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getKeyVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<KeyItem> getKeyVersions(String vaultBaseUrl, String keyName, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName, maxresults).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.body()){

            public Page<KeyItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<KeyItem>> getKeyVersionsAsync(String vaultBaseUrl, String keyName, Integer maxresults, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<KeyItem>> getKeyVersionsAsync(String vaultBaseUrl, String keyName, Integer maxresults) {
        return this.getKeyVersionsWithServiceResponseAsync(vaultBaseUrl, keyName, maxresults).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsWithServiceResponseAsync(String vaultBaseUrl, String keyName, Integer maxresults) {
        return this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getKeyVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsSinglePageAsync(String vaultBaseUrl, String keyName, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getKeyVersions(keyName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getKeyVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<KeyItem>> getKeyVersionsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<KeyItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<KeyItem> getKeys(String vaultBaseUrl) {
        ServiceResponse response = (ServiceResponse)this.getKeysSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.body()){

            public Page<KeyItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getKeysNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<KeyItem>> getKeysAsync(String vaultBaseUrl, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getKeysSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getKeysNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<KeyItem>> getKeysAsync(String vaultBaseUrl) {
        return this.getKeysWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<KeyItem>>> getKeysWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getKeysSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getKeysNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeysSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getKeys(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<KeyItem> getKeys(String vaultBaseUrl, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getKeysSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.body()){

            public Page<KeyItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getKeysNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<KeyItem>> getKeysAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getKeysSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getKeysNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<KeyItem>> getKeysAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getKeysWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<KeyItem>>> getKeysWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getKeysSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getKeysNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getKeys(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<KeyItem>> getKeysDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<KeyItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public BackupKeyResult backupKey(String vaultBaseUrl, String keyName) {
        return (BackupKeyResult)((ServiceResponse)this.backupKeyWithServiceResponseAsync(vaultBaseUrl, keyName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<BackupKeyResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.backupKeyWithServiceResponseAsync(vaultBaseUrl, keyName), serviceCallback);
    }

    @Override
    public Observable<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName) {
        return this.backupKeyWithServiceResponseAsync(vaultBaseUrl, keyName).map((Func1)new Func1<ServiceResponse<BackupKeyResult>, BackupKeyResult>(){

            public BackupKeyResult call(ServiceResponse<BackupKeyResult> response) {
                return (BackupKeyResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<BackupKeyResult>> backupKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.backupKey(keyName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupKeyResult>>>(){

            public Observable<ServiceResponse<BackupKeyResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.backupKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackupKeyResult> backupKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<BackupKeyResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyBundle restoreKey(String vaultBaseUrl, byte[] keyBundleBackup) {
        return (KeyBundle)((ServiceResponse)this.restoreKeyWithServiceResponseAsync(vaultBaseUrl, keyBundleBackup).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.restoreKeyWithServiceResponseAsync(vaultBaseUrl, keyBundleBackup), serviceCallback);
    }

    @Override
    public Observable<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup) {
        return this.restoreKeyWithServiceResponseAsync(vaultBaseUrl, keyBundleBackup).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyBundle>> restoreKeyWithServiceResponseAsync(String vaultBaseUrl, byte[] keyBundleBackup) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (keyBundleBackup == null) {
            throw new IllegalArgumentException("Parameter keyBundleBackup is required and cannot be null.");
        }
        KeyRestoreParameters parameters = new KeyRestoreParameters();
        parameters.withKeyBundleBackup(keyBundleBackup);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.restoreKey(this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.restoreKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> restoreKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyOperationResult encrypt(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return (KeyOperationResult)((ServiceResponse)this.encryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyOperationResult> encryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.encryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value), serviceCallback);
    }

    @Override
    public Observable<KeyOperationResult> encryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return this.encryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).map((Func1)new Func1<ServiceResponse<KeyOperationResult>, KeyOperationResult>(){

            public KeyOperationResult call(ServiceResponse<KeyOperationResult> response) {
                return (KeyOperationResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyOperationResult>> encryptWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.encrypt(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyOperationResult>>>(){

            public Observable<ServiceResponse<KeyOperationResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.encryptDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyOperationResult> encryptDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyOperationResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyOperationResult decrypt(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return (KeyOperationResult)((ServiceResponse)this.decryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyOperationResult> decryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.decryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value), serviceCallback);
    }

    @Override
    public Observable<KeyOperationResult> decryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return this.decryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).map((Func1)new Func1<ServiceResponse<KeyOperationResult>, KeyOperationResult>(){

            public KeyOperationResult call(ServiceResponse<KeyOperationResult> response) {
                return (KeyOperationResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyOperationResult>> decryptWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.decrypt(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyOperationResult>>>(){

            public Observable<ServiceResponse<KeyOperationResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.decryptDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyOperationResult> decryptDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyOperationResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyOperationResult sign(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        return (KeyOperationResult)((ServiceResponse)this.signWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyOperationResult> signAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.signWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value), serviceCallback);
    }

    @Override
    public Observable<KeyOperationResult> signAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        return this.signWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).map((Func1)new Func1<ServiceResponse<KeyOperationResult>, KeyOperationResult>(){

            public KeyOperationResult call(ServiceResponse<KeyOperationResult> response) {
                return (KeyOperationResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyOperationResult>> signWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        KeySignParameters parameters = new KeySignParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.sign(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyOperationResult>>>(){

            public Observable<ServiceResponse<KeyOperationResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.signDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyOperationResult> signDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyOperationResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyVerifyResult verify(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return (KeyVerifyResult)((ServiceResponse)this.verifyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyVerifyResult> verifyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, ServiceCallback<KeyVerifyResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.verifyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature), serviceCallback);
    }

    @Override
    public Observable<KeyVerifyResult> verifyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return this.verifyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature).map((Func1)new Func1<ServiceResponse<KeyVerifyResult>, KeyVerifyResult>(){

            public KeyVerifyResult call(ServiceResponse<KeyVerifyResult> response) {
                return (KeyVerifyResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyVerifyResult>> verifyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (digest == null) {
            throw new IllegalArgumentException("Parameter digest is required and cannot be null.");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Parameter signature is required and cannot be null.");
        }
        KeyVerifyParameters parameters = new KeyVerifyParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withDigest(digest);
        parameters.withSignature(signature);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.verify(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyVerifyResult>>>(){

            public Observable<ServiceResponse<KeyVerifyResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.verifyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyVerifyResult> verifyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyVerifyResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyOperationResult wrapKey(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return (KeyOperationResult)((ServiceResponse)this.wrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyOperationResult> wrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.wrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value), serviceCallback);
    }

    @Override
    public Observable<KeyOperationResult> wrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return this.wrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).map((Func1)new Func1<ServiceResponse<KeyOperationResult>, KeyOperationResult>(){

            public KeyOperationResult call(ServiceResponse<KeyOperationResult> response) {
                return (KeyOperationResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyOperationResult>> wrapKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.wrapKey(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyOperationResult>>>(){

            public Observable<ServiceResponse<KeyOperationResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.wrapKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyOperationResult> wrapKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyOperationResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyOperationResult unwrapKey(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return (KeyOperationResult)((ServiceResponse)this.unwrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyOperationResult> unwrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.unwrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value), serviceCallback);
    }

    @Override
    public Observable<KeyOperationResult> unwrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return this.unwrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).map((Func1)new Func1<ServiceResponse<KeyOperationResult>, KeyOperationResult>(){

            public KeyOperationResult call(ServiceResponse<KeyOperationResult> response) {
                return (KeyOperationResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyOperationResult>> unwrapKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.unwrapKey(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyOperationResult>>>(){

            public Observable<ServiceResponse<KeyOperationResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.unwrapKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyOperationResult> unwrapKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyOperationResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<DeletedKeyItem> getDeletedKeys(String vaultBaseUrl) {
        ServiceResponse response = (ServiceResponse)this.getDeletedKeysSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<DeletedKeyItem>((Page)response.body()){

            public Page<DeletedKeyItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedKeysNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedKeyItem>> getDeletedKeysAsync(String vaultBaseUrl, ListOperationCallback<DeletedKeyItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedKeysSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedKeyItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedKeyItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedKeysNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedKeyItem>> getDeletedKeysAsync(String vaultBaseUrl) {
        return this.getDeletedKeysWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<DeletedKeyItem>>, Page<DeletedKeyItem>>(){

            public Page<DeletedKeyItem> call(ServiceResponse<Page<DeletedKeyItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedKeyItem>>> getDeletedKeysWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getDeletedKeysSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedKeyItem>>, Observable<ServiceResponse<Page<DeletedKeyItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedKeyItem>>> call(ServiceResponse<Page<DeletedKeyItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedKeysNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedKeyItem>>> getDeletedKeysSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedKeys(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedKeyItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedKeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<DeletedKeyItem> getDeletedKeys(String vaultBaseUrl, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getDeletedKeysSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<DeletedKeyItem>((Page)response.body()){

            public Page<DeletedKeyItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedKeysNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedKeyItem>> getDeletedKeysAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<DeletedKeyItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedKeysSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedKeyItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedKeyItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedKeysNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedKeyItem>> getDeletedKeysAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getDeletedKeysWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<DeletedKeyItem>>, Page<DeletedKeyItem>>(){

            public Page<DeletedKeyItem> call(ServiceResponse<Page<DeletedKeyItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedKeyItem>>> getDeletedKeysWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getDeletedKeysSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedKeyItem>>, Observable<ServiceResponse<Page<DeletedKeyItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedKeyItem>>> call(ServiceResponse<Page<DeletedKeyItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedKeysNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedKeyItem>>> getDeletedKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedKeys(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedKeyItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedKeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedKeyItem>> getDeletedKeysDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedKeyItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public DeletedKeyBundle getDeletedKey(String vaultBaseUrl, String keyName) {
        return (DeletedKeyBundle)((ServiceResponse)this.getDeletedKeyWithServiceResponseAsync(vaultBaseUrl, keyName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DeletedKeyBundle> getDeletedKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<DeletedKeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDeletedKeyWithServiceResponseAsync(vaultBaseUrl, keyName), serviceCallback);
    }

    @Override
    public Observable<DeletedKeyBundle> getDeletedKeyAsync(String vaultBaseUrl, String keyName) {
        return this.getDeletedKeyWithServiceResponseAsync(vaultBaseUrl, keyName).map((Func1)new Func1<ServiceResponse<DeletedKeyBundle>, DeletedKeyBundle>(){

            public DeletedKeyBundle call(ServiceResponse<DeletedKeyBundle> response) {
                return (DeletedKeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DeletedKeyBundle>> getDeletedKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedKey(keyName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedKeyBundle>>>(){

            public Observable<ServiceResponse<DeletedKeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getDeletedKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedKeyBundle> getDeletedKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeletedKeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public void purgeDeletedKey(String vaultBaseUrl, String keyName) {
        ((ServiceResponse)this.purgeDeletedKeyWithServiceResponseAsync(vaultBaseUrl, keyName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> purgeDeletedKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.purgeDeletedKeyWithServiceResponseAsync(vaultBaseUrl, keyName), serviceCallback);
    }

    @Override
    public Observable<Void> purgeDeletedKeyAsync(String vaultBaseUrl, String keyName) {
        return this.purgeDeletedKeyWithServiceResponseAsync(vaultBaseUrl, keyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> purgeDeletedKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.purgeDeletedKey(keyName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.purgeDeletedKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> purgeDeletedKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public KeyBundle recoverDeletedKey(String vaultBaseUrl, String keyName) {
        return (KeyBundle)((ServiceResponse)this.recoverDeletedKeyWithServiceResponseAsync(vaultBaseUrl, keyName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<KeyBundle> recoverDeletedKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.recoverDeletedKeyWithServiceResponseAsync(vaultBaseUrl, keyName), serviceCallback);
    }

    @Override
    public Observable<KeyBundle> recoverDeletedKeyAsync(String vaultBaseUrl, String keyName) {
        return this.recoverDeletedKeyWithServiceResponseAsync(vaultBaseUrl, keyName).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<KeyBundle>> recoverDeletedKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.recoverDeletedKey(keyName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.recoverDeletedKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> recoverDeletedKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public SecretBundle setSecret(String vaultBaseUrl, String secretName, String value) {
        return (SecretBundle)((ServiceResponse)this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value), serviceCallback);
    }

    @Override
    public Observable<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value) {
        return this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SecretBundle>> setSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Object tags = null;
        Object contentType = null;
        Object secretAttributes = null;
        SecretSetParameters parameters = new SecretSetParameters();
        parameters.withValue(value);
        parameters.withTags(null);
        parameters.withContentType(null);
        parameters.withSecretAttributes(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setSecret(secretName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.setSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public SecretBundle setSecret(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes) {
        return (SecretBundle)((ServiceResponse)this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value, tags, contentType, secretAttributes).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value, tags, contentType, secretAttributes), serviceCallback);
    }

    @Override
    public Observable<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes) {
        return this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value, tags, contentType, secretAttributes).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SecretBundle>> setSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(tags);
        Validator.validate((Object)secretAttributes);
        SecretSetParameters parameters = new SecretSetParameters();
        parameters.withValue(value);
        parameters.withTags(tags);
        parameters.withContentType(contentType);
        parameters.withSecretAttributes(secretAttributes);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setSecret(secretName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.setSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretBundle> setSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public DeletedSecretBundle deleteSecret(String vaultBaseUrl, String secretName) {
        return (DeletedSecretBundle)((ServiceResponse)this.deleteSecretWithServiceResponseAsync(vaultBaseUrl, secretName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DeletedSecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName, ServiceCallback<DeletedSecretBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSecretWithServiceResponseAsync(vaultBaseUrl, secretName), serviceCallback);
    }

    @Override
    public Observable<DeletedSecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName) {
        return this.deleteSecretWithServiceResponseAsync(vaultBaseUrl, secretName).map((Func1)new Func1<ServiceResponse<DeletedSecretBundle>, DeletedSecretBundle>(){

            public DeletedSecretBundle call(ServiceResponse<DeletedSecretBundle> response) {
                return (DeletedSecretBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DeletedSecretBundle>> deleteSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteSecret(secretName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedSecretBundle>>>(){

            public Observable<ServiceResponse<DeletedSecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.deleteSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedSecretBundle> deleteSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeletedSecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public SecretBundle updateSecret(String vaultBaseUrl, String secretName, String secretVersion) {
        return (SecretBundle)((ServiceResponse)this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion), serviceCallback);
    }

    @Override
    public Observable<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        return this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SecretBundle>> updateSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (secretVersion == null) {
            throw new IllegalArgumentException("Parameter secretVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object contentType = null;
        Object secretAttributes = null;
        Object tags = null;
        SecretUpdateParameters parameters = new SecretUpdateParameters();
        parameters.withContentType(null);
        parameters.withSecretAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateSecret(secretName, secretVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public SecretBundle updateSecret(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        return (SecretBundle)((ServiceResponse)this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion, contentType, secretAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion, contentType, secretAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        return this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion, contentType, secretAttributes, tags).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SecretBundle>> updateSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (secretVersion == null) {
            throw new IllegalArgumentException("Parameter secretVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)secretAttributes);
        Validator.validate(tags);
        SecretUpdateParameters parameters = new SecretUpdateParameters();
        parameters.withContentType(contentType);
        parameters.withSecretAttributes(secretAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateSecret(secretName, secretVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretBundle> updateSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public SecretBundle getSecret(String vaultBaseUrl, String secretName, String secretVersion) {
        return (SecretBundle)((ServiceResponse)this.getSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion), serviceCallback);
    }

    @Override
    public Observable<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        return this.getSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SecretBundle>> getSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (secretVersion == null) {
            throw new IllegalArgumentException("Parameter secretVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSecret(secretName, secretVersion, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretBundle> getSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<SecretItem> getSecrets(String vaultBaseUrl) {
        ServiceResponse response = (ServiceResponse)this.getSecretsSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.body()){

            public Page<SecretItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getSecretsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SecretItem>> getSecretsAsync(String vaultBaseUrl, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSecretsSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getSecretsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SecretItem>> getSecretsAsync(String vaultBaseUrl) {
        return this.getSecretsWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getSecretsSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getSecretsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSecrets(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getSecretsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<SecretItem> getSecrets(String vaultBaseUrl, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getSecretsSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.body()){

            public Page<SecretItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getSecretsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SecretItem>> getSecretsAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSecretsSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getSecretsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SecretItem>> getSecretsAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getSecretsWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getSecretsSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getSecretsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSecrets(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getSecretsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecretItem>> getSecretsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<SecretItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<SecretItem> getSecretVersions(String vaultBaseUrl, String secretName) {
        ServiceResponse response = (ServiceResponse)this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.body()){

            public Page<SecretItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SecretItem>> getSecretVersionsAsync(String vaultBaseUrl, String secretName, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SecretItem>> getSecretVersionsAsync(String vaultBaseUrl, String secretName) {
        return this.getSecretVersionsWithServiceResponseAsync(vaultBaseUrl, secretName).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsWithServiceResponseAsync(String vaultBaseUrl, String secretName) {
        return this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getSecretVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsSinglePageAsync(String vaultBaseUrl, String secretName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSecretVersions(secretName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getSecretVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<SecretItem> getSecretVersions(String vaultBaseUrl, String secretName, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName, maxresults).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.body()){

            public Page<SecretItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SecretItem>> getSecretVersionsAsync(String vaultBaseUrl, String secretName, Integer maxresults, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SecretItem>> getSecretVersionsAsync(String vaultBaseUrl, String secretName, Integer maxresults) {
        return this.getSecretVersionsWithServiceResponseAsync(vaultBaseUrl, secretName, maxresults).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsWithServiceResponseAsync(String vaultBaseUrl, String secretName, Integer maxresults) {
        return this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getSecretVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsSinglePageAsync(String vaultBaseUrl, String secretName, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSecretVersions(secretName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getSecretVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecretItem>> getSecretVersionsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<SecretItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<DeletedSecretItem> getDeletedSecrets(String vaultBaseUrl) {
        ServiceResponse response = (ServiceResponse)this.getDeletedSecretsSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<DeletedSecretItem>((Page)response.body()){

            public Page<DeletedSecretItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedSecretsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedSecretItem>> getDeletedSecretsAsync(String vaultBaseUrl, ListOperationCallback<DeletedSecretItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedSecretsSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedSecretItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSecretItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedSecretsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedSecretItem>> getDeletedSecretsAsync(String vaultBaseUrl) {
        return this.getDeletedSecretsWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<DeletedSecretItem>>, Page<DeletedSecretItem>>(){

            public Page<DeletedSecretItem> call(ServiceResponse<Page<DeletedSecretItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedSecretItem>>> getDeletedSecretsWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getDeletedSecretsSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedSecretItem>>, Observable<ServiceResponse<Page<DeletedSecretItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSecretItem>>> call(ServiceResponse<Page<DeletedSecretItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedSecretsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedSecretItem>>> getDeletedSecretsSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedSecrets(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedSecretItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedSecretsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<DeletedSecretItem> getDeletedSecrets(String vaultBaseUrl, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getDeletedSecretsSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<DeletedSecretItem>((Page)response.body()){

            public Page<DeletedSecretItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedSecretsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedSecretItem>> getDeletedSecretsAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<DeletedSecretItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedSecretsSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedSecretItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSecretItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedSecretsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedSecretItem>> getDeletedSecretsAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getDeletedSecretsWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<DeletedSecretItem>>, Page<DeletedSecretItem>>(){

            public Page<DeletedSecretItem> call(ServiceResponse<Page<DeletedSecretItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedSecretItem>>> getDeletedSecretsWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getDeletedSecretsSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedSecretItem>>, Observable<ServiceResponse<Page<DeletedSecretItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSecretItem>>> call(ServiceResponse<Page<DeletedSecretItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedSecretsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedSecretItem>>> getDeletedSecretsSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedSecrets(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedSecretItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedSecretsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedSecretItem>> getDeletedSecretsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedSecretItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public DeletedSecretBundle getDeletedSecret(String vaultBaseUrl, String secretName) {
        return (DeletedSecretBundle)((ServiceResponse)this.getDeletedSecretWithServiceResponseAsync(vaultBaseUrl, secretName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DeletedSecretBundle> getDeletedSecretAsync(String vaultBaseUrl, String secretName, ServiceCallback<DeletedSecretBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDeletedSecretWithServiceResponseAsync(vaultBaseUrl, secretName), serviceCallback);
    }

    @Override
    public Observable<DeletedSecretBundle> getDeletedSecretAsync(String vaultBaseUrl, String secretName) {
        return this.getDeletedSecretWithServiceResponseAsync(vaultBaseUrl, secretName).map((Func1)new Func1<ServiceResponse<DeletedSecretBundle>, DeletedSecretBundle>(){

            public DeletedSecretBundle call(ServiceResponse<DeletedSecretBundle> response) {
                return (DeletedSecretBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DeletedSecretBundle>> getDeletedSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedSecret(secretName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedSecretBundle>>>(){

            public Observable<ServiceResponse<DeletedSecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getDeletedSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedSecretBundle> getDeletedSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeletedSecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public void purgeDeletedSecret(String vaultBaseUrl, String secretName) {
        ((ServiceResponse)this.purgeDeletedSecretWithServiceResponseAsync(vaultBaseUrl, secretName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> purgeDeletedSecretAsync(String vaultBaseUrl, String secretName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.purgeDeletedSecretWithServiceResponseAsync(vaultBaseUrl, secretName), serviceCallback);
    }

    @Override
    public Observable<Void> purgeDeletedSecretAsync(String vaultBaseUrl, String secretName) {
        return this.purgeDeletedSecretWithServiceResponseAsync(vaultBaseUrl, secretName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> purgeDeletedSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.purgeDeletedSecret(secretName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.purgeDeletedSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> purgeDeletedSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public SecretBundle recoverDeletedSecret(String vaultBaseUrl, String secretName) {
        return (SecretBundle)((ServiceResponse)this.recoverDeletedSecretWithServiceResponseAsync(vaultBaseUrl, secretName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SecretBundle> recoverDeletedSecretAsync(String vaultBaseUrl, String secretName, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.recoverDeletedSecretWithServiceResponseAsync(vaultBaseUrl, secretName), serviceCallback);
    }

    @Override
    public Observable<SecretBundle> recoverDeletedSecretAsync(String vaultBaseUrl, String secretName) {
        return this.recoverDeletedSecretWithServiceResponseAsync(vaultBaseUrl, secretName).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SecretBundle>> recoverDeletedSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.recoverDeletedSecret(secretName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.recoverDeletedSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretBundle> recoverDeletedSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public BackupSecretResult backupSecret(String vaultBaseUrl, String secretName) {
        return (BackupSecretResult)((ServiceResponse)this.backupSecretWithServiceResponseAsync(vaultBaseUrl, secretName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<BackupSecretResult> backupSecretAsync(String vaultBaseUrl, String secretName, ServiceCallback<BackupSecretResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.backupSecretWithServiceResponseAsync(vaultBaseUrl, secretName), serviceCallback);
    }

    @Override
    public Observable<BackupSecretResult> backupSecretAsync(String vaultBaseUrl, String secretName) {
        return this.backupSecretWithServiceResponseAsync(vaultBaseUrl, secretName).map((Func1)new Func1<ServiceResponse<BackupSecretResult>, BackupSecretResult>(){

            public BackupSecretResult call(ServiceResponse<BackupSecretResult> response) {
                return (BackupSecretResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<BackupSecretResult>> backupSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.backupSecret(secretName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupSecretResult>>>(){

            public Observable<ServiceResponse<BackupSecretResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.backupSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackupSecretResult> backupSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<BackupSecretResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public SecretBundle restoreSecret(String vaultBaseUrl, byte[] secretBundleBackup) {
        return (SecretBundle)((ServiceResponse)this.restoreSecretWithServiceResponseAsync(vaultBaseUrl, secretBundleBackup).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SecretBundle> restoreSecretAsync(String vaultBaseUrl, byte[] secretBundleBackup, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.restoreSecretWithServiceResponseAsync(vaultBaseUrl, secretBundleBackup), serviceCallback);
    }

    @Override
    public Observable<SecretBundle> restoreSecretAsync(String vaultBaseUrl, byte[] secretBundleBackup) {
        return this.restoreSecretWithServiceResponseAsync(vaultBaseUrl, secretBundleBackup).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SecretBundle>> restoreSecretWithServiceResponseAsync(String vaultBaseUrl, byte[] secretBundleBackup) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (secretBundleBackup == null) {
            throw new IllegalArgumentException("Parameter secretBundleBackup is required and cannot be null.");
        }
        SecretRestoreParameters parameters = new SecretRestoreParameters();
        parameters.withSecretBundleBackup(secretBundleBackup);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.restoreSecret(this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.restoreSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretBundle> restoreSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<CertificateItem> getCertificates(String vaultBaseUrl) {
        ServiceResponse response = (ServiceResponse)this.getCertificatesSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.body()){

            public Page<CertificateItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CertificateItem>> getCertificatesAsync(String vaultBaseUrl, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getCertificatesSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CertificateItem>> getCertificatesAsync(String vaultBaseUrl) {
        return this.getCertificatesWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getCertificatesSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        Boolean includePending = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificates(maxresults, includePending, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getCertificatesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CertificateItem> getCertificates(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        ServiceResponse response = (ServiceResponse)this.getCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.body()){

            public Page<CertificateItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CertificateItem>> getCertificatesAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CertificateItem>> getCertificatesAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        return this.getCertificatesWithServiceResponseAsync(vaultBaseUrl, maxresults, includePending).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        return this.getCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesSinglePageAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificates(maxresults, includePending, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getCertificatesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateItem>> getCertificatesDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<CertificateItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public DeletedCertificateBundle deleteCertificate(String vaultBaseUrl, String certificateName) {
        return (DeletedCertificateBundle)((ServiceResponse)this.deleteCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DeletedCertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<DeletedCertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    @Override
    public Observable<DeletedCertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.deleteCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<DeletedCertificateBundle>, DeletedCertificateBundle>(){

            public DeletedCertificateBundle call(ServiceResponse<DeletedCertificateBundle> response) {
                return (DeletedCertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DeletedCertificateBundle>> deleteCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedCertificateBundle>>>(){

            public Observable<ServiceResponse<DeletedCertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.deleteCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedCertificateBundle> deleteCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeletedCertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public Contacts setCertificateContacts(String vaultBaseUrl, Contacts contacts) {
        return (Contacts)((ServiceResponse)this.setCertificateContactsWithServiceResponseAsync(vaultBaseUrl, contacts).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts, ServiceCallback<Contacts> serviceCallback) {
        return ServiceFuture.fromResponse(this.setCertificateContactsWithServiceResponseAsync(vaultBaseUrl, contacts), serviceCallback);
    }

    @Override
    public Observable<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts) {
        return this.setCertificateContactsWithServiceResponseAsync(vaultBaseUrl, contacts).map((Func1)new Func1<ServiceResponse<Contacts>, Contacts>(){

            public Contacts call(ServiceResponse<Contacts> response) {
                return (Contacts)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Contacts>> setCertificateContactsWithServiceResponseAsync(String vaultBaseUrl, Contacts contacts) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (contacts == null) {
            throw new IllegalArgumentException("Parameter contacts is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)contacts);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setCertificateContacts(contacts, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Contacts>>>(){

            public Observable<ServiceResponse<Contacts>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.setCertificateContactsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Contacts> setCertificateContactsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<Contacts>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public Contacts getCertificateContacts(String vaultBaseUrl) {
        return (Contacts)((ServiceResponse)this.getCertificateContactsWithServiceResponseAsync(vaultBaseUrl).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Contacts> getCertificateContactsAsync(String vaultBaseUrl, ServiceCallback<Contacts> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCertificateContactsWithServiceResponseAsync(vaultBaseUrl), serviceCallback);
    }

    @Override
    public Observable<Contacts> getCertificateContactsAsync(String vaultBaseUrl) {
        return this.getCertificateContactsWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Contacts>, Contacts>(){

            public Contacts call(ServiceResponse<Contacts> response) {
                return (Contacts)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Contacts>> getCertificateContactsWithServiceResponseAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateContacts(this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Contacts>>>(){

            public Observable<ServiceResponse<Contacts>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getCertificateContactsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Contacts> getCertificateContactsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<Contacts>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public Contacts deleteCertificateContacts(String vaultBaseUrl) {
        return (Contacts)((ServiceResponse)this.deleteCertificateContactsWithServiceResponseAsync(vaultBaseUrl).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl, ServiceCallback<Contacts> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCertificateContactsWithServiceResponseAsync(vaultBaseUrl), serviceCallback);
    }

    @Override
    public Observable<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl) {
        return this.deleteCertificateContactsWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Contacts>, Contacts>(){

            public Contacts call(ServiceResponse<Contacts> response) {
                return (Contacts)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Contacts>> deleteCertificateContactsWithServiceResponseAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteCertificateContacts(this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Contacts>>>(){

            public Observable<ServiceResponse<Contacts>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.deleteCertificateContactsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Contacts> deleteCertificateContactsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<Contacts>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<CertificateIssuerItem> getCertificateIssuers(String vaultBaseUrl) {
        ServiceResponse response = (ServiceResponse)this.getCertificateIssuersSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<CertificateIssuerItem>((Page)response.body()){

            public Page<CertificateIssuerItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CertificateIssuerItem>> getCertificateIssuersAsync(String vaultBaseUrl, ListOperationCallback<CertificateIssuerItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getCertificateIssuersSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CertificateIssuerItem>> getCertificateIssuersAsync(String vaultBaseUrl) {
        return this.getCertificateIssuersWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Page<CertificateIssuerItem>>(){

            public Page<CertificateIssuerItem> call(ServiceResponse<Page<CertificateIssuerItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getCertificateIssuersSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(ServiceResponse<Page<CertificateIssuerItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getCertificateIssuersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateIssuers(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getCertificateIssuersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CertificateIssuerItem> getCertificateIssuers(String vaultBaseUrl, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getCertificateIssuersSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<CertificateIssuerItem>((Page)response.body()){

            public Page<CertificateIssuerItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CertificateIssuerItem>> getCertificateIssuersAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<CertificateIssuerItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getCertificateIssuersSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CertificateIssuerItem>> getCertificateIssuersAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificateIssuersWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Page<CertificateIssuerItem>>(){

            public Page<CertificateIssuerItem> call(ServiceResponse<Page<CertificateIssuerItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificateIssuersSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(ServiceResponse<Page<CertificateIssuerItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getCertificateIssuersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateIssuers(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getCertificateIssuersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateIssuerItem>> getCertificateIssuersDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<CertificateIssuerItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public IssuerBundle setCertificateIssuer(String vaultBaseUrl, String issuerName, String provider) {
        return (IssuerBundle)((ServiceResponse)this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider), serviceCallback);
    }

    @Override
    public Observable<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider) {
        return this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<IssuerBundle>> setCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName, String provider) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Parameter provider is required and cannot be null.");
        }
        Object credentials = null;
        Object organizationDetails = null;
        Object attributes = null;
        CertificateIssuerSetParameters parameter = new CertificateIssuerSetParameters();
        parameter.withProvider(provider);
        parameter.withCredentials(null);
        parameter.withOrganizationDetails(null);
        parameter.withAttributes(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameter, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.setCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public IssuerBundle setCertificateIssuer(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return (IssuerBundle)((ServiceResponse)this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes), serviceCallback);
    }

    @Override
    public Observable<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<IssuerBundle>> setCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Parameter provider is required and cannot be null.");
        }
        Validator.validate((Object)credentials);
        Validator.validate((Object)organizationDetails);
        Validator.validate((Object)attributes);
        CertificateIssuerSetParameters parameter = new CertificateIssuerSetParameters();
        parameter.withProvider(provider);
        parameter.withCredentials(credentials);
        parameter.withOrganizationDetails(organizationDetails);
        parameter.withAttributes(attributes);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameter, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.setCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IssuerBundle> setCertificateIssuerDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<IssuerBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public IssuerBundle updateCertificateIssuer(String vaultBaseUrl, String issuerName) {
        return (IssuerBundle)((ServiceResponse)this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName), serviceCallback);
    }

    @Override
    public Observable<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName) {
        return this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<IssuerBundle>> updateCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object provider = null;
        Object credentials = null;
        Object organizationDetails = null;
        Object attributes = null;
        CertificateIssuerUpdateParameters parameter = new CertificateIssuerUpdateParameters();
        parameter.withProvider(null);
        parameter.withCredentials(null);
        parameter.withOrganizationDetails(null);
        parameter.withAttributes(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameter, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public IssuerBundle updateCertificateIssuer(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return (IssuerBundle)((ServiceResponse)this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes), serviceCallback);
    }

    @Override
    public Observable<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<IssuerBundle>> updateCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)credentials);
        Validator.validate((Object)organizationDetails);
        Validator.validate((Object)attributes);
        CertificateIssuerUpdateParameters parameter = new CertificateIssuerUpdateParameters();
        parameter.withProvider(provider);
        parameter.withCredentials(credentials);
        parameter.withOrganizationDetails(organizationDetails);
        parameter.withAttributes(attributes);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameter, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IssuerBundle> updateCertificateIssuerDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<IssuerBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public IssuerBundle getCertificateIssuer(String vaultBaseUrl, String issuerName) {
        return (IssuerBundle)((ServiceResponse)this.getCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName), serviceCallback);
    }

    @Override
    public Observable<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName) {
        return this.getCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<IssuerBundle>> getCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IssuerBundle> getCertificateIssuerDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<IssuerBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public IssuerBundle deleteCertificateIssuer(String vaultBaseUrl, String issuerName) {
        return (IssuerBundle)((ServiceResponse)this.deleteCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName), serviceCallback);
    }

    @Override
    public Observable<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName) {
        return this.deleteCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<IssuerBundle>> deleteCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.deleteCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IssuerBundle> deleteCertificateIssuerDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<IssuerBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificateOperation createCertificate(String vaultBaseUrl, String certificateName) {
        return (CertificateOperation)((ServiceResponse)this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateOperation> serviceCallback) {
        return ServiceFuture.fromResponse(this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    @Override
    public Observable<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<CertificateOperation>, CertificateOperation>(){

            public CertificateOperation call(ServiceResponse<CertificateOperation> response) {
                return (CertificateOperation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateOperation>> createCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object certificatePolicy = null;
        Object certificateAttributes = null;
        Object tags = null;
        CertificateCreateParameters parameters = new CertificateCreateParameters();
        parameters.withCertificatePolicy(null);
        parameters.withCertificateAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.createCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateOperation>>>(){

            public Observable<ServiceResponse<CertificateOperation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.createCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public CertificateOperation createCertificate(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return (CertificateOperation)((ServiceResponse)this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy, certificateAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, ServiceCallback<CertificateOperation> serviceCallback) {
        return ServiceFuture.fromResponse(this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy, certificateAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy, certificateAttributes, tags).map((Func1)new Func1<ServiceResponse<CertificateOperation>, CertificateOperation>(){

            public CertificateOperation call(ServiceResponse<CertificateOperation> response) {
                return (CertificateOperation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateOperation>> createCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificatePolicy);
        Validator.validate((Object)certificateAttributes);
        Validator.validate(tags);
        CertificateCreateParameters parameters = new CertificateCreateParameters();
        parameters.withCertificatePolicy(certificatePolicy);
        parameters.withCertificateAttributes(certificateAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.createCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateOperation>>>(){

            public Observable<ServiceResponse<CertificateOperation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.createCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateOperation> createCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(202, new TypeToken<CertificateOperation>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificateBundle importCertificate(String vaultBaseUrl, String certificateName, String base64EncodedCertificate) {
        return (CertificateBundle)((ServiceResponse)this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate), serviceCallback);
    }

    @Override
    public Observable<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate) {
        return this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateBundle>> importCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (base64EncodedCertificate == null) {
            throw new IllegalArgumentException("Parameter base64EncodedCertificate is required and cannot be null.");
        }
        Object password = null;
        Object certificatePolicy = null;
        Object certificateAttributes = null;
        Object tags = null;
        CertificateImportParameters parameters = new CertificateImportParameters();
        parameters.withBase64EncodedCertificate(base64EncodedCertificate);
        parameters.withPassword(null);
        parameters.withCertificatePolicy(null);
        parameters.withCertificateAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.importCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.importCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public CertificateBundle importCertificate(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return (CertificateBundle)((ServiceResponse)this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate, password, certificatePolicy, certificateAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate, password, certificatePolicy, certificateAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate, password, certificatePolicy, certificateAttributes, tags).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateBundle>> importCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (base64EncodedCertificate == null) {
            throw new IllegalArgumentException("Parameter base64EncodedCertificate is required and cannot be null.");
        }
        Validator.validate((Object)certificatePolicy);
        Validator.validate((Object)certificateAttributes);
        Validator.validate(tags);
        CertificateImportParameters parameters = new CertificateImportParameters();
        parameters.withBase64EncodedCertificate(base64EncodedCertificate);
        parameters.withPassword(password);
        parameters.withCertificatePolicy(certificatePolicy);
        parameters.withCertificateAttributes(certificateAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.importCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.importCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> importCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<CertificateItem> getCertificateVersions(String vaultBaseUrl, String certificateName) {
        ServiceResponse response = (ServiceResponse)this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.body()){

            public Page<CertificateItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CertificateItem>> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CertificateItem>> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName) {
        return this.getCertificateVersionsWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        return this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getCertificateVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsSinglePageAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateVersions(certificateName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getCertificateVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CertificateItem> getCertificateVersions(String vaultBaseUrl, String certificateName, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName, maxresults).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.body()){

            public Page<CertificateItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CertificateItem>> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName, Integer maxresults, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CertificateItem>> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName, Integer maxresults) {
        return this.getCertificateVersionsWithServiceResponseAsync(vaultBaseUrl, certificateName, maxresults).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsWithServiceResponseAsync(String vaultBaseUrl, String certificateName, Integer maxresults) {
        return this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getCertificateVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsSinglePageAsync(String vaultBaseUrl, String certificateName, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateVersions(certificateName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getCertificateVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateItem>> getCertificateVersionsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<CertificateItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificatePolicy getCertificatePolicy(String vaultBaseUrl, String certificateName) {
        return (CertificatePolicy)((ServiceResponse)this.getCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificatePolicy> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    @Override
    public Observable<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName) {
        return this.getCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<CertificatePolicy>, CertificatePolicy>(){

            public CertificatePolicy call(ServiceResponse<CertificatePolicy> response) {
                return (CertificatePolicy)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificatePolicy>> getCertificatePolicyWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificatePolicy(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificatePolicy>>>(){

            public Observable<ServiceResponse<CertificatePolicy>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getCertificatePolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificatePolicy> getCertificatePolicyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CertificatePolicy>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificatePolicy updateCertificatePolicy(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy) {
        return (CertificatePolicy)((ServiceResponse)this.updateCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificatePolicy> updateCertificatePolicyAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, ServiceCallback<CertificatePolicy> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy), serviceCallback);
    }

    @Override
    public Observable<CertificatePolicy> updateCertificatePolicyAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy) {
        return this.updateCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy).map((Func1)new Func1<ServiceResponse<CertificatePolicy>, CertificatePolicy>(){

            public CertificatePolicy call(ServiceResponse<CertificatePolicy> response) {
                return (CertificatePolicy)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificatePolicy>> updateCertificatePolicyWithServiceResponseAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (certificatePolicy == null) {
            throw new IllegalArgumentException("Parameter certificatePolicy is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificatePolicy);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificatePolicy(certificateName, certificatePolicy, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificatePolicy>>>(){

            public Observable<ServiceResponse<CertificatePolicy>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateCertificatePolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificatePolicy> updateCertificatePolicyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CertificatePolicy>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificateBundle updateCertificate(String vaultBaseUrl, String certificateName, String certificateVersion) {
        return (CertificateBundle)((ServiceResponse)this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion), serviceCallback);
    }

    @Override
    public Observable<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion) {
        return this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateBundle>> updateCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (certificateVersion == null) {
            throw new IllegalArgumentException("Parameter certificateVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object certificatePolicy = null;
        Object certificateAttributes = null;
        Object tags = null;
        CertificateUpdateParameters parameters = new CertificateUpdateParameters();
        parameters.withCertificatePolicy(null);
        parameters.withCertificateAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificate(certificateName, certificateVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public CertificateBundle updateCertificate(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return (CertificateBundle)((ServiceResponse)this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy, certificateAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy, certificateAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy, certificateAttributes, tags).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateBundle>> updateCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (certificateVersion == null) {
            throw new IllegalArgumentException("Parameter certificateVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificatePolicy);
        Validator.validate((Object)certificateAttributes);
        Validator.validate(tags);
        CertificateUpdateParameters parameters = new CertificateUpdateParameters();
        parameters.withCertificatePolicy(certificatePolicy);
        parameters.withCertificateAttributes(certificateAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificate(certificateName, certificateVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> updateCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificateBundle getCertificate(String vaultBaseUrl, String certificateName, String certificateVersion) {
        return (CertificateBundle)((ServiceResponse)this.getCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion), serviceCallback);
    }

    @Override
    public Observable<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion) {
        return this.getCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateBundle>> getCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (certificateVersion == null) {
            throw new IllegalArgumentException("Parameter certificateVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificate(certificateName, certificateVersion, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> getCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificateOperation updateCertificateOperation(String vaultBaseUrl, String certificateName, boolean cancellationRequested) {
        return (CertificateOperation)((ServiceResponse)this.updateCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName, cancellationRequested).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateOperation> updateCertificateOperationAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested, ServiceCallback<CertificateOperation> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName, cancellationRequested), serviceCallback);
    }

    @Override
    public Observable<CertificateOperation> updateCertificateOperationAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested) {
        return this.updateCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName, cancellationRequested).map((Func1)new Func1<ServiceResponse<CertificateOperation>, CertificateOperation>(){

            public CertificateOperation call(ServiceResponse<CertificateOperation> response) {
                return (CertificateOperation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateOperation>> updateCertificateOperationWithServiceResponseAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        CertificateOperationUpdateParameter certificateOperation = new CertificateOperationUpdateParameter();
        certificateOperation.withCancellationRequested(cancellationRequested);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificateOperation(certificateName, this.apiVersion(), this.acceptLanguage(), certificateOperation, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateOperation>>>(){

            public Observable<ServiceResponse<CertificateOperation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateCertificateOperationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateOperation> updateCertificateOperationDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CertificateOperation>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificateOperation getCertificateOperation(String vaultBaseUrl, String certificateName) {
        return (CertificateOperation)((ServiceResponse)this.getCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateOperation> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    @Override
    public Observable<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName) {
        return this.getCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<CertificateOperation>, CertificateOperation>(){

            public CertificateOperation call(ServiceResponse<CertificateOperation> response) {
                return (CertificateOperation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateOperation>> getCertificateOperationWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateOperation(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateOperation>>>(){

            public Observable<ServiceResponse<CertificateOperation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getCertificateOperationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateOperation> getCertificateOperationDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CertificateOperation>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificateOperation deleteCertificateOperation(String vaultBaseUrl, String certificateName) {
        return (CertificateOperation)((ServiceResponse)this.deleteCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateOperation> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    @Override
    public Observable<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName) {
        return this.deleteCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<CertificateOperation>, CertificateOperation>(){

            public CertificateOperation call(ServiceResponse<CertificateOperation> response) {
                return (CertificateOperation)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateOperation>> deleteCertificateOperationWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteCertificateOperation(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateOperation>>>(){

            public Observable<ServiceResponse<CertificateOperation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.deleteCertificateOperationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateOperation> deleteCertificateOperationDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CertificateOperation>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificateBundle mergeCertificate(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates) {
        return (CertificateBundle)((ServiceResponse)this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates), serviceCallback);
    }

    @Override
    public Observable<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates) {
        return this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateBundle>> mergeCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (x509Certificates == null) {
            throw new IllegalArgumentException("Parameter x509Certificates is required and cannot be null.");
        }
        Validator.validate(x509Certificates);
        Object certificateAttributes = null;
        Object tags = null;
        CertificateMergeParameters parameters = new CertificateMergeParameters();
        parameters.withX509Certificates(x509Certificates);
        parameters.withCertificateAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.mergeCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.mergeCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public CertificateBundle mergeCertificate(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return (CertificateBundle)((ServiceResponse)this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes, tags).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateBundle>> mergeCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (x509Certificates == null) {
            throw new IllegalArgumentException("Parameter x509Certificates is required and cannot be null.");
        }
        Validator.validate(x509Certificates);
        Validator.validate((Object)certificateAttributes);
        Validator.validate(tags);
        CertificateMergeParameters parameters = new CertificateMergeParameters();
        parameters.withX509Certificates(x509Certificates);
        parameters.withCertificateAttributes(certificateAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.mergeCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.mergeCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> mergeCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(201, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public BackupCertificateResult backupCertificate(String vaultBaseUrl, String certificateName) {
        return (BackupCertificateResult)((ServiceResponse)this.backupCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<BackupCertificateResult> backupCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<BackupCertificateResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.backupCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    @Override
    public Observable<BackupCertificateResult> backupCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.backupCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<BackupCertificateResult>, BackupCertificateResult>(){

            public BackupCertificateResult call(ServiceResponse<BackupCertificateResult> response) {
                return (BackupCertificateResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<BackupCertificateResult>> backupCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.backupCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupCertificateResult>>>(){

            public Observable<ServiceResponse<BackupCertificateResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.backupCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackupCertificateResult> backupCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<BackupCertificateResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificateBundle restoreCertificate(String vaultBaseUrl, byte[] certificateBundleBackup) {
        return (CertificateBundle)((ServiceResponse)this.restoreCertificateWithServiceResponseAsync(vaultBaseUrl, certificateBundleBackup).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateBundle> restoreCertificateAsync(String vaultBaseUrl, byte[] certificateBundleBackup, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.restoreCertificateWithServiceResponseAsync(vaultBaseUrl, certificateBundleBackup), serviceCallback);
    }

    @Override
    public Observable<CertificateBundle> restoreCertificateAsync(String vaultBaseUrl, byte[] certificateBundleBackup) {
        return this.restoreCertificateWithServiceResponseAsync(vaultBaseUrl, certificateBundleBackup).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateBundle>> restoreCertificateWithServiceResponseAsync(String vaultBaseUrl, byte[] certificateBundleBackup) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (certificateBundleBackup == null) {
            throw new IllegalArgumentException("Parameter certificateBundleBackup is required and cannot be null.");
        }
        CertificateRestoreParameters parameters = new CertificateRestoreParameters();
        parameters.withCertificateBundleBackup(certificateBundleBackup);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.restoreCertificate(this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.restoreCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> restoreCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<DeletedCertificateItem> getDeletedCertificates(String vaultBaseUrl) {
        ServiceResponse response = (ServiceResponse)this.getDeletedCertificatesSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<DeletedCertificateItem>((Page)response.body()){

            public Page<DeletedCertificateItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedCertificateItem>> getDeletedCertificatesAsync(String vaultBaseUrl, ListOperationCallback<DeletedCertificateItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedCertificatesSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedCertificateItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedCertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedCertificateItem>> getDeletedCertificatesAsync(String vaultBaseUrl) {
        return this.getDeletedCertificatesWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<DeletedCertificateItem>>, Page<DeletedCertificateItem>>(){

            public Page<DeletedCertificateItem> call(ServiceResponse<Page<DeletedCertificateItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedCertificateItem>>> getDeletedCertificatesWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getDeletedCertificatesSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedCertificateItem>>, Observable<ServiceResponse<Page<DeletedCertificateItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedCertificateItem>>> call(ServiceResponse<Page<DeletedCertificateItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedCertificateItem>>> getDeletedCertificatesSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        Boolean includePending = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedCertificates(maxresults, includePending, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedCertificateItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedCertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedCertificatesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<DeletedCertificateItem> getDeletedCertificates(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        ServiceResponse response = (ServiceResponse)this.getDeletedCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending).toBlocking().single();
        return new PagedList<DeletedCertificateItem>((Page)response.body()){

            public Page<DeletedCertificateItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedCertificateItem>> getDeletedCertificatesAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending, ListOperationCallback<DeletedCertificateItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedCertificateItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedCertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedCertificateItem>> getDeletedCertificatesAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        return this.getDeletedCertificatesWithServiceResponseAsync(vaultBaseUrl, maxresults, includePending).map((Func1)new Func1<ServiceResponse<Page<DeletedCertificateItem>>, Page<DeletedCertificateItem>>(){

            public Page<DeletedCertificateItem> call(ServiceResponse<Page<DeletedCertificateItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedCertificateItem>>> getDeletedCertificatesWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        return this.getDeletedCertificatesSinglePageAsync(vaultBaseUrl, maxresults, includePending).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedCertificateItem>>, Observable<ServiceResponse<Page<DeletedCertificateItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedCertificateItem>>> call(ServiceResponse<Page<DeletedCertificateItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedCertificateItem>>> getDeletedCertificatesSinglePageAsync(String vaultBaseUrl, Integer maxresults, Boolean includePending) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedCertificates(maxresults, includePending, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedCertificateItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedCertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedCertificatesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedCertificateItem>> getDeletedCertificatesDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedCertificateItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public DeletedCertificateBundle getDeletedCertificate(String vaultBaseUrl, String certificateName) {
        return (DeletedCertificateBundle)((ServiceResponse)this.getDeletedCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DeletedCertificateBundle> getDeletedCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<DeletedCertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDeletedCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    @Override
    public Observable<DeletedCertificateBundle> getDeletedCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.getDeletedCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<DeletedCertificateBundle>, DeletedCertificateBundle>(){

            public DeletedCertificateBundle call(ServiceResponse<DeletedCertificateBundle> response) {
                return (DeletedCertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DeletedCertificateBundle>> getDeletedCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedCertificateBundle>>>(){

            public Observable<ServiceResponse<DeletedCertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getDeletedCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedCertificateBundle> getDeletedCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeletedCertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public void purgeDeletedCertificate(String vaultBaseUrl, String certificateName) {
        ((ServiceResponse)this.purgeDeletedCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> purgeDeletedCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.purgeDeletedCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    @Override
    public Observable<Void> purgeDeletedCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.purgeDeletedCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> purgeDeletedCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.purgeDeletedCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.purgeDeletedCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> purgeDeletedCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public CertificateBundle recoverDeletedCertificate(String vaultBaseUrl, String certificateName) {
        return (CertificateBundle)((ServiceResponse)this.recoverDeletedCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CertificateBundle> recoverDeletedCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.recoverDeletedCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    @Override
    public Observable<CertificateBundle> recoverDeletedCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.recoverDeletedCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<CertificateBundle>> recoverDeletedCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.recoverDeletedCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.recoverDeletedCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> recoverDeletedCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<StorageAccountItem> getStorageAccounts(String vaultBaseUrl) {
        ServiceResponse response = (ServiceResponse)this.getStorageAccountsSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<StorageAccountItem>((Page)response.body()){

            public Page<StorageAccountItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getStorageAccountsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<StorageAccountItem>> getStorageAccountsAsync(String vaultBaseUrl, ListOperationCallback<StorageAccountItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getStorageAccountsSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<StorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getStorageAccountsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<StorageAccountItem>> getStorageAccountsAsync(String vaultBaseUrl) {
        return this.getStorageAccountsWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<StorageAccountItem>>, Page<StorageAccountItem>>(){

            public Page<StorageAccountItem> call(ServiceResponse<Page<StorageAccountItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<StorageAccountItem>>> getStorageAccountsWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getStorageAccountsSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<StorageAccountItem>>, Observable<ServiceResponse<Page<StorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountItem>>> call(ServiceResponse<Page<StorageAccountItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getStorageAccountsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageAccountItem>>> getStorageAccountsSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getStorageAccounts(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getStorageAccountsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<StorageAccountItem> getStorageAccounts(String vaultBaseUrl, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getStorageAccountsSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<StorageAccountItem>((Page)response.body()){

            public Page<StorageAccountItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getStorageAccountsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<StorageAccountItem>> getStorageAccountsAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<StorageAccountItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getStorageAccountsSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<StorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getStorageAccountsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<StorageAccountItem>> getStorageAccountsAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getStorageAccountsWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<StorageAccountItem>>, Page<StorageAccountItem>>(){

            public Page<StorageAccountItem> call(ServiceResponse<Page<StorageAccountItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<StorageAccountItem>>> getStorageAccountsWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getStorageAccountsSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<StorageAccountItem>>, Observable<ServiceResponse<Page<StorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountItem>>> call(ServiceResponse<Page<StorageAccountItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getStorageAccountsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageAccountItem>>> getStorageAccountsSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getStorageAccounts(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getStorageAccountsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<StorageAccountItem>> getStorageAccountsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<StorageAccountItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<DeletedStorageAccountItem> getDeletedStorageAccounts(String vaultBaseUrl) {
        ServiceResponse response = (ServiceResponse)this.getDeletedStorageAccountsSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<DeletedStorageAccountItem>((Page)response.body()){

            public Page<DeletedStorageAccountItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedStorageAccountsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedStorageAccountItem>> getDeletedStorageAccountsAsync(String vaultBaseUrl, ListOperationCallback<DeletedStorageAccountItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedStorageAccountsSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedStorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedStorageAccountsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedStorageAccountItem>> getDeletedStorageAccountsAsync(String vaultBaseUrl) {
        return this.getDeletedStorageAccountsWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<DeletedStorageAccountItem>>, Page<DeletedStorageAccountItem>>(){

            public Page<DeletedStorageAccountItem> call(ServiceResponse<Page<DeletedStorageAccountItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> getDeletedStorageAccountsWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getDeletedStorageAccountsSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedStorageAccountItem>>, Observable<ServiceResponse<Page<DeletedStorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> call(ServiceResponse<Page<DeletedStorageAccountItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedStorageAccountsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> getDeletedStorageAccountsSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedStorageAccounts(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedStorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedStorageAccountsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<DeletedStorageAccountItem> getDeletedStorageAccounts(String vaultBaseUrl, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getDeletedStorageAccountsSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<DeletedStorageAccountItem>((Page)response.body()){

            public Page<DeletedStorageAccountItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedStorageAccountsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedStorageAccountItem>> getDeletedStorageAccountsAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<DeletedStorageAccountItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedStorageAccountsSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedStorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedStorageAccountsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedStorageAccountItem>> getDeletedStorageAccountsAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getDeletedStorageAccountsWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<DeletedStorageAccountItem>>, Page<DeletedStorageAccountItem>>(){

            public Page<DeletedStorageAccountItem> call(ServiceResponse<Page<DeletedStorageAccountItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> getDeletedStorageAccountsWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getDeletedStorageAccountsSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedStorageAccountItem>>, Observable<ServiceResponse<Page<DeletedStorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> call(ServiceResponse<Page<DeletedStorageAccountItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedStorageAccountsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> getDeletedStorageAccountsSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedStorageAccounts(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedStorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedStorageAccountsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedStorageAccountItem>> getDeletedStorageAccountsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedStorageAccountItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public DeletedStorageBundle getDeletedStorageAccount(String vaultBaseUrl, String storageAccountName) {
        return (DeletedStorageBundle)((ServiceResponse)this.getDeletedStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DeletedStorageBundle> getDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName, ServiceCallback<DeletedStorageBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDeletedStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName), serviceCallback);
    }

    @Override
    public Observable<DeletedStorageBundle> getDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName) {
        return this.getDeletedStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).map((Func1)new Func1<ServiceResponse<DeletedStorageBundle>, DeletedStorageBundle>(){

            public DeletedStorageBundle call(ServiceResponse<DeletedStorageBundle> response) {
                return (DeletedStorageBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DeletedStorageBundle>> getDeletedStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedStorageAccount(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedStorageBundle>>>(){

            public Observable<ServiceResponse<DeletedStorageBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getDeletedStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedStorageBundle> getDeletedStorageAccountDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeletedStorageBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public void purgeDeletedStorageAccount(String vaultBaseUrl, String storageAccountName) {
        ((ServiceResponse)this.purgeDeletedStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> purgeDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.purgeDeletedStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName), serviceCallback);
    }

    @Override
    public Observable<Void> purgeDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName) {
        return this.purgeDeletedStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Void>> purgeDeletedStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.purgeDeletedStorageAccount(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.purgeDeletedStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> purgeDeletedStorageAccountDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public StorageBundle recoverDeletedStorageAccount(String vaultBaseUrl, String storageAccountName) {
        return (StorageBundle)((ServiceResponse)this.recoverDeletedStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<StorageBundle> recoverDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName, ServiceCallback<StorageBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.recoverDeletedStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName), serviceCallback);
    }

    @Override
    public Observable<StorageBundle> recoverDeletedStorageAccountAsync(String vaultBaseUrl, String storageAccountName) {
        return this.recoverDeletedStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).map((Func1)new Func1<ServiceResponse<StorageBundle>, StorageBundle>(){

            public StorageBundle call(ServiceResponse<StorageBundle> response) {
                return (StorageBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<StorageBundle>> recoverDeletedStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.recoverDeletedStorageAccount(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageBundle>>>(){

            public Observable<ServiceResponse<StorageBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.recoverDeletedStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageBundle> recoverDeletedStorageAccountDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<StorageBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public BackupStorageResult backupStorageAccount(String vaultBaseUrl, String storageAccountName) {
        return (BackupStorageResult)((ServiceResponse)this.backupStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<BackupStorageResult> backupStorageAccountAsync(String vaultBaseUrl, String storageAccountName, ServiceCallback<BackupStorageResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.backupStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName), serviceCallback);
    }

    @Override
    public Observable<BackupStorageResult> backupStorageAccountAsync(String vaultBaseUrl, String storageAccountName) {
        return this.backupStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).map((Func1)new Func1<ServiceResponse<BackupStorageResult>, BackupStorageResult>(){

            public BackupStorageResult call(ServiceResponse<BackupStorageResult> response) {
                return (BackupStorageResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<BackupStorageResult>> backupStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.backupStorageAccount(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupStorageResult>>>(){

            public Observable<ServiceResponse<BackupStorageResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.backupStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackupStorageResult> backupStorageAccountDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<BackupStorageResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public StorageBundle restoreStorageAccount(String vaultBaseUrl, byte[] storageBundleBackup) {
        return (StorageBundle)((ServiceResponse)this.restoreStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageBundleBackup).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<StorageBundle> restoreStorageAccountAsync(String vaultBaseUrl, byte[] storageBundleBackup, ServiceCallback<StorageBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.restoreStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageBundleBackup), serviceCallback);
    }

    @Override
    public Observable<StorageBundle> restoreStorageAccountAsync(String vaultBaseUrl, byte[] storageBundleBackup) {
        return this.restoreStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageBundleBackup).map((Func1)new Func1<ServiceResponse<StorageBundle>, StorageBundle>(){

            public StorageBundle call(ServiceResponse<StorageBundle> response) {
                return (StorageBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<StorageBundle>> restoreStorageAccountWithServiceResponseAsync(String vaultBaseUrl, byte[] storageBundleBackup) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (storageBundleBackup == null) {
            throw new IllegalArgumentException("Parameter storageBundleBackup is required and cannot be null.");
        }
        StorageRestoreParameters parameters = new StorageRestoreParameters();
        parameters.withStorageBundleBackup(storageBundleBackup);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.restoreStorageAccount(this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageBundle>>>(){

            public Observable<ServiceResponse<StorageBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.restoreStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageBundle> restoreStorageAccountDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<StorageBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public DeletedStorageBundle deleteStorageAccount(String vaultBaseUrl, String storageAccountName) {
        return (DeletedStorageBundle)((ServiceResponse)this.deleteStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DeletedStorageBundle> deleteStorageAccountAsync(String vaultBaseUrl, String storageAccountName, ServiceCallback<DeletedStorageBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName), serviceCallback);
    }

    @Override
    public Observable<DeletedStorageBundle> deleteStorageAccountAsync(String vaultBaseUrl, String storageAccountName) {
        return this.deleteStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).map((Func1)new Func1<ServiceResponse<DeletedStorageBundle>, DeletedStorageBundle>(){

            public DeletedStorageBundle call(ServiceResponse<DeletedStorageBundle> response) {
                return (DeletedStorageBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DeletedStorageBundle>> deleteStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteStorageAccount(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedStorageBundle>>>(){

            public Observable<ServiceResponse<DeletedStorageBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.deleteStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedStorageBundle> deleteStorageAccountDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeletedStorageBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public StorageBundle getStorageAccount(String vaultBaseUrl, String storageAccountName) {
        return (StorageBundle)((ServiceResponse)this.getStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<StorageBundle> getStorageAccountAsync(String vaultBaseUrl, String storageAccountName, ServiceCallback<StorageBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName), serviceCallback);
    }

    @Override
    public Observable<StorageBundle> getStorageAccountAsync(String vaultBaseUrl, String storageAccountName) {
        return this.getStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).map((Func1)new Func1<ServiceResponse<StorageBundle>, StorageBundle>(){

            public StorageBundle call(ServiceResponse<StorageBundle> response) {
                return (StorageBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<StorageBundle>> getStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getStorageAccount(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageBundle>>>(){

            public Observable<ServiceResponse<StorageBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageBundle> getStorageAccountDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<StorageBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public StorageBundle setStorageAccount(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey) {
        return (StorageBundle)((ServiceResponse)this.setStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName, resourceId, activeKeyName, autoRegenerateKey).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<StorageBundle> setStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey, ServiceCallback<StorageBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.setStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName, resourceId, activeKeyName, autoRegenerateKey), serviceCallback);
    }

    @Override
    public Observable<StorageBundle> setStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey) {
        return this.setStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName, resourceId, activeKeyName, autoRegenerateKey).map((Func1)new Func1<ServiceResponse<StorageBundle>, StorageBundle>(){

            public StorageBundle call(ServiceResponse<StorageBundle> response) {
                return (StorageBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<StorageBundle>> setStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId is required and cannot be null.");
        }
        if (activeKeyName == null) {
            throw new IllegalArgumentException("Parameter activeKeyName is required and cannot be null.");
        }
        Object regenerationPeriod = null;
        Object storageAccountAttributes = null;
        Object tags = null;
        StorageAccountCreateParameters parameters = new StorageAccountCreateParameters();
        parameters.withResourceId(resourceId);
        parameters.withActiveKeyName(activeKeyName);
        parameters.withAutoRegenerateKey(autoRegenerateKey);
        parameters.withRegenerationPeriod(null);
        parameters.withStorageAccountAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setStorageAccount(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageBundle>>>(){

            public Observable<ServiceResponse<StorageBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.setStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public StorageBundle setStorageAccount(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags) {
        return (StorageBundle)((ServiceResponse)this.setStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName, resourceId, activeKeyName, autoRegenerateKey, regenerationPeriod, storageAccountAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<StorageBundle> setStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags, ServiceCallback<StorageBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.setStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName, resourceId, activeKeyName, autoRegenerateKey, regenerationPeriod, storageAccountAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<StorageBundle> setStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags) {
        return this.setStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName, resourceId, activeKeyName, autoRegenerateKey, regenerationPeriod, storageAccountAttributes, tags).map((Func1)new Func1<ServiceResponse<StorageBundle>, StorageBundle>(){

            public StorageBundle call(ServiceResponse<StorageBundle> response) {
                return (StorageBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<StorageBundle>> setStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String resourceId, String activeKeyName, boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (resourceId == null) {
            throw new IllegalArgumentException("Parameter resourceId is required and cannot be null.");
        }
        if (activeKeyName == null) {
            throw new IllegalArgumentException("Parameter activeKeyName is required and cannot be null.");
        }
        Validator.validate((Object)storageAccountAttributes);
        Validator.validate(tags);
        StorageAccountCreateParameters parameters = new StorageAccountCreateParameters();
        parameters.withResourceId(resourceId);
        parameters.withActiveKeyName(activeKeyName);
        parameters.withAutoRegenerateKey(autoRegenerateKey);
        parameters.withRegenerationPeriod(regenerationPeriod);
        parameters.withStorageAccountAttributes(storageAccountAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setStorageAccount(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageBundle>>>(){

            public Observable<ServiceResponse<StorageBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.setStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageBundle> setStorageAccountDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<StorageBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public StorageBundle updateStorageAccount(String vaultBaseUrl, String storageAccountName) {
        return (StorageBundle)((ServiceResponse)this.updateStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<StorageBundle> updateStorageAccountAsync(String vaultBaseUrl, String storageAccountName, ServiceCallback<StorageBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName), serviceCallback);
    }

    @Override
    public Observable<StorageBundle> updateStorageAccountAsync(String vaultBaseUrl, String storageAccountName) {
        return this.updateStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName).map((Func1)new Func1<ServiceResponse<StorageBundle>, StorageBundle>(){

            public StorageBundle call(ServiceResponse<StorageBundle> response) {
                return (StorageBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<StorageBundle>> updateStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object activeKeyName = null;
        Object autoRegenerateKey = null;
        Object regenerationPeriod = null;
        Object storageAccountAttributes = null;
        Object tags = null;
        StorageAccountUpdateParameters parameters = new StorageAccountUpdateParameters();
        parameters.withActiveKeyName(null);
        parameters.withAutoRegenerateKey(null);
        parameters.withRegenerationPeriod(null);
        parameters.withStorageAccountAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateStorageAccount(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageBundle>>>(){

            public Observable<ServiceResponse<StorageBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public StorageBundle updateStorageAccount(String vaultBaseUrl, String storageAccountName, String activeKeyName, Boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags) {
        return (StorageBundle)((ServiceResponse)this.updateStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName, activeKeyName, autoRegenerateKey, regenerationPeriod, storageAccountAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<StorageBundle> updateStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String activeKeyName, Boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags, ServiceCallback<StorageBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName, activeKeyName, autoRegenerateKey, regenerationPeriod, storageAccountAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<StorageBundle> updateStorageAccountAsync(String vaultBaseUrl, String storageAccountName, String activeKeyName, Boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags) {
        return this.updateStorageAccountWithServiceResponseAsync(vaultBaseUrl, storageAccountName, activeKeyName, autoRegenerateKey, regenerationPeriod, storageAccountAttributes, tags).map((Func1)new Func1<ServiceResponse<StorageBundle>, StorageBundle>(){

            public StorageBundle call(ServiceResponse<StorageBundle> response) {
                return (StorageBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<StorageBundle>> updateStorageAccountWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String activeKeyName, Boolean autoRegenerateKey, String regenerationPeriod, StorageAccountAttributes storageAccountAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)storageAccountAttributes);
        Validator.validate(tags);
        StorageAccountUpdateParameters parameters = new StorageAccountUpdateParameters();
        parameters.withActiveKeyName(activeKeyName);
        parameters.withAutoRegenerateKey(autoRegenerateKey);
        parameters.withRegenerationPeriod(regenerationPeriod);
        parameters.withStorageAccountAttributes(storageAccountAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateStorageAccount(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageBundle>>>(){

            public Observable<ServiceResponse<StorageBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateStorageAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageBundle> updateStorageAccountDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<StorageBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public StorageBundle regenerateStorageAccountKey(String vaultBaseUrl, String storageAccountName, String keyName) {
        return (StorageBundle)((ServiceResponse)this.regenerateStorageAccountKeyWithServiceResponseAsync(vaultBaseUrl, storageAccountName, keyName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<StorageBundle> regenerateStorageAccountKeyAsync(String vaultBaseUrl, String storageAccountName, String keyName, ServiceCallback<StorageBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateStorageAccountKeyWithServiceResponseAsync(vaultBaseUrl, storageAccountName, keyName), serviceCallback);
    }

    @Override
    public Observable<StorageBundle> regenerateStorageAccountKeyAsync(String vaultBaseUrl, String storageAccountName, String keyName) {
        return this.regenerateStorageAccountKeyWithServiceResponseAsync(vaultBaseUrl, storageAccountName, keyName).map((Func1)new Func1<ServiceResponse<StorageBundle>, StorageBundle>(){

            public StorageBundle call(ServiceResponse<StorageBundle> response) {
                return (StorageBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<StorageBundle>> regenerateStorageAccountKeyWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String keyName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        StorageAccountRegenerteKeyParameters parameters = new StorageAccountRegenerteKeyParameters();
        parameters.withKeyName(keyName);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.regenerateStorageAccountKey(storageAccountName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageBundle>>>(){

            public Observable<ServiceResponse<StorageBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.regenerateStorageAccountKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageBundle> regenerateStorageAccountKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<StorageBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<SasDefinitionItem> getSasDefinitions(String vaultBaseUrl, String storageAccountName) {
        ServiceResponse response = (ServiceResponse)this.getSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName).toBlocking().single();
        return new PagedList<SasDefinitionItem>((Page)response.body()){

            public Page<SasDefinitionItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getSasDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SasDefinitionItem>> getSasDefinitionsAsync(String vaultBaseUrl, String storageAccountName, ListOperationCallback<SasDefinitionItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<SasDefinitionItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getSasDefinitionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SasDefinitionItem>> getSasDefinitionsAsync(String vaultBaseUrl, String storageAccountName) {
        return this.getSasDefinitionsWithServiceResponseAsync(vaultBaseUrl, storageAccountName).map((Func1)new Func1<ServiceResponse<Page<SasDefinitionItem>>, Page<SasDefinitionItem>>(){

            public Page<SasDefinitionItem> call(ServiceResponse<Page<SasDefinitionItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SasDefinitionItem>>> getSasDefinitionsWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName) {
        return this.getSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName).concatMap((Func1)new Func1<ServiceResponse<Page<SasDefinitionItem>>, Observable<ServiceResponse<Page<SasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<SasDefinitionItem>>> call(ServiceResponse<Page<SasDefinitionItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getSasDefinitionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SasDefinitionItem>>> getSasDefinitionsSinglePageAsync(String vaultBaseUrl, String storageAccountName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSasDefinitions(storageAccountName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<SasDefinitionItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getSasDefinitionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<SasDefinitionItem> getSasDefinitions(String vaultBaseUrl, String storageAccountName, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName, maxresults).toBlocking().single();
        return new PagedList<SasDefinitionItem>((Page)response.body()){

            public Page<SasDefinitionItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getSasDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SasDefinitionItem>> getSasDefinitionsAsync(String vaultBaseUrl, String storageAccountName, Integer maxresults, ListOperationCallback<SasDefinitionItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<SasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<SasDefinitionItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getSasDefinitionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SasDefinitionItem>> getSasDefinitionsAsync(String vaultBaseUrl, String storageAccountName, Integer maxresults) {
        return this.getSasDefinitionsWithServiceResponseAsync(vaultBaseUrl, storageAccountName, maxresults).map((Func1)new Func1<ServiceResponse<Page<SasDefinitionItem>>, Page<SasDefinitionItem>>(){

            public Page<SasDefinitionItem> call(ServiceResponse<Page<SasDefinitionItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SasDefinitionItem>>> getSasDefinitionsWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, Integer maxresults) {
        return this.getSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<SasDefinitionItem>>, Observable<ServiceResponse<Page<SasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<SasDefinitionItem>>> call(ServiceResponse<Page<SasDefinitionItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getSasDefinitionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SasDefinitionItem>>> getSasDefinitionsSinglePageAsync(String vaultBaseUrl, String storageAccountName, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSasDefinitions(storageAccountName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<SasDefinitionItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getSasDefinitionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SasDefinitionItem>> getSasDefinitionsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<SasDefinitionItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<DeletedSasDefinitionItem> getDeletedSasDefinitions(String vaultBaseUrl, String storageAccountName) {
        ServiceResponse response = (ServiceResponse)this.getDeletedSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName).toBlocking().single();
        return new PagedList<DeletedSasDefinitionItem>((Page)response.body()){

            public Page<DeletedSasDefinitionItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedSasDefinitionItem>> getDeletedSasDefinitionsAsync(String vaultBaseUrl, String storageAccountName, ListOperationCallback<DeletedSasDefinitionItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedSasDefinitionItem>> getDeletedSasDefinitionsAsync(String vaultBaseUrl, String storageAccountName) {
        return this.getDeletedSasDefinitionsWithServiceResponseAsync(vaultBaseUrl, storageAccountName).map((Func1)new Func1<ServiceResponse<Page<DeletedSasDefinitionItem>>, Page<DeletedSasDefinitionItem>>(){

            public Page<DeletedSasDefinitionItem> call(ServiceResponse<Page<DeletedSasDefinitionItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> getDeletedSasDefinitionsWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName) {
        return this.getDeletedSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedSasDefinitionItem>>, Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> call(ServiceResponse<Page<DeletedSasDefinitionItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> getDeletedSasDefinitionsSinglePageAsync(String vaultBaseUrl, String storageAccountName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedSasDefinitions(storageAccountName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<DeletedSasDefinitionItem> getDeletedSasDefinitions(String vaultBaseUrl, String storageAccountName, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.getDeletedSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName, maxresults).toBlocking().single();
        return new PagedList<DeletedSasDefinitionItem>((Page)response.body()){

            public Page<DeletedSasDefinitionItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedSasDefinitionItem>> getDeletedSasDefinitionsAsync(String vaultBaseUrl, String storageAccountName, Integer maxresults, ListOperationCallback<DeletedSasDefinitionItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedSasDefinitionItem>> getDeletedSasDefinitionsAsync(String vaultBaseUrl, String storageAccountName, Integer maxresults) {
        return this.getDeletedSasDefinitionsWithServiceResponseAsync(vaultBaseUrl, storageAccountName, maxresults).map((Func1)new Func1<ServiceResponse<Page<DeletedSasDefinitionItem>>, Page<DeletedSasDefinitionItem>>(){

            public Page<DeletedSasDefinitionItem> call(ServiceResponse<Page<DeletedSasDefinitionItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> getDeletedSasDefinitionsWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, Integer maxresults) {
        return this.getDeletedSasDefinitionsSinglePageAsync(vaultBaseUrl, storageAccountName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedSasDefinitionItem>>, Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> call(ServiceResponse<Page<DeletedSasDefinitionItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> getDeletedSasDefinitionsSinglePageAsync(String vaultBaseUrl, String storageAccountName, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedSasDefinitions(storageAccountName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedSasDefinitionItem>> getDeletedSasDefinitionsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedSasDefinitionItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public DeletedSasDefinitionBundle getDeletedSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        return (DeletedSasDefinitionBundle)((ServiceResponse)this.getDeletedSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DeletedSasDefinitionBundle> getDeletedSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, ServiceCallback<DeletedSasDefinitionBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDeletedSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName), serviceCallback);
    }

    @Override
    public Observable<DeletedSasDefinitionBundle> getDeletedSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        return this.getDeletedSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName).map((Func1)new Func1<ServiceResponse<DeletedSasDefinitionBundle>, DeletedSasDefinitionBundle>(){

            public DeletedSasDefinitionBundle call(ServiceResponse<DeletedSasDefinitionBundle> response) {
                return (DeletedSasDefinitionBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DeletedSasDefinitionBundle>> getDeletedSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (sasDefinitionName == null) {
            throw new IllegalArgumentException("Parameter sasDefinitionName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getDeletedSasDefinition(storageAccountName, sasDefinitionName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedSasDefinitionBundle>>>(){

            public Observable<ServiceResponse<DeletedSasDefinitionBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getDeletedSasDefinitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedSasDefinitionBundle> getDeletedSasDefinitionDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeletedSasDefinitionBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public SasDefinitionBundle recoverDeletedSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        return (SasDefinitionBundle)((ServiceResponse)this.recoverDeletedSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SasDefinitionBundle> recoverDeletedSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, ServiceCallback<SasDefinitionBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.recoverDeletedSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName), serviceCallback);
    }

    @Override
    public Observable<SasDefinitionBundle> recoverDeletedSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        return this.recoverDeletedSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName).map((Func1)new Func1<ServiceResponse<SasDefinitionBundle>, SasDefinitionBundle>(){

            public SasDefinitionBundle call(ServiceResponse<SasDefinitionBundle> response) {
                return (SasDefinitionBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SasDefinitionBundle>> recoverDeletedSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (sasDefinitionName == null) {
            throw new IllegalArgumentException("Parameter sasDefinitionName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.recoverDeletedSasDefinition(storageAccountName, sasDefinitionName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SasDefinitionBundle>>>(){

            public Observable<ServiceResponse<SasDefinitionBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.recoverDeletedSasDefinitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SasDefinitionBundle> recoverDeletedSasDefinitionDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SasDefinitionBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public DeletedSasDefinitionBundle deleteSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        return (DeletedSasDefinitionBundle)((ServiceResponse)this.deleteSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<DeletedSasDefinitionBundle> deleteSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, ServiceCallback<DeletedSasDefinitionBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName), serviceCallback);
    }

    @Override
    public Observable<DeletedSasDefinitionBundle> deleteSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        return this.deleteSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName).map((Func1)new Func1<ServiceResponse<DeletedSasDefinitionBundle>, DeletedSasDefinitionBundle>(){

            public DeletedSasDefinitionBundle call(ServiceResponse<DeletedSasDefinitionBundle> response) {
                return (DeletedSasDefinitionBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<DeletedSasDefinitionBundle>> deleteSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (sasDefinitionName == null) {
            throw new IllegalArgumentException("Parameter sasDefinitionName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteSasDefinition(storageAccountName, sasDefinitionName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeletedSasDefinitionBundle>>>(){

            public Observable<ServiceResponse<DeletedSasDefinitionBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.deleteSasDefinitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeletedSasDefinitionBundle> deleteSasDefinitionDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeletedSasDefinitionBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public SasDefinitionBundle getSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        return (SasDefinitionBundle)((ServiceResponse)this.getSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SasDefinitionBundle> getSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, ServiceCallback<SasDefinitionBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName), serviceCallback);
    }

    @Override
    public Observable<SasDefinitionBundle> getSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        return this.getSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName).map((Func1)new Func1<ServiceResponse<SasDefinitionBundle>, SasDefinitionBundle>(){

            public SasDefinitionBundle call(ServiceResponse<SasDefinitionBundle> response) {
                return (SasDefinitionBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SasDefinitionBundle>> getSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (sasDefinitionName == null) {
            throw new IllegalArgumentException("Parameter sasDefinitionName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSasDefinition(storageAccountName, sasDefinitionName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SasDefinitionBundle>>>(){

            public Observable<ServiceResponse<SasDefinitionBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.getSasDefinitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SasDefinitionBundle> getSasDefinitionDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SasDefinitionBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public SasDefinitionBundle setSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod) {
        return (SasDefinitionBundle)((ServiceResponse)this.setSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName, templateUri, sasType, validityPeriod).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SasDefinitionBundle> setSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, ServiceCallback<SasDefinitionBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.setSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName, templateUri, sasType, validityPeriod), serviceCallback);
    }

    @Override
    public Observable<SasDefinitionBundle> setSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod) {
        return this.setSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName, templateUri, sasType, validityPeriod).map((Func1)new Func1<ServiceResponse<SasDefinitionBundle>, SasDefinitionBundle>(){

            public SasDefinitionBundle call(ServiceResponse<SasDefinitionBundle> response) {
                return (SasDefinitionBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SasDefinitionBundle>> setSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (sasDefinitionName == null) {
            throw new IllegalArgumentException("Parameter sasDefinitionName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (templateUri == null) {
            throw new IllegalArgumentException("Parameter templateUri is required and cannot be null.");
        }
        if (sasType == null) {
            throw new IllegalArgumentException("Parameter sasType is required and cannot be null.");
        }
        if (validityPeriod == null) {
            throw new IllegalArgumentException("Parameter validityPeriod is required and cannot be null.");
        }
        Object sasDefinitionAttributes = null;
        Object tags = null;
        SasDefinitionCreateParameters parameters = new SasDefinitionCreateParameters();
        parameters.withTemplateUri(templateUri);
        parameters.withSasType(sasType);
        parameters.withValidityPeriod(validityPeriod);
        parameters.withSasDefinitionAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setSasDefinition(storageAccountName, sasDefinitionName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SasDefinitionBundle>>>(){

            public Observable<ServiceResponse<SasDefinitionBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.setSasDefinitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public SasDefinitionBundle setSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags) {
        return (SasDefinitionBundle)((ServiceResponse)this.setSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName, templateUri, sasType, validityPeriod, sasDefinitionAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SasDefinitionBundle> setSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags, ServiceCallback<SasDefinitionBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.setSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName, templateUri, sasType, validityPeriod, sasDefinitionAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<SasDefinitionBundle> setSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags) {
        return this.setSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName, templateUri, sasType, validityPeriod, sasDefinitionAttributes, tags).map((Func1)new Func1<ServiceResponse<SasDefinitionBundle>, SasDefinitionBundle>(){

            public SasDefinitionBundle call(ServiceResponse<SasDefinitionBundle> response) {
                return (SasDefinitionBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SasDefinitionBundle>> setSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (sasDefinitionName == null) {
            throw new IllegalArgumentException("Parameter sasDefinitionName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (templateUri == null) {
            throw new IllegalArgumentException("Parameter templateUri is required and cannot be null.");
        }
        if (sasType == null) {
            throw new IllegalArgumentException("Parameter sasType is required and cannot be null.");
        }
        if (validityPeriod == null) {
            throw new IllegalArgumentException("Parameter validityPeriod is required and cannot be null.");
        }
        Validator.validate((Object)sasDefinitionAttributes);
        Validator.validate(tags);
        SasDefinitionCreateParameters parameters = new SasDefinitionCreateParameters();
        parameters.withTemplateUri(templateUri);
        parameters.withSasType(sasType);
        parameters.withValidityPeriod(validityPeriod);
        parameters.withSasDefinitionAttributes(sasDefinitionAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setSasDefinition(storageAccountName, sasDefinitionName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SasDefinitionBundle>>>(){

            public Observable<ServiceResponse<SasDefinitionBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.setSasDefinitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SasDefinitionBundle> setSasDefinitionDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SasDefinitionBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public SasDefinitionBundle updateSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        return (SasDefinitionBundle)((ServiceResponse)this.updateSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SasDefinitionBundle> updateSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, ServiceCallback<SasDefinitionBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName), serviceCallback);
    }

    @Override
    public Observable<SasDefinitionBundle> updateSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        return this.updateSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName).map((Func1)new Func1<ServiceResponse<SasDefinitionBundle>, SasDefinitionBundle>(){

            public SasDefinitionBundle call(ServiceResponse<SasDefinitionBundle> response) {
                return (SasDefinitionBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SasDefinitionBundle>> updateSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (sasDefinitionName == null) {
            throw new IllegalArgumentException("Parameter sasDefinitionName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object templateUri = null;
        Object sasType = null;
        Object validityPeriod = null;
        Object sasDefinitionAttributes = null;
        Object tags = null;
        SasDefinitionUpdateParameters parameters = new SasDefinitionUpdateParameters();
        parameters.withTemplateUri(null);
        parameters.withSasType(null);
        parameters.withValidityPeriod(null);
        parameters.withSasDefinitionAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateSasDefinition(storageAccountName, sasDefinitionName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SasDefinitionBundle>>>(){

            public Observable<ServiceResponse<SasDefinitionBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateSasDefinitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public SasDefinitionBundle updateSasDefinition(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags) {
        return (SasDefinitionBundle)((ServiceResponse)this.updateSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName, templateUri, sasType, validityPeriod, sasDefinitionAttributes, tags).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<SasDefinitionBundle> updateSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags, ServiceCallback<SasDefinitionBundle> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName, templateUri, sasType, validityPeriod, sasDefinitionAttributes, tags), serviceCallback);
    }

    @Override
    public Observable<SasDefinitionBundle> updateSasDefinitionAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags) {
        return this.updateSasDefinitionWithServiceResponseAsync(vaultBaseUrl, storageAccountName, sasDefinitionName, templateUri, sasType, validityPeriod, sasDefinitionAttributes, tags).map((Func1)new Func1<ServiceResponse<SasDefinitionBundle>, SasDefinitionBundle>(){

            public SasDefinitionBundle call(ServiceResponse<SasDefinitionBundle> response) {
                return (SasDefinitionBundle)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<SasDefinitionBundle>> updateSasDefinitionWithServiceResponseAsync(String vaultBaseUrl, String storageAccountName, String sasDefinitionName, String templateUri, SasTokenType sasType, String validityPeriod, SasDefinitionAttributes sasDefinitionAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (storageAccountName == null) {
            throw new IllegalArgumentException("Parameter storageAccountName is required and cannot be null.");
        }
        if (sasDefinitionName == null) {
            throw new IllegalArgumentException("Parameter sasDefinitionName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)sasDefinitionAttributes);
        Validator.validate(tags);
        SasDefinitionUpdateParameters parameters = new SasDefinitionUpdateParameters();
        parameters.withTemplateUri(templateUri);
        parameters.withSasType(sasType);
        parameters.withValidityPeriod(validityPeriod);
        parameters.withSasDefinitionAttributes(sasDefinitionAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateSasDefinition(storageAccountName, sasDefinitionName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SasDefinitionBundle>>>(){

            public Observable<ServiceResponse<SasDefinitionBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientBaseImpl.this.updateSasDefinitionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SasDefinitionBundle> updateSasDefinitionDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SasDefinitionBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<KeyItem> getKeyVersionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getKeyVersionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.body()){

            public Page<KeyItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<KeyItem>> getKeyVersionsNextAsync(String nextPageLink, ServiceFuture<List<KeyItem>> serviceFuture, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getKeyVersionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<KeyItem>> getKeyVersionsNextAsync(String nextPageLink) {
        return this.getKeyVersionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getKeyVersionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getKeyVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getKeyVersionsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getKeyVersionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<KeyItem>> getKeyVersionsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<KeyItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<KeyItem> getKeysNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getKeysNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.body()){

            public Page<KeyItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getKeysNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<KeyItem>> getKeysNextAsync(String nextPageLink, ServiceFuture<List<KeyItem>> serviceFuture, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getKeysNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getKeysNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<KeyItem>> getKeysNextAsync(String nextPageLink) {
        return this.getKeysNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<KeyItem>>> getKeysNextWithServiceResponseAsync(String nextPageLink) {
        return this.getKeysNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getKeysNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeysNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getKeysNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getKeysNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<KeyItem>> getKeysNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<KeyItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<DeletedKeyItem> getDeletedKeysNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getDeletedKeysNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeletedKeyItem>((Page)response.body()){

            public Page<DeletedKeyItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedKeysNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedKeyItem>> getDeletedKeysNextAsync(String nextPageLink, ServiceFuture<List<DeletedKeyItem>> serviceFuture, ListOperationCallback<DeletedKeyItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedKeysNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedKeyItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedKeyItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedKeysNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedKeyItem>> getDeletedKeysNextAsync(String nextPageLink) {
        return this.getDeletedKeysNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeletedKeyItem>>, Page<DeletedKeyItem>>(){

            public Page<DeletedKeyItem> call(ServiceResponse<Page<DeletedKeyItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedKeyItem>>> getDeletedKeysNextWithServiceResponseAsync(String nextPageLink) {
        return this.getDeletedKeysNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedKeyItem>>, Observable<ServiceResponse<Page<DeletedKeyItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedKeyItem>>> call(ServiceResponse<Page<DeletedKeyItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedKeysNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedKeyItem>>> getDeletedKeysNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getDeletedKeysNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedKeyItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedKeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedKeysNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedKeyItem>> getDeletedKeysNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedKeyItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<SecretItem> getSecretsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getSecretsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.body()){

            public Page<SecretItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getSecretsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SecretItem>> getSecretsNextAsync(String nextPageLink, ServiceFuture<List<SecretItem>> serviceFuture, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSecretsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getSecretsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SecretItem>> getSecretsNextAsync(String nextPageLink) {
        return this.getSecretsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getSecretsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getSecretsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getSecretsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getSecretsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecretItem>> getSecretsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<SecretItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<SecretItem> getSecretVersionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getSecretVersionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.body()){

            public Page<SecretItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SecretItem>> getSecretVersionsNextAsync(String nextPageLink, ServiceFuture<List<SecretItem>> serviceFuture, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSecretVersionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SecretItem>> getSecretVersionsNextAsync(String nextPageLink) {
        return this.getSecretVersionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getSecretVersionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getSecretVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getSecretVersionsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getSecretVersionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecretItem>> getSecretVersionsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<SecretItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<DeletedSecretItem> getDeletedSecretsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getDeletedSecretsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeletedSecretItem>((Page)response.body()){

            public Page<DeletedSecretItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedSecretsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedSecretItem>> getDeletedSecretsNextAsync(String nextPageLink, ServiceFuture<List<DeletedSecretItem>> serviceFuture, ListOperationCallback<DeletedSecretItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedSecretsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedSecretItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSecretItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedSecretsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedSecretItem>> getDeletedSecretsNextAsync(String nextPageLink) {
        return this.getDeletedSecretsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeletedSecretItem>>, Page<DeletedSecretItem>>(){

            public Page<DeletedSecretItem> call(ServiceResponse<Page<DeletedSecretItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedSecretItem>>> getDeletedSecretsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getDeletedSecretsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedSecretItem>>, Observable<ServiceResponse<Page<DeletedSecretItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSecretItem>>> call(ServiceResponse<Page<DeletedSecretItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedSecretsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedSecretItem>>> getDeletedSecretsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getDeletedSecretsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedSecretItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedSecretsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedSecretItem>> getDeletedSecretsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedSecretItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<CertificateItem> getCertificatesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.body()){

            public Page<CertificateItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CertificateItem>> getCertificatesNextAsync(String nextPageLink, ServiceFuture<List<CertificateItem>> serviceFuture, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getCertificatesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CertificateItem>> getCertificatesNextAsync(String nextPageLink) {
        return this.getCertificatesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesNextWithServiceResponseAsync(String nextPageLink) {
        return this.getCertificatesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getCertificatesNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getCertificatesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateItem>> getCertificatesNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<CertificateItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<CertificateIssuerItem> getCertificateIssuersNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getCertificateIssuersNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CertificateIssuerItem>((Page)response.body()){

            public Page<CertificateIssuerItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CertificateIssuerItem>> getCertificateIssuersNextAsync(String nextPageLink, ServiceFuture<List<CertificateIssuerItem>> serviceFuture, ListOperationCallback<CertificateIssuerItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getCertificateIssuersNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CertificateIssuerItem>> getCertificateIssuersNextAsync(String nextPageLink) {
        return this.getCertificateIssuersNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Page<CertificateIssuerItem>>(){

            public Page<CertificateIssuerItem> call(ServiceResponse<Page<CertificateIssuerItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersNextWithServiceResponseAsync(String nextPageLink) {
        return this.getCertificateIssuersNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(ServiceResponse<Page<CertificateIssuerItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getCertificateIssuersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getCertificateIssuersNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getCertificateIssuersNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateIssuerItem>> getCertificateIssuersNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<CertificateIssuerItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<CertificateItem> getCertificateVersionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getCertificateVersionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.body()){

            public Page<CertificateItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CertificateItem>> getCertificateVersionsNextAsync(String nextPageLink, ServiceFuture<List<CertificateItem>> serviceFuture, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getCertificateVersionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CertificateItem>> getCertificateVersionsNextAsync(String nextPageLink) {
        return this.getCertificateVersionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getCertificateVersionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getCertificateVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getCertificateVersionsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getCertificateVersionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateItem>> getCertificateVersionsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<CertificateItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<DeletedCertificateItem> getDeletedCertificatesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getDeletedCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeletedCertificateItem>((Page)response.body()){

            public Page<DeletedCertificateItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedCertificateItem>> getDeletedCertificatesNextAsync(String nextPageLink, ServiceFuture<List<DeletedCertificateItem>> serviceFuture, ListOperationCallback<DeletedCertificateItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedCertificatesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedCertificateItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedCertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedCertificateItem>> getDeletedCertificatesNextAsync(String nextPageLink) {
        return this.getDeletedCertificatesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeletedCertificateItem>>, Page<DeletedCertificateItem>>(){

            public Page<DeletedCertificateItem> call(ServiceResponse<Page<DeletedCertificateItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedCertificateItem>>> getDeletedCertificatesNextWithServiceResponseAsync(String nextPageLink) {
        return this.getDeletedCertificatesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedCertificateItem>>, Observable<ServiceResponse<Page<DeletedCertificateItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedCertificateItem>>> call(ServiceResponse<Page<DeletedCertificateItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedCertificateItem>>> getDeletedCertificatesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getDeletedCertificatesNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedCertificateItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedCertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedCertificatesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedCertificateItem>> getDeletedCertificatesNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedCertificateItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<StorageAccountItem> getStorageAccountsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getStorageAccountsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<StorageAccountItem>((Page)response.body()){

            public Page<StorageAccountItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getStorageAccountsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<StorageAccountItem>> getStorageAccountsNextAsync(String nextPageLink, ServiceFuture<List<StorageAccountItem>> serviceFuture, ListOperationCallback<StorageAccountItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getStorageAccountsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<StorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getStorageAccountsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<StorageAccountItem>> getStorageAccountsNextAsync(String nextPageLink) {
        return this.getStorageAccountsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<StorageAccountItem>>, Page<StorageAccountItem>>(){

            public Page<StorageAccountItem> call(ServiceResponse<Page<StorageAccountItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<StorageAccountItem>>> getStorageAccountsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getStorageAccountsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<StorageAccountItem>>, Observable<ServiceResponse<Page<StorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountItem>>> call(ServiceResponse<Page<StorageAccountItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getStorageAccountsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageAccountItem>>> getStorageAccountsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getStorageAccountsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getStorageAccountsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<StorageAccountItem>> getStorageAccountsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<StorageAccountItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<DeletedStorageAccountItem> getDeletedStorageAccountsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getDeletedStorageAccountsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeletedStorageAccountItem>((Page)response.body()){

            public Page<DeletedStorageAccountItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedStorageAccountsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedStorageAccountItem>> getDeletedStorageAccountsNextAsync(String nextPageLink, ServiceFuture<List<DeletedStorageAccountItem>> serviceFuture, ListOperationCallback<DeletedStorageAccountItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedStorageAccountsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedStorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedStorageAccountsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedStorageAccountItem>> getDeletedStorageAccountsNextAsync(String nextPageLink) {
        return this.getDeletedStorageAccountsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeletedStorageAccountItem>>, Page<DeletedStorageAccountItem>>(){

            public Page<DeletedStorageAccountItem> call(ServiceResponse<Page<DeletedStorageAccountItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> getDeletedStorageAccountsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getDeletedStorageAccountsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedStorageAccountItem>>, Observable<ServiceResponse<Page<DeletedStorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> call(ServiceResponse<Page<DeletedStorageAccountItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedStorageAccountsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> getDeletedStorageAccountsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getDeletedStorageAccountsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedStorageAccountItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedStorageAccountItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedStorageAccountsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedStorageAccountItem>> getDeletedStorageAccountsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedStorageAccountItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<SasDefinitionItem> getSasDefinitionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getSasDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SasDefinitionItem>((Page)response.body()){

            public Page<SasDefinitionItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getSasDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<SasDefinitionItem>> getSasDefinitionsNextAsync(String nextPageLink, ServiceFuture<List<SasDefinitionItem>> serviceFuture, ListOperationCallback<SasDefinitionItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSasDefinitionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<SasDefinitionItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getSasDefinitionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<SasDefinitionItem>> getSasDefinitionsNextAsync(String nextPageLink) {
        return this.getSasDefinitionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SasDefinitionItem>>, Page<SasDefinitionItem>>(){

            public Page<SasDefinitionItem> call(ServiceResponse<Page<SasDefinitionItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<SasDefinitionItem>>> getSasDefinitionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getSasDefinitionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SasDefinitionItem>>, Observable<ServiceResponse<Page<SasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<SasDefinitionItem>>> call(ServiceResponse<Page<SasDefinitionItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getSasDefinitionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SasDefinitionItem>>> getSasDefinitionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getSasDefinitionsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<SasDefinitionItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getSasDefinitionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SasDefinitionItem>> getSasDefinitionsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<SasDefinitionItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    @Override
    public PagedList<DeletedSasDefinitionItem> getDeletedSasDefinitionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getDeletedSasDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DeletedSasDefinitionItem>((Page)response.body()){

            public Page<DeletedSasDefinitionItem> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<DeletedSasDefinitionItem>> getDeletedSasDefinitionsNextAsync(String nextPageLink, ServiceFuture<List<DeletedSasDefinitionItem>> serviceFuture, ListOperationCallback<DeletedSasDefinitionItem> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getDeletedSasDefinitionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> call(String nextPageLink) {
                return KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<DeletedSasDefinitionItem>> getDeletedSasDefinitionsNextAsync(String nextPageLink) {
        return this.getDeletedSasDefinitionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DeletedSasDefinitionItem>>, Page<DeletedSasDefinitionItem>>(){

            public Page<DeletedSasDefinitionItem> call(ServiceResponse<Page<DeletedSasDefinitionItem>> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> getDeletedSasDefinitionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getDeletedSasDefinitionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DeletedSasDefinitionItem>>, Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> call(ServiceResponse<Page<DeletedSasDefinitionItem>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> getDeletedSasDefinitionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getDeletedSasDefinitionsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>>>(){

            public Observable<ServiceResponse<Page<DeletedSasDefinitionItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientBaseImpl.this.getDeletedSasDefinitionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse((Object)((Page)result.body()), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DeletedSasDefinitionItem>> getDeletedSasDefinitionsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<DeletedSasDefinitionItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    static interface KeyVaultClientBaseService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase createKey"})
        @POST(value="keys/{key-name}/create")
        public Observable<Response<ResponseBody>> createKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body KeyCreateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase importKey"})
        @PUT(value="keys/{key-name}")
        public Observable<Response<ResponseBody>> importKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body KeyImportParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase deleteKey"})
        @HTTP(path="keys/{key-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase updateKey"})
        @PATCH(value="keys/{key-name}/{key-version}")
        public Observable<Response<ResponseBody>> updateKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyUpdateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getKey"})
        @GET(value="keys/{key-name}/{key-version}")
        public Observable<Response<ResponseBody>> getKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getKeyVersions"})
        @GET(value="keys/{key-name}/versions")
        public Observable<Response<ResponseBody>> getKeyVersions(@Path(value="key-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getKeys"})
        @GET(value="keys")
        public Observable<Response<ResponseBody>> getKeys(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase backupKey"})
        @POST(value="keys/{key-name}/backup")
        public Observable<Response<ResponseBody>> backupKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase restoreKey"})
        @POST(value="keys/restore")
        public Observable<Response<ResponseBody>> restoreKey(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Body KeyRestoreParameters var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase encrypt"})
        @POST(value="keys/{key-name}/{key-version}/encrypt")
        public Observable<Response<ResponseBody>> encrypt(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase decrypt"})
        @POST(value="keys/{key-name}/{key-version}/decrypt")
        public Observable<Response<ResponseBody>> decrypt(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase sign"})
        @POST(value="keys/{key-name}/{key-version}/sign")
        public Observable<Response<ResponseBody>> sign(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeySignParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase verify"})
        @POST(value="keys/{key-name}/{key-version}/verify")
        public Observable<Response<ResponseBody>> verify(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyVerifyParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase wrapKey"})
        @POST(value="keys/{key-name}/{key-version}/wrapkey")
        public Observable<Response<ResponseBody>> wrapKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase unwrapKey"})
        @POST(value="keys/{key-name}/{key-version}/unwrapkey")
        public Observable<Response<ResponseBody>> unwrapKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedKeys"})
        @GET(value="deletedkeys")
        public Observable<Response<ResponseBody>> getDeletedKeys(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedKey"})
        @GET(value="deletedkeys/{key-name}")
        public Observable<Response<ResponseBody>> getDeletedKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase purgeDeletedKey"})
        @HTTP(path="deletedkeys/{key-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> purgeDeletedKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase recoverDeletedKey"})
        @POST(value="deletedkeys/{key-name}/recover")
        public Observable<Response<ResponseBody>> recoverDeletedKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase setSecret"})
        @PUT(value="secrets/{secret-name}")
        public Observable<Response<ResponseBody>> setSecret(@Path(value="secret-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body SecretSetParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase deleteSecret"})
        @HTTP(path="secrets/{secret-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSecret(@Path(value="secret-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase updateSecret"})
        @PATCH(value="secrets/{secret-name}/{secret-version}")
        public Observable<Response<ResponseBody>> updateSecret(@Path(value="secret-name") String var1, @Path(value="secret-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body SecretUpdateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getSecret"})
        @GET(value="secrets/{secret-name}/{secret-version}")
        public Observable<Response<ResponseBody>> getSecret(@Path(value="secret-name") String var1, @Path(value="secret-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getSecrets"})
        @GET(value="secrets")
        public Observable<Response<ResponseBody>> getSecrets(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getSecretVersions"})
        @GET(value="secrets/{secret-name}/versions")
        public Observable<Response<ResponseBody>> getSecretVersions(@Path(value="secret-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedSecrets"})
        @GET(value="deletedsecrets")
        public Observable<Response<ResponseBody>> getDeletedSecrets(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedSecret"})
        @GET(value="deletedsecrets/{secret-name}")
        public Observable<Response<ResponseBody>> getDeletedSecret(@Path(value="secret-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase purgeDeletedSecret"})
        @HTTP(path="deletedsecrets/{secret-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> purgeDeletedSecret(@Path(value="secret-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase recoverDeletedSecret"})
        @POST(value="deletedsecrets/{secret-name}/recover")
        public Observable<Response<ResponseBody>> recoverDeletedSecret(@Path(value="secret-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase backupSecret"})
        @POST(value="secrets/{secret-name}/backup")
        public Observable<Response<ResponseBody>> backupSecret(@Path(value="secret-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase restoreSecret"})
        @POST(value="secrets/restore")
        public Observable<Response<ResponseBody>> restoreSecret(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Body SecretRestoreParameters var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificates"})
        @GET(value="certificates")
        public Observable<Response<ResponseBody>> getCertificates(@Query(value="maxresults") Integer var1, @Query(value="includePending") Boolean var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase deleteCertificate"})
        @HTTP(path="certificates/{certificate-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase setCertificateContacts"})
        @PUT(value="certificates/contacts")
        public Observable<Response<ResponseBody>> setCertificateContacts(@Body Contacts var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificateContacts"})
        @GET(value="certificates/contacts")
        public Observable<Response<ResponseBody>> getCertificateContacts(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="x-ms-parameterized-host") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase deleteCertificateContacts"})
        @HTTP(path="certificates/contacts", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificateContacts(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="x-ms-parameterized-host") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificateIssuers"})
        @GET(value="certificates/issuers")
        public Observable<Response<ResponseBody>> getCertificateIssuers(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase setCertificateIssuer"})
        @PUT(value="certificates/issuers/{issuer-name}")
        public Observable<Response<ResponseBody>> setCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateIssuerSetParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase updateCertificateIssuer"})
        @PATCH(value="certificates/issuers/{issuer-name}")
        public Observable<Response<ResponseBody>> updateCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateIssuerUpdateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificateIssuer"})
        @GET(value="certificates/issuers/{issuer-name}")
        public Observable<Response<ResponseBody>> getCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase deleteCertificateIssuer"})
        @HTTP(path="certificates/issuers/{issuer-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase createCertificate"})
        @POST(value="certificates/{certificate-name}/create")
        public Observable<Response<ResponseBody>> createCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateCreateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase importCertificate"})
        @POST(value="certificates/{certificate-name}/import")
        public Observable<Response<ResponseBody>> importCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateImportParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificateVersions"})
        @GET(value="certificates/{certificate-name}/versions")
        public Observable<Response<ResponseBody>> getCertificateVersions(@Path(value="certificate-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificatePolicy"})
        @GET(value="certificates/{certificate-name}/policy")
        public Observable<Response<ResponseBody>> getCertificatePolicy(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase updateCertificatePolicy"})
        @PATCH(value="certificates/{certificate-name}/policy")
        public Observable<Response<ResponseBody>> updateCertificatePolicy(@Path(value="certificate-name") String var1, @Body CertificatePolicy var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase updateCertificate"})
        @PATCH(value="certificates/{certificate-name}/{certificate-version}")
        public Observable<Response<ResponseBody>> updateCertificate(@Path(value="certificate-name") String var1, @Path(value="certificate-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body CertificateUpdateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificate"})
        @GET(value="certificates/{certificate-name}/{certificate-version}")
        public Observable<Response<ResponseBody>> getCertificate(@Path(value="certificate-name") String var1, @Path(value="certificate-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase updateCertificateOperation"})
        @PATCH(value="certificates/{certificate-name}/pending")
        public Observable<Response<ResponseBody>> updateCertificateOperation(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateOperationUpdateParameter var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificateOperation"})
        @GET(value="certificates/{certificate-name}/pending")
        public Observable<Response<ResponseBody>> getCertificateOperation(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase deleteCertificateOperation"})
        @HTTP(path="certificates/{certificate-name}/pending", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificateOperation(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase mergeCertificate"})
        @POST(value="certificates/{certificate-name}/pending/merge")
        public Observable<Response<ResponseBody>> mergeCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateMergeParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase backupCertificate"})
        @POST(value="certificates/{certificate-name}/backup")
        public Observable<Response<ResponseBody>> backupCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase restoreCertificate"})
        @POST(value="certificates/restore")
        public Observable<Response<ResponseBody>> restoreCertificate(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Body CertificateRestoreParameters var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedCertificates"})
        @GET(value="deletedcertificates")
        public Observable<Response<ResponseBody>> getDeletedCertificates(@Query(value="maxresults") Integer var1, @Query(value="includePending") Boolean var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedCertificate"})
        @GET(value="deletedcertificates/{certificate-name}")
        public Observable<Response<ResponseBody>> getDeletedCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase purgeDeletedCertificate"})
        @HTTP(path="deletedcertificates/{certificate-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> purgeDeletedCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase recoverDeletedCertificate"})
        @POST(value="deletedcertificates/{certificate-name}/recover")
        public Observable<Response<ResponseBody>> recoverDeletedCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getStorageAccounts"})
        @GET(value="storage")
        public Observable<Response<ResponseBody>> getStorageAccounts(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedStorageAccounts"})
        @GET(value="deletedstorage")
        public Observable<Response<ResponseBody>> getDeletedStorageAccounts(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedStorageAccount"})
        @GET(value="deletedstorage/{storage-account-name}")
        public Observable<Response<ResponseBody>> getDeletedStorageAccount(@Path(value="storage-account-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase purgeDeletedStorageAccount"})
        @HTTP(path="deletedstorage/{storage-account-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> purgeDeletedStorageAccount(@Path(value="storage-account-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase recoverDeletedStorageAccount"})
        @POST(value="deletedstorage/{storage-account-name}/recover")
        public Observable<Response<ResponseBody>> recoverDeletedStorageAccount(@Path(value="storage-account-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase backupStorageAccount"})
        @POST(value="storage/{storage-account-name}/backup")
        public Observable<Response<ResponseBody>> backupStorageAccount(@Path(value="storage-account-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase restoreStorageAccount"})
        @POST(value="storage/restore")
        public Observable<Response<ResponseBody>> restoreStorageAccount(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Body StorageRestoreParameters var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase deleteStorageAccount"})
        @HTTP(path="storage/{storage-account-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteStorageAccount(@Path(value="storage-account-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getStorageAccount"})
        @GET(value="storage/{storage-account-name}")
        public Observable<Response<ResponseBody>> getStorageAccount(@Path(value="storage-account-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase setStorageAccount"})
        @PUT(value="storage/{storage-account-name}")
        public Observable<Response<ResponseBody>> setStorageAccount(@Path(value="storage-account-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body StorageAccountCreateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase updateStorageAccount"})
        @PATCH(value="storage/{storage-account-name}")
        public Observable<Response<ResponseBody>> updateStorageAccount(@Path(value="storage-account-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body StorageAccountUpdateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase regenerateStorageAccountKey"})
        @POST(value="storage/{storage-account-name}/regeneratekey")
        public Observable<Response<ResponseBody>> regenerateStorageAccountKey(@Path(value="storage-account-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body StorageAccountRegenerteKeyParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getSasDefinitions"})
        @GET(value="storage/{storage-account-name}/sas")
        public Observable<Response<ResponseBody>> getSasDefinitions(@Path(value="storage-account-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedSasDefinitions"})
        @GET(value="deletedstorage/{storage-account-name}/sas")
        public Observable<Response<ResponseBody>> getDeletedSasDefinitions(@Path(value="storage-account-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedSasDefinition"})
        @GET(value="deletedstorage/{storage-account-name}/sas/{sas-definition-name}")
        public Observable<Response<ResponseBody>> getDeletedSasDefinition(@Path(value="storage-account-name") String var1, @Path(value="sas-definition-name") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase recoverDeletedSasDefinition"})
        @POST(value="deletedstorage/{storage-account-name}/sas/{sas-definition-name}/recover")
        public Observable<Response<ResponseBody>> recoverDeletedSasDefinition(@Path(value="storage-account-name") String var1, @Path(value="sas-definition-name") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase deleteSasDefinition"})
        @HTTP(path="storage/{storage-account-name}/sas/{sas-definition-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSasDefinition(@Path(value="storage-account-name") String var1, @Path(value="sas-definition-name") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getSasDefinition"})
        @GET(value="storage/{storage-account-name}/sas/{sas-definition-name}")
        public Observable<Response<ResponseBody>> getSasDefinition(@Path(value="storage-account-name") String var1, @Path(value="sas-definition-name") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase setSasDefinition"})
        @PUT(value="storage/{storage-account-name}/sas/{sas-definition-name}")
        public Observable<Response<ResponseBody>> setSasDefinition(@Path(value="storage-account-name") String var1, @Path(value="sas-definition-name") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body SasDefinitionCreateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase updateSasDefinition"})
        @PATCH(value="storage/{storage-account-name}/sas/{sas-definition-name}")
        public Observable<Response<ResponseBody>> updateSasDefinition(@Path(value="storage-account-name") String var1, @Path(value="sas-definition-name") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body SasDefinitionUpdateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getKeyVersionsNext"})
        @GET
        public Observable<Response<ResponseBody>> getKeyVersionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getKeysNext"})
        @GET
        public Observable<Response<ResponseBody>> getKeysNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedKeysNext"})
        @GET
        public Observable<Response<ResponseBody>> getDeletedKeysNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getSecretsNext"})
        @GET
        public Observable<Response<ResponseBody>> getSecretsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getSecretVersionsNext"})
        @GET
        public Observable<Response<ResponseBody>> getSecretVersionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedSecretsNext"})
        @GET
        public Observable<Response<ResponseBody>> getDeletedSecretsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificatesNext"})
        @GET
        public Observable<Response<ResponseBody>> getCertificatesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificateIssuersNext"})
        @GET
        public Observable<Response<ResponseBody>> getCertificateIssuersNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getCertificateVersionsNext"})
        @GET
        public Observable<Response<ResponseBody>> getCertificateVersionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedCertificatesNext"})
        @GET
        public Observable<Response<ResponseBody>> getDeletedCertificatesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getStorageAccountsNext"})
        @GET
        public Observable<Response<ResponseBody>> getStorageAccountsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedStorageAccountsNext"})
        @GET
        public Observable<Response<ResponseBody>> getDeletedStorageAccountsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getSasDefinitionsNext"})
        @GET
        public Observable<Response<ResponseBody>> getSasDefinitionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.keyvault.KeyVaultClientBase getDeletedSasDefinitionsNext"})
        @GET
        public Observable<Response<ResponseBody>> getDeletedSasDefinitionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

