/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.requests;

import com.microsoft.azure.keyvault.models.Attributes;
import com.microsoft.azure.keyvault.models.CertificateAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class MergeCertificateRequest {
    private final String vaultBaseUrl;
    private final String certificateName;
    private final List<byte[]> x509Certificates;
    private final CertificateAttributes certificateAttributes;
    private final Map<String, String> tags;

    private MergeCertificateRequest(Builder builder) {
        this.vaultBaseUrl = builder.vaultBaseUrl;
        this.certificateName = builder.certificateName;
        this.x509Certificates = new ArrayList<byte[]>(builder.x509Certificates);
        this.certificateAttributes = builder.attributes != null ? (CertificateAttributes)new CertificateAttributes().withNotBefore(builder.attributes.notBefore()).withEnabled(builder.attributes.enabled()).withExpires(builder.attributes.expires()) : null;
        this.tags = builder.tags != null ? Collections.unmodifiableMap(builder.tags) : null;
    }

    public String vaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public List<byte[]> x509Certificates() {
        return this.x509Certificates;
    }

    public CertificateAttributes certificateAttributes() {
        return this.certificateAttributes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public static class Builder {
        private final String vaultBaseUrl;
        private final String certificateName;
        private final List<byte[]> x509Certificates;
        private CertificateAttributes attributes;
        private Map<String, String> tags;

        public Builder(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates) {
            this.vaultBaseUrl = vaultBaseUrl;
            this.certificateName = certificateName;
            this.x509Certificates = x509Certificates;
        }

        public Builder withAttributes(Attributes attributes) {
            if (!(attributes instanceof CertificateAttributes)) {
                throw new IllegalArgumentException("Parameter 'attributes' should be instance of CertificateAttributes, or a subclass");
            }
            this.attributes = (CertificateAttributes)attributes;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public MergeCertificateRequest build() {
            return new MergeCertificateRequest(this);
        }
    }
}

