/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.amqp.AmqpConstants;
import com.microsoft.azure.servicebus.amqp.IAmqpConnection;
import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import java.util.HashMap;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.reactor.Handshaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionHandler
extends BaseHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ConnectionHandler.class);
    private final IAmqpConnection messagingFactory;

    public ConnectionHandler(IAmqpConnection messagingFactory) {
        this.add((Handler)new Handshaker());
        this.messagingFactory = messagingFactory;
    }

    public void onConnectionInit(Event event) {
        Connection connection = event.getConnection();
        String hostName = event.getReactor().getConnectionAddress(connection);
        TRACE_LOGGER.debug("onConnectionInit: hostname:{}", (Object)hostName);
        connection.setHostname(hostName);
        connection.setContainer(StringUtil.getShortRandomString());
        HashMap<Symbol, String> connectionProperties = new HashMap<Symbol, String>();
        connectionProperties.put(AmqpConstants.PRODUCT, "MSJavaClient");
        connectionProperties.put(AmqpConstants.VERSION, ClientConstants.CURRENT_JAVACLIENT_VERSION);
        connectionProperties.put(AmqpConstants.PLATFORM, ClientConstants.PLATFORM_INFO);
        connection.setProperties(connectionProperties);
        connection.open();
    }

    public void onConnectionBound(Event event) {
        TRACE_LOGGER.debug("onConnectionBound: hostname:{}", (Object)event.getConnection().getHostname());
        Transport transport = event.getTransport();
        SslDomain domain = ConnectionHandler.makeDomain(SslDomain.Mode.CLIENT);
        transport.ssl(domain);
        Sasl sasl = transport.sasl();
        sasl.setMechanisms(new String[]{"ANONYMOUS"});
    }

    public void onTransportError(Event event) {
        ErrorCondition condition = event.getTransport().getCondition();
        if (condition != null) {
            TRACE_LOGGER.warn("Connection.onTransportError: hostname:{}, error:{}", (Object)event.getConnection().getHostname(), (Object)condition.getDescription());
        } else {
            TRACE_LOGGER.warn("Connection.onTransportError: hostname:{}. error:{}", (Object)event.getConnection().getHostname(), (Object)"no description returned");
        }
        this.messagingFactory.onConnectionError(condition);
        Connection connection = event.getConnection();
        if (connection != null) {
            connection.free();
        }
    }

    public void onConnectionRemoteOpen(Event event) {
        TRACE_LOGGER.debug("Connection.onConnectionRemoteOpen: hostname:{}, remotecontainer:{}", (Object)event.getConnection().getHostname(), (Object)event.getConnection().getRemoteContainer());
        this.messagingFactory.onConnectionOpen();
    }

    public void onConnectionRemoteClose(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getRemoteCondition();
        TRACE_LOGGER.debug("onConnectionRemoteClose: hostname:{},errorCondition:{}", (Object)connection.getHostname(), error != null ? error.getCondition() + "," + error.getDescription() : null);
        boolean shouldFreeConnection = connection.getLocalState() == EndpointState.CLOSED;
        this.messagingFactory.onConnectionError(error);
        if (shouldFreeConnection) {
            connection.free();
        }
    }

    public void onConnectionFinal(Event event) {
        TRACE_LOGGER.debug("onConnectionFinal: hostname:{}", (Object)event.getConnection().getHostname());
    }

    public void onConnectionLocalClose(Event event) {
        Connection connection = event.getConnection();
        TRACE_LOGGER.debug("onConnectionLocalClose: hostname:{}", (Object)connection.getHostname());
        if (connection.getRemoteState() == EndpointState.CLOSED) {
            if (connection.getTransport() != null) {
                connection.getTransport().unbind();
            }
            connection.free();
        }
    }

    private static SslDomain makeDomain(SslDomain.Mode mode) {
        SslDomain domain = Proton.sslDomain();
        domain.init(mode);
        domain.setPeerAuthentication(SslDomain.VerifyMode.ANONYMOUS_PEER);
        return domain;
    }
}

