/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.TDSCommand;

final class ReconnectThread
extends Thread {
    private SQLServerConnection con = null;
    private SQLServerException eReceived = null;
    private TDSCommand command = null;
    private volatile boolean stopRequested = false;
    private int connectRetryCount = 0;

    private ReconnectThread() {
    }

    ReconnectThread(SQLServerConnection sqlC) {
        this.con = sqlC;
    }

    void init(TDSCommand cmd) {
        this.command = cmd;
        this.connectRetryCount = this.con.getRetryCount();
        this.eReceived = null;
        this.stopRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean interruptsEnabled = this.command.getInterruptsEnabled();
        this.command.setInterruptsEnabled(true);
        this.command.attachThread(this);
        this.command.addToPoller();
        boolean keepRetrying = true;
        while (this.connectRetryCount != 0 && !this.stopRequested && keepRetrying) {
            try {
                this.eReceived = null;
                this.con.connect(null, this.con.getPooledConnectionParent());
                keepRetrying = false;
            }
            catch (SQLServerException e) {
                if (this.stopRequested) continue;
                this.eReceived = e;
                if (this.con.isFatalError(e)) {
                    keepRetrying = false;
                    continue;
                }
                try {
                    if (this.connectRetryCount <= 1) continue;
                    Thread.sleep(this.con.getRetryInterval() * 1000);
                }
                catch (InterruptedException ie) {
                    this.eReceived = new SQLServerException(SQLServerException.getErrString("R_queryTimedOut"), SQLState.STATEMENT_CANCELED, DriverError.NOT_SET, null);
                    keepRetrying = false;
                }
            }
            finally {
                --this.connectRetryCount;
                try {
                    this.command.checkForInterrupt();
                }
                catch (SQLServerException e) {
                    keepRetrying = false;
                    this.eReceived = e;
                }
            }
        }
        if (this.connectRetryCount == 0 && keepRetrying) {
            this.eReceived = new SQLServerException(SQLServerException.getErrString("R_crClientAllRecoveryAttemptsFailed"), this.eReceived);
        }
        this.command.setInterruptsEnabled(interruptsEnabled);
    }

    void stop(boolean blocking) {
        this.stopRequested = true;
        if (blocking && this.isAlive()) {
            while (this.getState() != Thread.State.TERMINATED) {
            }
        }
    }

    SQLServerException getException() {
        return this.eReceived;
    }
}

