/*
 * Decompiled with CFR 0.152.
 */
package com.mindprogeny.wiremock.extension.scenario;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.mindprogeny.wiremock.extension.scenario.StringValuePatternBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;
import wiremock.org.custommonkey.xmlunit.exceptions.ConfigurationException;

public class ConcurrentScenarioExtension
extends RequestMatcherExtension {
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicReference<String>>> SCENARIOS = new ConcurrentHashMap();
    private static final String DEFAULT_INSTANCE_ID = "$ID";
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    public MatchResult match(Request request, Parameters parameters) {
        String instanceIdentifierPattern;
        Map requestParameters = (Map)parameters.get((Object)"request");
        BasicCredentials basicCredentials = null;
        Map basicCredentialsMap = (Map)requestParameters.get("basicAuthCredentials");
        if (basicCredentialsMap != null) {
            basicCredentials = new BasicCredentials((String)basicCredentialsMap.get("username"), (String)basicCredentialsMap.get("password"));
        }
        MatchResult matchResult = new RequestPattern((String)requestParameters.get("url"), (String)requestParameters.get("urlPattern"), (String)requestParameters.get("urlPath"), (String)requestParameters.get("urlPathPattern"), RequestMethod.fromString((String)((String)requestParameters.get("method"))), this.getMultiValuePatternMap((Map)requestParameters.get("headers")), this.getMultiValuePatternMap((Map)requestParameters.get("queryParameters")), this.getStringValuePatternMap((Map)requestParameters.get("cookies")), basicCredentials, this.getContentPatternList((Collection)requestParameters.get("bodyPatterns")), null, this.getMultipartPatternList((Collection)requestParameters.get("multipartPatterns"))).match(request);
        String scenarioName = (String)parameters.get((Object)"scenarioName");
        if (scenarioName == null || !matchResult.isExactMatch()) {
            return matchResult;
        }
        String instanceIdentifier = (String)parameters.get((Object)"scenarioInstanceIdentifier");
        String scenarioInstance = this.getScenarioInstance(instanceIdentifier, instanceIdentifierPattern = (String)parameters.get((Object)"scenarioInstanceIdentifierPattern"), request);
        if (scenarioInstance == null) {
            scenarioInstance = DEFAULT_INSTANCE_ID;
        }
        AtomicReference<String> state = ConcurrentScenarioExtension.getOrInitialize(scenarioName, scenarioInstance);
        String requiredState = (String)parameters.get((Object)"requiredScenarioState");
        if (requiredState != null && !requiredState.equals(state.get())) {
            return MatchResult.noMatch();
        }
        String newState = (String)parameters.get((Object)"newScenarioState");
        if (newState != null) {
            state.set(newState);
        }
        return MatchResult.exactMatch();
    }

    private String getScenarioInstance(String instanceIdentifier, String instanceIdentifierPattern, Request request) {
        if (instanceIdentifier == null) {
            return null;
        }
        switch (instanceIdentifier) {
            case "url": {
                Pattern urlMatchPattern;
                Matcher matcher;
                if (instanceIdentifierPattern == null || !(matcher = (urlMatchPattern = Pattern.compile(instanceIdentifierPattern)).matcher(request.getUrl())).matches()) break;
                return matcher.group(1);
            }
            case "queryParameter": {
                QueryParameter parameter = request.queryParameter(instanceIdentifierPattern);
                if (parameter == null) break;
                return parameter.firstValue();
            }
            case "cookie": {
                Cookie cookie = (Cookie)request.getCookies().get(instanceIdentifierPattern);
                if (cookie == null) break;
                return cookie.getValue();
            }
            default: {
                throw new ConfigurationException("Unknown instance identifier source : " + instanceIdentifier);
            }
        }
        return null;
    }

    public String getName() {
        return "concurrent-session";
    }

    private Map<String, MultiValuePattern> getMultiValuePatternMap(Map<String, Map<String, Object>> namedPatternParameters) {
        if (namedPatternParameters == null || namedPatternParameters.size() == 0) {
            return null;
        }
        HashMap<String, MultiValuePattern> result = new HashMap<String, MultiValuePattern>();
        namedPatternParameters.forEach((k, v) -> result.put((String)k, new MultiValuePattern(StringValuePatternBuilder.build(v))));
        return result;
    }

    private Map<String, StringValuePattern> getStringValuePatternMap(Map<String, Map<String, Object>> namedPatternParameters) {
        if (namedPatternParameters == null || namedPatternParameters.size() == 0) {
            return null;
        }
        HashMap<String, StringValuePattern> result = new HashMap<String, StringValuePattern>();
        namedPatternParameters.forEach((k, v) -> result.put((String)k, StringValuePatternBuilder.build(v)));
        return result;
    }

    private List<ContentPattern<?>> getContentPatternList(Collection<Map<String, Object>> patternParameters) {
        if (patternParameters == null || patternParameters.size() == 0) {
            return null;
        }
        LinkedList result = new LinkedList();
        patternParameters.forEach(e -> {
            Object binaryValue = e.get("binaryEqualTo");
            if (binaryValue != null) {
                result.add((ContentPattern<?>)new BinaryEqualToPattern(binaryValue.toString()));
            } else {
                result.add((ContentPattern<?>)StringValuePatternBuilder.build(e));
            }
        });
        return result;
    }

    private List<MultipartValuePattern> getMultipartPatternList(Collection<Map<String, Object>> patternParameters) {
        if (patternParameters == null || patternParameters.size() == 0) {
            return null;
        }
        LinkedList<MultipartValuePattern> result = new LinkedList<MultipartValuePattern>();
        patternParameters.forEach(e -> result.add(new MultipartValuePattern((String)e.get("name"), MultipartValuePattern.MatchingType.valueOf((String)((String)e.get("matchingType"))), this.getMultiValuePatternMap((Map)e.get("headers")), this.getContentPatternList((Collection)e.get("bodyPatterns")))));
        return result;
    }

    public static AtomicReference<String> getOrInitialize(String scenarioName, String scenarioInstance) {
        ConcurrentHashMap instances = SCENARIOS.computeIfAbsent(scenarioName, k -> new ConcurrentHashMap());
        AtomicReference state = instances.computeIfAbsent(scenarioInstance, k -> new AtomicReference<String>("Started"));
        return state;
    }

    public static String serializeScenarios() throws JsonProcessingException {
        return jsonMapper.writeValueAsString(SCENARIOS);
    }

    public static String serializeScenarioInstances(String scenario) throws JsonProcessingException {
        return jsonMapper.writeValueAsString(SCENARIOS.get(scenario));
    }

    public static void clearAll() {
        SCENARIOS.clear();
    }

    public static boolean clearScenario(String scenario) {
        return SCENARIOS.remove(scenario) != null;
    }

    public static boolean clearInstance(String scenario, String instance) {
        ConcurrentHashMap<String, AtomicReference<String>> scenarioInstances = SCENARIOS.get(scenario);
        if (scenarioInstances != null) {
            return scenarioInstances.remove(instance) != null;
        }
        return false;
    }

    public static void setScenarioState(String scenario, String instance, String state) {
        ConcurrentScenarioExtension.getOrInitialize(scenario, instance).set(state);
    }
}

