/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Key;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ThreadDelegatedContext {
    private final Map<Key<?>, Object> contents = Maps.newHashMap();
    private final Set<ScopeListener> listeners = Sets.newHashSet();

    ThreadDelegatedContext() {
    }

    synchronized boolean containsKey(@Nonnull Key<?> key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key must not be null!");
        return this.contents.containsKey(key);
    }

    synchronized <T> T get(Key<T> key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key must not be null!");
        Object result = this.contents.get(key);
        return (T)result;
    }

    synchronized void put(@Nonnull Key<?> key, @Nullable Object value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key must not be null!");
        this.contents.put(key, value);
        if (value instanceof ScopeListener) {
            ScopeListener listener = (ScopeListener)ScopeListener.class.cast(value);
            this.listeners.add(listener);
            listener.event(ScopeEvent.ENTER);
        }
    }

    @VisibleForTesting
    synchronized void clear() {
        this.event(ScopeEvent.LEAVE);
        this.listeners.clear();
        this.contents.clear();
    }

    @VisibleForTesting
    synchronized int size() {
        return this.contents.size();
    }

    synchronized void event(ScopeEvent event) {
        for (ScopeListener listener : this.listeners) {
            listener.event(event);
        }
    }

    public static enum ScopeEvent {
        ENTER,
        LEAVE;

    }

    public static interface ScopeListener {
        public void event(ScopeEvent var1);
    }
}

