/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependenciesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DependenciesValidator.class);
    private final Map<String, List<String>> propertyDeps = new HashMap<String, List<String>>();
    private Map<String, JsonSchema> schemaDeps = new HashMap<String, JsonSchema>();

    public DependenciesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.DEPENDENCIES, validationContext);
        Iterator it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = (String)it.next();
            JsonNode pvalue = schemaNode.get(pname);
            if (pvalue.isArray()) {
                List<String> depsProps = this.propertyDeps.get(pname);
                if (depsProps == null) {
                    depsProps = new ArrayList<String>();
                    this.propertyDeps.put(pname, depsProps);
                }
                for (int i = 0; i < pvalue.size(); ++i) {
                    depsProps.add(pvalue.get(i).asText());
                }
                continue;
            }
            if (!pvalue.isObject()) continue;
            this.schemaDeps.put(pname, new JsonSchema(validationContext, pname, pvalue, parentSchema));
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            JsonSchema schema;
            String pname = (String)it.next();
            List<String> deps = this.propertyDeps.get(pname);
            if (deps != null && !deps.isEmpty()) {
                for (String field : deps) {
                    if (node.get(field) != null) continue;
                    errors.add(this.buildValidationMessage(at, this.propertyDeps.toString()));
                }
            }
            if ((schema = this.schemaDeps.get(pname)) == null) continue;
            errors.addAll(schema.validate(node, rootNode, at));
        }
        return Collections.unmodifiableSet(errors);
    }
}

