/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class MatchingStringFilter {
    public static final String WILDCARD = "*";
    private final boolean all;
    private final Set<String> exactMatches;

    public MatchingStringFilter(String propName, Properties props) throws PropertyParseException {
        this(propName, props, new MatchingStringFilter(false));
    }

    public MatchingStringFilter(String propName, Properties props, MatchingStringFilter defaultFilter) throws PropertyParseException {
        PropertyRetriever pr = new PropertyRetriever(props);
        if (pr.getOptString(propName, "").trim().isEmpty()) {
            this.all = defaultFilter.all;
            this.exactMatches = defaultFilter.exactMatches;
            return;
        }
        if (WILDCARD.equals(pr.getOptString(propName, "").trim())) {
            this.all = true;
            this.exactMatches = Collections.emptySet();
            return;
        }
        List names = pr.getOptStringList(propName, Collections.emptyList());
        this.all = false;
        this.exactMatches = new HashSet<String>(names);
    }

    public MatchingStringFilter(boolean all) {
        this.all = all;
        this.exactMatches = Collections.emptySet();
    }

    public List<String> filter(Collection<String> stringList) {
        if (stringList == null || stringList.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.all) {
            return new LinkedList<String>(stringList);
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String string : stringList) {
            if (string == null || !this.exactMatches.contains(string)) continue;
            result.add(string);
        }
        return result;
    }

    public String toString() {
        return this.all ? "* (all)" : this.exactMatches.toString();
    }
}

