/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue;

import com.oracle.bmc.queue.QueueAdmin;
import com.oracle.bmc.queue.model.Queue;
import com.oracle.bmc.queue.requests.GetQueueRequest;
import com.oracle.bmc.queue.requests.GetWorkRequestRequest;
import com.oracle.bmc.queue.responses.GetQueueResponse;
import com.oracle.bmc.queue.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class QueueAdminWaiters {
    private final ExecutorService executorService;
    private final QueueAdmin client;

    public QueueAdminWaiters(ExecutorService executorService, QueueAdmin client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetQueueRequest, GetQueueResponse> forQueue(GetQueueRequest request, Queue.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forQueue(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetQueueRequest, GetQueueResponse> forQueue(GetQueueRequest request, Queue.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forQueue(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetQueueRequest, GetQueueResponse> forQueue(GetQueueRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Queue.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forQueue(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetQueueRequest, GetQueueResponse> forQueue(BmcGenericWaiter waiter, GetQueueRequest request, Queue.LifecycleState ... targetStates) {
        final HashSet<Queue.LifecycleState> targetStatesSet = new HashSet<Queue.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetQueueRequest, GetQueueResponse>(){

            @Override
            public GetQueueResponse apply(GetQueueRequest request) {
                return QueueAdminWaiters.this.client.getQueue(request);
            }
        }, (Predicate)new Predicate<GetQueueResponse>(){

            @Override
            public boolean test(GetQueueResponse response) {
                return targetStatesSet.contains((Object)response.getQueue().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Queue.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return QueueAdminWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

