/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.queue.QueueAsync;
import com.oracle.bmc.queue.model.DeleteMessagesResult;
import com.oracle.bmc.queue.model.GetMessages;
import com.oracle.bmc.queue.model.PutMessages;
import com.oracle.bmc.queue.model.QueueStats;
import com.oracle.bmc.queue.model.UpdateMessagesResult;
import com.oracle.bmc.queue.model.UpdatedMessage;
import com.oracle.bmc.queue.requests.DeleteMessageRequest;
import com.oracle.bmc.queue.requests.DeleteMessagesRequest;
import com.oracle.bmc.queue.requests.GetMessagesRequest;
import com.oracle.bmc.queue.requests.GetStatsRequest;
import com.oracle.bmc.queue.requests.PutMessagesRequest;
import com.oracle.bmc.queue.requests.UpdateMessageRequest;
import com.oracle.bmc.queue.requests.UpdateMessagesRequest;
import com.oracle.bmc.queue.responses.DeleteMessageResponse;
import com.oracle.bmc.queue.responses.DeleteMessagesResponse;
import com.oracle.bmc.queue.responses.GetMessagesResponse;
import com.oracle.bmc.queue.responses.GetStatsResponse;
import com.oracle.bmc.queue.responses.PutMessagesResponse;
import com.oracle.bmc.queue.responses.UpdateMessageResponse;
import com.oracle.bmc.queue.responses.UpdateMessagesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueAsyncClient
extends BaseAsyncClient
implements QueueAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("QUEUE").serviceEndpointPrefix("").serviceEndpointTemplate("https://messaging.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(QueueAsyncClient.class);

    private QueueAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<DeleteMessageResponse> deleteMessage(DeleteMessageRequest request, AsyncHandler<DeleteMessageRequest, DeleteMessageResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMessageReceipt(), (String)"messageReceipt must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteMessageResponse::builder).logger(LOG, "deleteMessage").serviceDetails("Queue", "DeleteMessage", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/GetMessage/DeleteMessage").method(Method.DELETE).requestBuilder(DeleteMessageRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").appendPathParam(request.getMessageReceipt()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteMessageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteMessagesResponse> deleteMessages(DeleteMessagesRequest request, AsyncHandler<DeleteMessagesRequest, DeleteMessagesResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDeleteMessagesDetails(), "deleteMessagesDetails is required");
        return this.clientCall(request, DeleteMessagesResponse::builder).logger(LOG, "deleteMessages").serviceDetails("Queue", "DeleteMessages", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/GetMessage/DeleteMessages").method(Method.POST).requestBuilder(DeleteMessagesRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").appendPathParam("actions").appendPathParam("deleteMessages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DeleteMessagesResult.class, DeleteMessagesResponse.Builder::deleteMessagesResult).handleResponseHeaderString("opc-request-id", DeleteMessagesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetMessagesResponse> getMessages(GetMessagesRequest request, AsyncHandler<GetMessagesRequest, GetMessagesResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMessagesResponse::builder).logger(LOG, "getMessages").serviceDetails("Queue", "GetMessages", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/GetMessage/GetMessages").method(Method.GET).requestBuilder(GetMessagesRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").appendQueryParam("visibilityInSeconds", (Object)request.getVisibilityInSeconds()).appendQueryParam("timeoutInSeconds", (Object)request.getTimeoutInSeconds()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GetMessages.class, GetMessagesResponse.Builder::getMessages).handleResponseHeaderString("opc-request-id", GetMessagesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetStatsResponse> getStats(GetStatsRequest request, AsyncHandler<GetStatsRequest, GetStatsResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetStatsResponse::builder).logger(LOG, "getStats").serviceDetails("Queue", "GetStats", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/QueueStats/GetStats").method(Method.GET).requestBuilder(GetStatsRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("stats").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(QueueStats.class, GetStatsResponse.Builder::queueStats).handleResponseHeaderString("opc-request-id", GetStatsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<PutMessagesResponse> putMessages(PutMessagesRequest request, AsyncHandler<PutMessagesRequest, PutMessagesResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPutMessagesDetails(), "putMessagesDetails is required");
        return this.clientCall(request, PutMessagesResponse::builder).logger(LOG, "putMessages").serviceDetails("Queue", "PutMessages", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/PutMessage/PutMessages").method(Method.POST).requestBuilder(PutMessagesRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PutMessages.class, PutMessagesResponse.Builder::putMessages).handleResponseHeaderString("opc-request-id", PutMessagesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateMessageResponse> updateMessage(UpdateMessageRequest request, AsyncHandler<UpdateMessageRequest, UpdateMessageResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMessageReceipt(), (String)"messageReceipt must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMessageDetails(), "updateMessageDetails is required");
        return this.clientCall(request, UpdateMessageResponse::builder).logger(LOG, "updateMessage").serviceDetails("Queue", "UpdateMessage", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/UpdatedMessage/UpdateMessage").method(Method.PUT).requestBuilder(UpdateMessageRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").appendPathParam(request.getMessageReceipt()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(UpdatedMessage.class, UpdateMessageResponse.Builder::updatedMessage).handleResponseHeaderString("opc-request-id", UpdateMessageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateMessagesResponse> updateMessages(UpdateMessagesRequest request, AsyncHandler<UpdateMessagesRequest, UpdateMessagesResponse> handler) {
        Validate.notBlank((String)request.getQueueId(), (String)"queueId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateMessagesDetails(), "updateMessagesDetails is required");
        return this.clientCall(request, UpdateMessagesResponse::builder).logger(LOG, "updateMessages").serviceDetails("Queue", "UpdateMessages", "https://docs.oracle.com/iaas/api/#/en/queue/20210201/GetMessage/UpdateMessages").method(Method.POST).requestBuilder(UpdateMessagesRequest::builder).basePath("/20210201").appendPathParam("queues").appendPathParam(request.getQueueId()).appendPathParam("messages").appendPathParam("actions").appendPathParam("updateMessages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(UpdateMessagesResult.class, UpdateMessagesResponse.Builder::updateMessagesResult).handleResponseHeaderString("opc-request-id", UpdateMessagesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public QueueAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)QueueAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(QueueAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)QueueAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)QueueAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)QueueAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)QueueAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public QueueAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)QueueAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, QueueAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public QueueAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new QueueAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

