/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.queue.model.Stats;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class QueueStats
extends ExplicitlySetBmcModel {
    @JsonProperty(value="queue")
    private final Stats queue;
    @JsonProperty(value="dlq")
    private final Stats dlq;

    @Deprecated
    @ConstructorProperties(value={"queue", "dlq"})
    public QueueStats(Stats queue, Stats dlq) {
        this.queue = queue;
        this.dlq = dlq;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Stats getQueue() {
        return this.queue;
    }

    public Stats getDlq() {
        return this.dlq;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("QueueStats(");
        sb.append("super=").append(super.toString());
        sb.append("queue=").append(String.valueOf((Object)this.queue));
        sb.append(", dlq=").append(String.valueOf((Object)this.dlq));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueueStats)) {
            return false;
        }
        QueueStats other = (QueueStats)((Object)o);
        return Objects.equals((Object)this.queue, (Object)other.queue) && Objects.equals((Object)this.dlq, (Object)other.dlq) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.queue == null ? 43 : this.queue.hashCode());
        result = result * 59 + (this.dlq == null ? 43 : this.dlq.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="queue")
        private Stats queue;
        @JsonProperty(value="dlq")
        private Stats dlq;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder queue(Stats queue) {
            this.queue = queue;
            this.__explicitlySet__.add("queue");
            return this;
        }

        public Builder dlq(Stats dlq) {
            this.dlq = dlq;
            this.__explicitlySet__.add("dlq");
            return this;
        }

        public QueueStats build() {
            QueueStats model = new QueueStats(this.queue, this.dlq);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(QueueStats model) {
            if (model.wasPropertyExplicitlySet("queue")) {
                this.queue(model.getQueue());
            }
            if (model.wasPropertyExplicitlySet("dlq")) {
                this.dlq(model.getDlq());
            }
            return this;
        }
    }
}

