/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateMessagesResultEntry
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final Long id;
    @JsonProperty(value="visibleAfter")
    private final Date visibleAfter;
    @JsonProperty(value="errorCode")
    private final Integer errorCode;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;

    @Deprecated
    @ConstructorProperties(value={"id", "visibleAfter", "errorCode", "errorMessage"})
    public UpdateMessagesResultEntry(Long id, Date visibleAfter, Integer errorCode, String errorMessage) {
        this.id = id;
        this.visibleAfter = visibleAfter;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getId() {
        return this.id;
    }

    public Date getVisibleAfter() {
        return this.visibleAfter;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateMessagesResultEntry(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", visibleAfter=").append(String.valueOf(this.visibleAfter));
        sb.append(", errorCode=").append(String.valueOf(this.errorCode));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMessagesResultEntry)) {
            return false;
        }
        UpdateMessagesResultEntry other = (UpdateMessagesResultEntry)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.visibleAfter, other.visibleAfter) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorMessage, other.errorMessage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.visibleAfter == null ? 43 : this.visibleAfter.hashCode());
        result = result * 59 + (this.errorCode == null ? 43 : this.errorCode.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private Long id;
        @JsonProperty(value="visibleAfter")
        private Date visibleAfter;
        @JsonProperty(value="errorCode")
        private Integer errorCode;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(Long id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder visibleAfter(Date visibleAfter) {
            this.visibleAfter = visibleAfter;
            this.__explicitlySet__.add("visibleAfter");
            return this;
        }

        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.__explicitlySet__.add("errorCode");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public UpdateMessagesResultEntry build() {
            UpdateMessagesResultEntry model = new UpdateMessagesResultEntry(this.id, this.visibleAfter, this.errorCode, this.errorMessage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateMessagesResultEntry model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("visibleAfter")) {
                this.visibleAfter(model.getVisibleAfter());
            }
            if (model.wasPropertyExplicitlySet("errorCode")) {
                this.errorCode(model.getErrorCode());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            return this;
        }
    }
}

