/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.queue.model.UpdateMessageDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateMessageRequest
extends BmcRequest<UpdateMessageDetails> {
    private String queueId;
    private String messageReceipt;
    private UpdateMessageDetails updateMessageDetails;
    private String opcRequestId;

    public String getQueueId() {
        return this.queueId;
    }

    public String getMessageReceipt() {
        return this.messageReceipt;
    }

    public UpdateMessageDetails getUpdateMessageDetails() {
        return this.updateMessageDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateMessageDetails getBody$() {
        return this.updateMessageDetails;
    }

    public Builder toBuilder() {
        return new Builder().queueId(this.queueId).messageReceipt(this.messageReceipt).updateMessageDetails(this.updateMessageDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",queueId=").append(String.valueOf(this.queueId));
        sb.append(",messageReceipt=").append(String.valueOf(this.messageReceipt));
        sb.append(",updateMessageDetails=").append(String.valueOf((Object)this.updateMessageDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMessageRequest)) {
            return false;
        }
        UpdateMessageRequest other = (UpdateMessageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.queueId, other.queueId) && Objects.equals(this.messageReceipt, other.messageReceipt) && Objects.equals((Object)this.updateMessageDetails, (Object)other.updateMessageDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.queueId == null ? 43 : this.queueId.hashCode());
        result = result * 59 + (this.messageReceipt == null ? 43 : this.messageReceipt.hashCode());
        result = result * 59 + (this.updateMessageDetails == null ? 43 : this.updateMessageDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateMessageRequest, UpdateMessageDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String queueId = null;
        private String messageReceipt = null;
        private UpdateMessageDetails updateMessageDetails = null;
        private String opcRequestId = null;

        public Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder messageReceipt(String messageReceipt) {
            this.messageReceipt = messageReceipt;
            return this;
        }

        public Builder updateMessageDetails(UpdateMessageDetails updateMessageDetails) {
            this.updateMessageDetails = updateMessageDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateMessageRequest o) {
            this.queueId(o.getQueueId());
            this.messageReceipt(o.getMessageReceipt());
            this.updateMessageDetails(o.getUpdateMessageDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateMessageRequest build() {
            UpdateMessageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateMessageDetails body) {
            this.updateMessageDetails(body);
            return this;
        }

        public UpdateMessageRequest buildWithoutInvocationCallback() {
            UpdateMessageRequest request = new UpdateMessageRequest();
            request.queueId = this.queueId;
            request.messageReceipt = this.messageReceipt;
            request.updateMessageDetails = this.updateMessageDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

