/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.queue.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.queue.model.UpdateQueueDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateQueueRequest
extends BmcRequest<UpdateQueueDetails> {
    private String queueId;
    private UpdateQueueDetails updateQueueDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getQueueId() {
        return this.queueId;
    }

    public UpdateQueueDetails getUpdateQueueDetails() {
        return this.updateQueueDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateQueueDetails getBody$() {
        return this.updateQueueDetails;
    }

    public Builder toBuilder() {
        return new Builder().queueId(this.queueId).updateQueueDetails(this.updateQueueDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",queueId=").append(String.valueOf(this.queueId));
        sb.append(",updateQueueDetails=").append(String.valueOf((Object)this.updateQueueDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateQueueRequest)) {
            return false;
        }
        UpdateQueueRequest other = (UpdateQueueRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.queueId, other.queueId) && Objects.equals((Object)this.updateQueueDetails, (Object)other.updateQueueDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.queueId == null ? 43 : this.queueId.hashCode());
        result = result * 59 + (this.updateQueueDetails == null ? 43 : this.updateQueueDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateQueueRequest, UpdateQueueDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String queueId = null;
        private UpdateQueueDetails updateQueueDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder updateQueueDetails(UpdateQueueDetails updateQueueDetails) {
            this.updateQueueDetails = updateQueueDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateQueueRequest o) {
            this.queueId(o.getQueueId());
            this.updateQueueDetails(o.getUpdateQueueDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateQueueRequest build() {
            UpdateQueueRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateQueueDetails body) {
            this.updateQueueDetails(body);
            return this;
        }

        public UpdateQueueRequest buildWithoutInvocationCallback() {
            UpdateQueueRequest request = new UpdateQueueRequest();
            request.queueId = this.queueId;
            request.updateQueueDetails = this.updateQueueDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

