/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.http;

import java.util.List;
import java.util.Map;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.JsonMapper;
import org.qas.api.http.HttpResponse;
import org.qas.api.http.HttpResponseHandler;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.Unmarshaller;

public class JsonErrorResponseHandler
implements HttpResponseHandler<AuthServiceException> {
    private List<Unmarshaller<AuthServiceException, JsonObject>> unmarshallerList;

    public JsonErrorResponseHandler(List<Unmarshaller<AuthServiceException, JsonObject>> exceptionUnmarshallers) {
        this.unmarshallerList = exceptionUnmarshallers;
    }

    @Override
    public AuthServiceException handle(HttpResponse response) throws Exception {
        JsonObject jsonErrorMessage;
        String streamContents = JsonMapper.toString(response.getContent());
        try {
            String s;
            String string = s = streamContents != null ? streamContents.trim() : "";
            if (s.length() == 0) {
                s = "{}";
            } else if (!s.startsWith("{") || !s.endsWith("}")) {
                s = new JsonObject().accumulate("message", s).toString();
            }
            jsonErrorMessage = new JsonObject(s);
        }
        catch (Exception e) {
            throw new AuthClientException("Unable to parse error response: '" + streamContents + "'", e);
        }
        AuthServiceException ase = this.runErrorUnmarshallers(response, jsonErrorMessage);
        if (ase == null) {
            return null;
        }
        ase.setServiceName(response.getRequest().getServiceName());
        ase.setStatusCode(response.getStatusCode());
        if (response.getStatusCode() < 500) {
            ase.setErrorType(AuthServiceException.ErrorType.Client);
        } else {
            ase.setErrorType(AuthServiceException.ErrorType.Service);
        }
        for (Map.Entry<String, String> headerEntry : response.getHeaders().entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase("x-qtest-request-id")) continue;
            ase.setRequestId(headerEntry.getValue());
        }
        return ase;
    }

    protected AuthServiceException runErrorUnmarshallers(HttpResponse errorResponse, JsonObject json) throws Exception {
        for (Unmarshaller<AuthServiceException, JsonObject> unmarshaller : this.unmarshallerList) {
            AuthServiceException ase = unmarshaller.unmarshall(json);
            if (ase == null) continue;
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        return null;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

