/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.http;

import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.qas.api.ApiServiceResponse;
import org.qas.api.ResponseMetadata;
import org.qas.api.http.HttpResponse;
import org.qas.api.http.HttpResponseHandler;
import org.qas.api.transform.StringUnmarshaller;
import org.qas.api.transform.Unmarshaller;

public class StringResponseHandler
implements HttpResponseHandler<ApiServiceResponse<String>> {
    private static final Logger LOG = Logger.getLogger(StringResponseHandler.class.getName());
    private Unmarshaller<String, InputStream> responseUnmarshaller;

    public StringResponseHandler() {
        this.responseUnmarshaller = new StringUnmarshaller();
    }

    public StringResponseHandler(Unmarshaller<String, InputStream> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (responseUnmarshaller == null) {
            this.responseUnmarshaller = new StringUnmarshaller();
        }
    }

    @Override
    public ApiServiceResponse<String> handle(HttpResponse<?> httpResponse) throws Exception {
        if (LOG.isLoggable(Level.ALL)) {
            LOG.log(Level.ALL, "Handle the service response.");
        }
        InputStream content = httpResponse.getContent();
        ApiServiceResponse<String> awsResponse = new ApiServiceResponse<String>();
        if (content != null) {
            awsResponse.setResult(this.responseUnmarshaller.unmarshall(content));
        } else {
            awsResponse.setResult(null);
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("RequestId", httpResponse.getHeaders().get("x-qtest-request-id"));
        awsResponse.setMetadata(new ResponseMetadata(metadata));
        return awsResponse;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

