/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.http.basic;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.qas.api.ApiServiceResponse;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.handler.RequestHandler;
import org.qas.api.http.AbstractHttpAuthClient;
import org.qas.api.http.ExecutionContext;
import org.qas.api.http.HttpAuthClient;
import org.qas.api.http.HttpRequest;
import org.qas.api.http.HttpResponse;
import org.qas.api.http.HttpResponseHandler;
import org.qas.api.http.basic.HttpUrlConnectionFactory;
import org.qas.api.http.basic.HttpUrlConnectionRequest;
import org.qas.api.http.basic.HttpUrlConnectionResponse;
import org.qas.api.internal.CustomBackoffStrategy;
import org.qas.api.internal.util.Https;
import org.qas.api.internal.util.google.base.Charsets;
import org.qas.api.internal.util.google.base.Strings;
import org.qas.api.internal.util.google.io.ByteStreams;
import org.qas.api.internal.util.google.io.Closeables;

public class HttpUrlConnectionAuthClient
extends AbstractHttpAuthClient<HttpURLConnection>
implements HttpAuthClient<HttpURLConnection> {
    private static final Logger LOG = Logger.getLogger(HttpUrlConnectionAuthClient.class.getName());
    private static final int HTTP_TEMPORARY_REDIRECT = 307;
    private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private static final Random random = new Random();

    public HttpUrlConnectionAuthClient(ClientConfiguration configuration) {
        super(configuration);
    }

    @Override
    public HttpResponse<HttpURLConnection> execute(Request request, ExecutionContext context) throws AuthClientException {
        if (context == null) {
            throw new AuthClientException("Internal SDK Error: No execution context parameter specified.");
        }
        List<RequestHandler> requestHandlers = context.getRequestHandlers();
        if (requestHandlers == null) {
            requestHandlers = Collections.emptyList();
        }
        for (RequestHandler requestHandler : requestHandlers) {
            requestHandler.beforeRequest(request);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T execute(Request request, HttpResponseHandler<ApiServiceResponse<T>> responseHandler, HttpResponseHandler<AuthServiceException> errorResponseHandler, ExecutionContext context) throws AuthClientException {
        if (context == null) {
            throw new AuthClientException("Internal SDK Error: No execution context parameter specified.");
        }
        List<RequestHandler> requestHandlers = context.getRequestHandlers();
        if (requestHandlers == null) {
            requestHandlers = Collections.emptyList();
        }
        for (RequestHandler requestHandler : requestHandlers) {
            requestHandler.beforeRequest(request);
        }
        try {
            T result = this.executeHelper(request, responseHandler, errorResponseHandler, context);
            for (RequestHandler requestHandler : requestHandlers) {
                try {
                    requestHandler.afterResponse(request, result);
                }
                catch (Exception exception) {}
            }
            return result;
        }
        catch (AuthClientException ex) {
            for (RequestHandler requestHandler : requestHandlers) {
                requestHandler.afterError(request, ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeHelper(Request request, HttpResponseHandler<ApiServiceResponse<T>> responseHandler, HttpResponseHandler<AuthServiceException> errorResponseHandler, ExecutionContext context) throws AuthClientException {
        boolean leaveHttpConnectionOpen = false;
        this.applyRequestData(request);
        int retryCount = 0;
        URI redirectedUri = null;
        AuthServiceException exception = null;
        HashMap<String, String> originalParameters = new HashMap<String, String>();
        originalParameters.putAll(request.getParameters());
        HashMap<String, String> originalHeaders = new HashMap<String, String>();
        originalHeaders.putAll(request.getHeaders());
        while (true) {
            if (retryCount > 0) {
                request.withHeaders(originalHeaders).withParameters(originalParameters);
            }
            HttpURLConnection connection = null;
            try {
                if (context.getSigner() != null && context.getCredentials() != null) {
                    context.getSigner().sign(request, context.getCredentials());
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Sending request: \n" + request.toString());
                }
                connection = HttpUrlConnectionFactory.createHttpRequest(request, redirectedUri, this.getConfiguration(), context);
                HttpUrlConnectionRequest httpRequest = new HttpUrlConnectionRequest(request, connection);
                if (retryCount > 0) {
                    this.pauseExponentially(retryCount, exception, context.getCustomBackoffStrategy());
                }
                if (request.getContent() != null) {
                    if (retryCount > 0) {
                        if (request.getContent().markSupported()) {
                            request.getContent().reset();
                            request.getContent().mark(-1);
                        }
                    } else if (request.getContent().markSupported()) {
                        request.getContent().mark(-1);
                    }
                }
                connection.setDoInput(true);
                connection.setUseCaches(false);
                connection.connect();
                if (connection.getDoOutput()) {
                    this.writePayload(connection, request);
                }
                if (this.isRequestSuccessful(connection)) {
                    leaveHttpConnectionOpen = responseHandler.needsConnectionLeftOpen();
                    T t = this.handleResponse(httpRequest, responseHandler, connection, context);
                    return t;
                }
                if (this.isTemporaryRedirect(connection)) {
                    String location = connection.getHeaderField("Location");
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Redirecting to: [" + location + "]");
                    }
                    redirectedUri = URI.create(location);
                    continue;
                }
                leaveHttpConnectionOpen = errorResponseHandler.needsConnectionLeftOpen();
                exception = this.handleErrorResponse(httpRequest, errorResponseHandler, connection);
                if (!this.shouldRetry(connection, exception, retryCount)) {
                    throw exception;
                }
                this.resetRequestAfterError(request, exception);
                continue;
            }
            catch (IOException ioex) {
                if (!LOG.isLoggable(Level.INFO)) continue;
                LOG.log(Level.INFO, "Unable to execute HTTP request: [" + ioex.getMessage() + "]", ioex);
                if (!this.shouldRetry(connection, ioex, retryCount)) {
                    throw new AuthClientException("Unable to execute the HTTP request: " + ioex.getMessage(), ioex);
                }
                this.resetRequestAfterError(request, ioex);
                continue;
            }
            finally {
                ++retryCount;
                if (leaveHttpConnectionOpen) continue;
                try {
                    connection.disconnect();
                }
                catch (Throwable throwable) {}
                continue;
            }
            break;
        }
    }

    private void writePayload(HttpURLConnection connection, Request request) throws IOException {
        OutputStream output = connection.getOutputStream();
        if (Https.usePayloadForQueryParameters(request)) {
            output.write(Https.toQueryString(request.getParameters(), Charsets.UTF_8).getBytes());
        } else if (request.getContent() != null) {
            ByteStreams.copy(request.getContent(), output);
        }
        output.flush();
        Closeables.close(output, false);
    }

    private void applyRequestData(Request request) {
        if (this.getConfiguration().getUserAgent() != null) {
            request.setHeader("User-Agent", this.getConfiguration().getUserAgent());
        }
    }

    private boolean shouldRetry(HttpURLConnection connection, Exception ex, int retries) {
        if (retries > this.getConfiguration().getMaxErrorRetry()) {
            return false;
        }
        try {
            if (connection.getResponseCode() == 402) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ex instanceof IOException) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Retrying on " + ex.getClass().getName() + ": " + ex.getMessage());
            }
            return true;
        }
        if (ex instanceof AuthServiceException) {
            AuthServiceException lase = (AuthServiceException)ex;
            if (lase.getStatusCode() == 500 || lase.getStatusCode() == 503) {
                return true;
            }
            if (HttpUrlConnectionAuthClient.isThrottlingException(lase)) {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporaryRedirect(HttpURLConnection connection) {
        try {
            int status = connection.getResponseCode();
            return status == 307 && !Strings.isNullOrEmpty(connection.getHeaderField("Location"));
        }
        catch (IOException ioex) {
            return false;
        }
    }

    private boolean isRequestSuccessful(HttpURLConnection connection) {
        try {
            int status = connection.getResponseCode();
            return status / 100 == 2;
        }
        catch (IOException ioex) {
            return false;
        }
    }

    private AuthServiceException handleErrorResponse(HttpRequest<HttpURLConnection> request, HttpResponseHandler<AuthServiceException> errorResponseHandler, HttpURLConnection connection) throws IOException {
        AuthServiceException exception;
        if (errorResponseHandler == null) {
            throw new AuthClientException("Unable to handle the response from server.");
        }
        int statusCode = connection.getResponseCode();
        this.printResponseError(request, connection);
        HttpResponse<HttpURLConnection> response = this.createResponse(connection, request);
        try {
            exception = errorResponseHandler.handle(response);
        }
        catch (Exception ex) {
            if (statusCode == 413) {
                exception = new AuthServiceException("Request entity too large").withErrorType(AuthServiceException.ErrorType.Client).withErrorCode("Request entity too large");
            }
            if (statusCode == 503 && "Service Unavailable".equalsIgnoreCase(response.getStatus())) {
                exception = new AuthServiceException("Service unavailable").withErrorType(AuthServiceException.ErrorType.Service).withErrorCode("Service unavailable");
            }
            throw new AuthClientException("Unable to parse error response (" + ex.getMessage() + ")", ex);
        }
        exception.withStatusCode(statusCode).withServiceName(request.getServiceName());
        exception.fillInStackTrace();
        return exception;
    }

    private void printResponseError(HttpRequest request, HttpURLConnection connection) throws IOException {
        StringBuilder builder = new StringBuilder("Request to: " + request.getEndpoint() + request.getResourcePath() + ", code: " + connection.getResponseCode() + ", headers: ");
        List<String> ignoredHeaders = Arrays.asList("Transfer-Encoding", "Server", "Access-Control-Allow-Origin", "Access-Control-Allow-Methods", "Pragma", "Access-Control-Allow-Headers", "Cache-Control", "Access-Control-Allow-Credentials", "X-XSS-Protection", "Access-Control-Max-Age", "Connection");
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            if (ignoredHeaders.contains(entry.getKey())) continue;
            builder.append(entry + ",");
        }
        LOG.log(Level.WARNING, builder.toString());
    }

    private <T> T handleResponse(HttpRequest request, HttpResponseHandler<ApiServiceResponse<T>> responseHandler, HttpURLConnection connection, ExecutionContext context) throws IOException {
        try (HttpResponse<HttpURLConnection> response = this.createResponse(connection, request);){
            ApiServiceResponse<T> lbResponse = responseHandler.handle(response);
            if (lbResponse == null) {
                throw new AuthClientException("Unable to parse response metadata, path: " + request.getResourcePath());
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Received successful response: " + response.getStatusCode());
            }
            T t = lbResponse.getResult();
            return t;
        }
    }

    private HttpResponse<HttpURLConnection> createResponse(HttpURLConnection connection, HttpRequest<HttpURLConnection> request) throws IOException {
        return new HttpUrlConnectionResponse(connection, request);
    }

    private void resetRequestAfterError(Request request, Exception cause) throws AuthClientException {
        if (request.getContent() == null) {
            return;
        }
        if (!request.getContent().markSupported()) {
            throw new AuthClientException("Encountered an exception and stream is not resettable", cause);
        }
        try {
            request.getContent().reset();
        }
        catch (IOException ioex) {
            throw new AuthClientException("Encountered an exception and couldn't reset the stream to retry", cause);
        }
    }

    private void pauseExponentially(int retries, AuthServiceException previousException, CustomBackoffStrategy backoffStrategy) {
        long delay = 0L;
        if (backoffStrategy != null) {
            delay = backoffStrategy.getBackoffPeriod(retries);
        } else {
            long scaleFactor = 300L;
            if (HttpUrlConnectionAuthClient.isThrottlingException(previousException)) {
                scaleFactor = 500 + random.nextInt(100);
            }
            delay = (long)(Math.pow(2.0, retries) * (double)scaleFactor);
        }
        delay = Math.min(delay, 20000L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries);
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new AuthClientException(ex.getMessage(), ex);
        }
    }

    public static boolean isThrottlingException(AuthServiceException ase) {
        if (ase == null) {
            return false;
        }
        return "Throttling".equals(ase.getErrorCode()) || "ThrottlingException".equals(ase.getErrorCode());
    }

    public static boolean isRequestEntityTooLargeException(AuthServiceException ase) {
        if (ase == null) {
            return false;
        }
        return "Request entity too large".equals(ase.getErrorCode());
    }

    @Override
    public void shutdown() {
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }
}

