/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.http.basic;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qas.api.http.AbstractHttpResponse;
import org.qas.api.http.HttpRequest;
import org.qas.api.http.HttpResponse;

public final class HttpUrlConnectionResponse
extends AbstractHttpResponse<HttpURLConnection>
implements HttpResponse<HttpURLConnection> {
    private final HttpURLConnection connection;
    private final HttpRequest<HttpURLConnection> request;
    private final Map<String, String> headers = new HashMap<String, String>();
    private int statusCode;
    private String status;
    private InputStream content;

    public HttpUrlConnectionResponse(HttpURLConnection connection, HttpRequest<HttpURLConnection> request) throws IOException {
        this.connection = connection;
        this.request = request;
        this.statusCode = connection.getResponseCode();
        this.status = connection.getResponseMessage();
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        if (headerFields != null && !headerFields.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || entry.getValue().size() <= 0) continue;
                this.headers.put(entry.getKey(), entry.getValue().get(0));
            }
        }
        this.content = connection.getErrorStream();
        if (this.content == null) {
            this.content = connection.getInputStream();
        }
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.content;
    }

    @Override
    public int getStatusCode() throws IOException {
        return this.statusCode;
    }

    @Override
    public String getStatus() throws IOException {
        return this.status;
    }

    @Override
    public HttpRequest<HttpURLConnection> getRequest() {
        return this.request;
    }

    @Override
    public HttpURLConnection getUnderlying() {
        return this.connection;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public void close() {
        try {
            this.connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

