/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.internal.util.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.internal.util.json.JsonTokener;

public class JsonArray {
    private ArrayList<Object> myArrayList = new ArrayList();

    public JsonArray() {
    }

    public JsonArray(JsonTokener x) throws JsonException {
        this();
        char q;
        char c = x.nextClean();
        if (c == '[') {
            q = ']';
        } else if (c == '(') {
            q = ')';
        } else {
            throw x.syntaxError("A JsonArray text must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.myArrayList.add(null);
            } else {
                x.back();
                this.myArrayList.add(x.nextValue());
            }
            c = x.nextClean();
            switch (c) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ')': 
                case ']': {
                    if (q != c) {
                        throw x.syntaxError("Expected a '" + new Character(q) + "'");
                    }
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    public JsonArray(String source) throws JsonException {
        this(new JsonTokener(source));
    }

    public JsonArray(Collection collection) {
        if (collection != null) {
            for (Object o : collection) {
                this.myArrayList.add(JsonObject.wrap(o));
            }
        }
    }

    public JsonArray(Object array) throws JsonException {
        this();
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                this.put(JsonObject.wrap(Array.get(array, i)));
            }
        } else {
            throw new JsonException("JsonArray initial value should be a string or collection or array.");
        }
    }

    public Object get(int index) throws JsonException {
        Object o = this.opt(index);
        if (o == null) {
            throw new JsonException("JsonArray[" + index + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(int index) throws JsonException {
        Object o = this.get(index);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JsonException("JsonArray[" + index + "] is not a Boolean.");
    }

    public double getDouble(int index) throws JsonException {
        Object o = this.get(index);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.valueOf((String)o).doubleValue();
        }
        catch (Exception e) {
            throw new JsonException("JsonArray[" + index + "] is not a number.");
        }
    }

    public int getInt(int index) throws JsonException {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index);
    }

    public JsonArray getJsonArray(int index) throws JsonException {
        Object o = this.get(index);
        if (o instanceof JsonArray) {
            return (JsonArray)o;
        }
        throw new JsonException("JsonArray[" + index + "] is not a JsonArray.");
    }

    public JsonObject getJsonObject(int index) throws JsonException {
        Object o = this.get(index);
        if (o instanceof JsonObject) {
            return (JsonObject)o;
        }
        throw new JsonException("JsonArray[" + index + "] is not a JsonObject.");
    }

    public long getLong(int index) throws JsonException {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(index);
    }

    public String getString(int index) throws JsonException {
        return this.get(index).toString();
    }

    public boolean isNull(int index) {
        return JsonObject.NULL.equals(this.opt(index));
    }

    public String join(String separator) throws JsonException {
        int len = this.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(JsonObject.valueToString(this.myArrayList.get(i)));
        }
        return sb.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index) {
        return index < 0 || index >= this.length() ? null : this.myArrayList.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JsonArray optJsonArray(int index) {
        Object o = this.opt(index);
        return o instanceof JsonArray ? (JsonArray)o : null;
    }

    public JsonObject optJsonObject(int index) {
        Object o = this.opt(index);
        return o instanceof JsonObject ? (JsonObject)o : null;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        return o != null ? o.toString() : defaultValue;
    }

    public JsonArray put(boolean value) {
        this.put(value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonArray put(Collection value) {
        this.put(new JsonArray(value));
        return this;
    }

    public JsonArray put(double value) throws JsonException {
        Double d = new Double(value);
        JsonObject.testValidity(d);
        this.put(d);
        return this;
    }

    public JsonArray put(int value) {
        this.put(new Integer(value));
        return this;
    }

    public JsonArray put(long value) {
        this.put(new Long(value));
        return this;
    }

    public JsonArray put(Map value) {
        this.put(new JsonObject(value));
        return this;
    }

    public JsonArray put(Object value) {
        this.myArrayList.add(value);
        return this;
    }

    public JsonArray put(int index, boolean value) throws JsonException {
        this.put(index, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonArray put(int index, Collection value) throws JsonException {
        this.put(index, new JsonArray(value));
        return this;
    }

    public JsonArray put(int index, double value) throws JsonException {
        this.put(index, new Double(value));
        return this;
    }

    public JsonArray put(int index, int value) throws JsonException {
        this.put(index, new Integer(value));
        return this;
    }

    public JsonArray put(int index, long value) throws JsonException {
        this.put(index, new Long(value));
        return this;
    }

    public JsonArray put(int index, Map value) throws JsonException {
        this.put(index, new JsonObject(value));
        return this;
    }

    public JsonArray put(int index, Object value) throws JsonException {
        JsonObject.testValidity(value);
        if (index < 0) {
            throw new JsonException("JsonArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            this.myArrayList.set(index, value);
        } else {
            while (index != this.length()) {
                this.put(JsonObject.NULL);
            }
            this.put(value);
        }
        return this;
    }

    public Object remove(int index) {
        Object o = this.opt(index);
        this.myArrayList.remove(index);
        return o;
    }

    public JsonObject toJsonObject(JsonArray names) throws JsonException {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JsonObject jo = new JsonObject();
        for (int i = 0; i < names.length(); ++i) {
            jo.put(names.getString(i), this.opt(i));
        }
        return jo;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JsonException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws JsonException {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[");
        if (len == 1) {
            sb.append(JsonObject.valueToString(this.myArrayList.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JsonObject.valueToString(this.myArrayList.get(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public Writer write(Writer writer) throws JsonException {
        try {
            boolean b = false;
            int len = this.length();
            writer.write(91);
            for (int i = 0; i < len; ++i) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = this.myArrayList.get(i)) instanceof JsonObject) {
                    ((JsonObject)v).write(writer);
                } else if (v instanceof JsonArray) {
                    ((JsonArray)v).write(writer);
                } else {
                    writer.write(JsonObject.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }
}

