/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.internal.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;

public class CreateObjectCommentRequestMarshaller
extends AbstractMarshaller<Request, CreateObjectCommentRequest> {
    private final String service;

    public CreateObjectCommentRequestMarshaller(String service) {
        this.service = service;
    }

    @Override
    protected void validateRequest(CreateObjectCommentRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to call(...)");
        }
        if (in.getProjectId() == null) {
            throw new AuthClientException("Invalid project id passed to the call(...)");
        }
        if (in.getObjectId() == null) {
            throw new AuthClientException("Invalid object id passed to the call(...)");
        }
        if (in.getObjectType() == null) {
            throw new AuthClientException("Invalid object type passed to the call(...)");
        }
        if (in.getComment() == null || "".equals(in.getComment())) {
            throw new AuthClientException("Invalid comment passed to the call(...)");
        }
    }

    @Override
    protected void build(Request request, CreateObjectCommentRequest in) {
        request.setHttpMethod(HttpMethod.POST);
    }

    @Override
    protected String getServiceName() {
        return this.service;
    }

    @Override
    protected String getActionName() {
        return "AddComment";
    }

    @Override
    protected String getContent(CreateObjectCommentRequest in) throws JsonException {
        return new JsonObject().accumulate("content", in.getComment()).toString();
    }

    @Override
    protected StringBuilder getResourcePath(CreateObjectCommentRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/").append(in.getObjectType().getPath()).append("/").append(in.getObjectId()).append("/comments");
    }
}

