/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.attachment.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.qas.api.AuthClientException;
import org.qas.api.internal.util.Encoders;
import org.qas.api.internal.util.google.io.BaseEncoding;
import org.qas.qtest.api.internal.model.QTestBaseModel;

public class Attachment
extends QTestBaseModel<Attachment> {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="content_type")
    private String contentType;
    @JsonProperty(value="data")
    private String content;
    @JsonIgnore
    private InputStream inputStream;

    public Long getId() {
        return this.id;
    }

    public Attachment setId(Long id) {
        this.id = id;
        return this;
    }

    public Attachment withId(Long id) {
        this.setId(id);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Attachment setName(String name) {
        this.name = name;
        return this;
    }

    public Attachment withName(String name) {
        this.setName(name);
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Attachment setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Attachment withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    @JsonGetter(value="data")
    public String getContent() {
        if (this.content == null) {
            if (this.inputStream == null) {
                return null;
            }
            try {
                this.content = BaseEncoding.base64().encode(this.getBinaryFromInputStream(this.inputStream, false));
            }
            catch (IOException e) {
                throw new AuthClientException("Error while converting input stream", e);
            }
        }
        return this.content;
    }

    @JsonSetter(value="data")
    public Attachment setContent(String content) {
        this.content = content;
        if (null != content) {
            this.inputStream = new ByteArrayInputStream(Encoders.base64DecodeText(content));
        }
        return this;
    }

    public InputStream getData() {
        return this.inputStream;
    }

    public Attachment setData(InputStream content) {
        this.inputStream = content;
        return this;
    }

    public Attachment withData(InputStream content) {
        this.setData(content);
        return this;
    }

    @Override
    protected Attachment clone() {
        Attachment that = new Attachment();
        that.setPropertiesFrom(this);
        return that;
    }

    @Override
    public String elementName() {
        return "attachment";
    }
}

