/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.authenticate.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.authenticate.model.OAuthTokenRefreshRequest;
import org.qas.qtest.api.services.authenticate.model.transform.OAuthAuthenticateRequestMarshaller;

public class OAuthTokenRefreshRequestMarshaller
extends AbstractMarshaller<Request, OAuthTokenRefreshRequest> {
    @Override
    protected void validateRequest(OAuthTokenRefreshRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to call (...)");
        }
    }

    @Override
    protected void build(Request request, OAuthTokenRefreshRequest in) {
        request.setHttpMethod(HttpMethod.POST);
        request.setHeader("Authorization", OAuthAuthenticateRequestMarshaller.normalizeToken(in.getToken(), "Bearer"));
    }

    @Override
    protected String getServiceName() {
        return "AuthenticateService";
    }

    @Override
    protected String getActionName() {
        return "TokenRefresh";
    }

    @Override
    protected String getContent(OAuthTokenRefreshRequest in) throws Exception {
        return null;
    }

    @Override
    protected StringBuilder getResourcePath(OAuthTokenRefreshRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/oauth/refresh");
    }
}

