/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.google.base.Strings;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.execution.model.AutomationTestLog;
import org.qas.qtest.api.services.execution.model.AutomationTestLogsRequest;
import org.qas.qtest.api.services.execution.model.AutomationTestStepLog;

public final class AutomationTestLogsExtendedRequestMarshaller
extends AbstractMarshaller<Request, AutomationTestLogsRequest> {
    @Override
    protected void validateRequest(AutomationTestLogsRequest in) {
        if (null == in) {
            throw new AuthClientException("Invalid argument passed to marshall(...)");
        }
        if (null == in.getProjectId() || in.getProjectId() <= 0L) {
            throw new AuthClientException("Invalid project id passed to marshall(...)");
        }
        if (null == in.getExecutionDate()) {
            throw new AuthClientException("Invalid executionDate passed to marshall(...)");
        }
        if (Strings.isNullOrEmpty(in.getTestCycle())) {
            throw new AuthClientException("Invalid TestCycle passed to marshall(...)");
        }
        if (CollectionUtils.isEmpty(in.getTestLogResources())) {
            throw new AuthClientException("Invalid TestLogResources passed to marshall(...)");
        }
        for (AutomationTestLog item : in.getTestLogResources()) {
            if (null == item.getExecutionEndDate() || null == item.getExecutionStartDate() || CollectionUtils.isEmpty(item.getModuleNames()) || Strings.isNullOrEmpty(item.getStatus()) || Strings.isNullOrEmpty(item.getName()) || Strings.isNullOrEmpty(item.getAutomationContent())) {
                throw new AuthClientException("Invalid TestLogResources passed to marshall(...)");
            }
            List<AutomationTestStepLog> automationTestStepLogs = item.getTestStepLogs();
            if (!CollectionUtils.isNotEmpty(automationTestStepLogs)) continue;
            for (AutomationTestStepLog stepLog : automationTestStepLogs) {
                if (!Strings.isNullOrEmpty(stepLog.getDescription()) && !Strings.isNullOrEmpty(stepLog.getExpected())) continue;
                throw new AuthClientException("Invalid testStepLogs passed to marshall(...)");
            }
        }
    }

    @Override
    protected void build(Request request, AutomationTestLogsRequest in) {
        request.setHttpMethod(HttpMethod.POST);
        request.addParameter("type", in.getAutomationType().getValue());
        request.addParameter("escapeXml", String.valueOf(in.isEscapeXml()));
        if (null != in.getUserId()) {
            request.addParameter("userId", String.valueOf(in.getUserId()));
        }
    }

    @Override
    protected String getServiceName() {
        return "TestExecutionService";
    }

    @Override
    protected String getActionName() {
        return "SubmitAutomationTestLogsExtended";
    }

    @Override
    protected String getContent(AutomationTestLogsRequest in) {
        return JsonMapper.toJson(in);
    }

    @Override
    protected StringBuilder getResourcePath(AutomationTestLogsRequest in, StringBuilder rpBuilder) {
        rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/auto-test-logs");
        return rpBuilder;
    }
}

