/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.CreateTestCycleRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestCycleRequestMarshaller;

public final class CreateTestCycleRequestMarshaller
extends AbstractTestCycleRequestMarshaller<CreateTestCycleRequest> {
    @Override
    public Request marshall(CreateTestCycleRequest testCycleRequest) throws Exception {
        testCycleRequest = ApiPreconditions.notNull(testCycleRequest);
        ApiPreconditions.notNull(testCycleRequest.getTestCycle(), "Invalid test-cycle data passed to marshall(...)");
        CreateTestCycleRequestMarshaller.validateProjectId(testCycleRequest.getProjectId());
        CreateTestCycleRequestMarshaller.validateArtifactLevel(testCycleRequest.getArtifactLevel());
        CreateTestCycleRequestMarshaller.validateArtifact(testCycleRequest.getArtifactLevel(), testCycleRequest.getArtifactId());
        Request request = this.createJsonRequest(testCycleRequest, "CreateTestCycle", HttpMethod.POST);
        request.setResourcePath(this.createApiPathBuilder(testCycleRequest.getProjectId()).toString());
        if (testCycleRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
            request.addParameter("parentId", String.valueOf(testCycleRequest.getArtifactId()));
            request.addParameter("parentType", testCycleRequest.getArtifactLevel().getQueryParam());
        }
        request.setContent(new StringInputStream(JsonMapper.toJson(testCycleRequest.getTestCycle())));
        return request;
    }
}

