/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.MoveTestRunRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestRunRequestMarshaller;

public final class MoveTestRunRequestMarshaller
extends AbstractTestRunRequestMarshaller<MoveTestRunRequest> {
    @Override
    public Request marshall(MoveTestRunRequest testRunRequest) throws Exception {
        testRunRequest = ApiPreconditions.notNull(testRunRequest);
        MoveTestRunRequestMarshaller.validateProjectId(testRunRequest.getProjectId());
        MoveTestRunRequestMarshaller.validateTestRunId(testRunRequest.getTestRunId());
        MoveTestRunRequestMarshaller.validateArtifactLevel(testRunRequest.getArtifactLevel());
        MoveTestRunRequestMarshaller.validateArtifact(testRunRequest.getArtifactLevel(), testRunRequest.getArtifactId());
        Request request = this.createJsonRequest(testRunRequest, "MoveTestRun", HttpMethod.PUT);
        StringBuilder pathBuilder = this.createApiPathBuilder(testRunRequest.getProjectId());
        pathBuilder.append("/").append(testRunRequest.getTestRunId());
        request.setResourcePath(pathBuilder.toString());
        if (testRunRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
            request.addParameter("parentId", String.valueOf(testRunRequest.getArtifactId()));
        } else {
            request.addParameter("parentId", "0");
        }
        request.addParameter("parentType", testRunRequest.getArtifactLevel().getQueryParam());
        request.setContent(new StringInputStream("{}"));
        return request;
    }
}

