/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.host.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.host.model.UpdateJobStatusRequest;

public class UpdateJobStatusRequestMarshaller
extends AbstractMarshaller<Request, UpdateJobStatusRequest> {
    @Override
    protected void validateRequest(UpdateJobStatusRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to marshall(...)");
        }
        if (in.getJobServerId() == null || in.getProjectId() == null || in.getStatus() == null) {
            throw new AuthClientException("Invalid job request parameters passed to marshall(...)");
        }
    }

    @Override
    protected void build(Request request, UpdateJobStatusRequest in) {
        request.setHttpMethod(HttpMethod.PUT);
    }

    @Override
    protected String getServiceName() {
        return "HostService";
    }

    @Override
    protected String getActionName() {
        return "UpdateJobStatus";
    }

    @Override
    protected String getContent(UpdateJobStatusRequest in) throws Exception {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("status", in.getStatus().name());
        jsonObject.put("agentLog", in.getAgentLog());
        jsonObject.put("consoleLog", in.getConsoleLog());
        return jsonObject.toString();
    }

    @Override
    protected StringBuilder getResourcePath(UpdateJobStatusRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/automation/jobs/").append(in.getJobServerId()).append("/status");
    }
}

