/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.codec.list;

import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.client.socket.PacketWriter;
import com.singlestore.jdbc.codec.Codec;
import com.singlestore.jdbc.codec.DataType;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;

public class FloatCodec
implements Codec<Float> {
    public static final FloatCodec INSTANCE = new FloatCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INT, DataType.FLOAT, DataType.BIGINT, DataType.OLDDECIMAL, DataType.DECIMAL, DataType.YEAR, DataType.DOUBLE, DataType.VARCHAR, DataType.CHAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Float.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Float.TYPE || type.isAssignableFrom(Float.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Float;
    }

    @Override
    public Float decodeText(ReadableByteBuf buffer, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        return Float.valueOf(this.decodeTextFloat(buffer, length, column));
    }

    public float decodeTextFloat(ReadableByteBuf buf, int length, ColumnDefinitionPacket column) throws SQLDataException {
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INT: 
            case BIGINT: 
            case DOUBLE: 
            case OLDDECIMAL: 
            case DECIMAL: 
            case FLOAT: 
            case YEAR: {
                return Float.valueOf(buf.readAscii(length)).floatValue();
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case CHAR: {
                String val = buf.readString(length);
                try {
                    return Float.valueOf(val).floatValue();
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Float", val));
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{column.getType()}));
    }

    @Override
    public Float decodeBinary(ReadableByteBuf buffer, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        return Float.valueOf(this.decodeBinaryFloat(buffer, length, column));
    }

    public float decodeBinaryFloat(ReadableByteBuf buf, int length, ColumnDefinitionPacket column) throws SQLDataException {
        switch (column.getType()) {
            case TINYINT: {
                if (!column.isSigned()) {
                    return buf.readUnsignedByte();
                }
                return buf.readByte();
            }
            case SMALLINT: 
            case YEAR: {
                if (!column.isSigned()) {
                    return buf.readUnsignedShort();
                }
                return buf.readShort();
            }
            case MEDIUMINT: {
                float f = column.isSigned() ? (float)buf.readMedium() : (float)buf.readUnsignedMedium();
                buf.skip();
                return f;
            }
            case INT: {
                if (!column.isSigned()) {
                    return buf.readUnsignedInt();
                }
                return buf.readInt();
            }
            case BIGINT: {
                if (column.isSigned()) {
                    return buf.readLong();
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                return new BigInteger(1, bb).floatValue();
            }
            case FLOAT: {
                return buf.readFloat();
            }
            case DOUBLE: {
                return (float)buf.readDouble();
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return new BigDecimal(buf.readAscii(length)).floatValue();
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case CHAR: {
                String str2 = buf.readString(length);
                try {
                    return Float.valueOf(str2).floatValue();
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Float", str2));
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(PacketWriter encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public void encodeBinary(PacketWriter encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeFloat(((Float)value).floatValue());
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.FLOAT.get();
    }
}

