/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.type;

import com.singlestore.jdbc.type.LineString;
import com.singlestore.jdbc.type.Point;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Polygon {
    private final LineString[] lines;
    private static final Pattern polygonPattern = Pattern.compile("^POLYGON\\((.*)\\)$");

    public Polygon(String s) throws IllegalArgumentException {
        Matcher m = polygonPattern.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException();
        }
        String[] ringStrings = m.group(1).split("(?<=\\)), (?=\\()");
        this.lines = new LineString[ringStrings.length];
        for (int i = 0; i < ringStrings.length; ++i) {
            this.lines[i] = LineString.FromRingString(ringStrings[i]);
        }
    }

    public Polygon(LineString[] lines) {
        this.lines = lines;
    }

    public LineString[] getLines() {
        return this.lines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("POLYGON(");
        int indexLine = 0;
        for (LineString ls : this.lines) {
            if (indexLine++ > 0) {
                sb.append(", ");
            }
            sb.append("(");
            int index = 0;
            for (Point pt : ls.getPoints()) {
                if (index++ > 0) {
                    sb.append(", ");
                }
                sb.append(pt.getX()).append(" ").append(pt.getY());
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Polygon)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return Arrays.hashCode(this.lines);
    }
}

