/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatesoftware.sonar.plugins.mulesoft;

import java.util.LinkedHashMap;
import java.util.Map;
import org.sonar.api.batch.fs.InputFile;

public class ReversePathTree {
    private Node root = new Node();

    public void index(InputFile inputFile, String[] path) {
        Node currentNode = this.root;
        for (int i = path.length - 1; i >= 0; --i) {
            currentNode = currentNode.children.computeIfAbsent(path[i], e -> new Node());
        }
        currentNode.file = inputFile;
    }

    public InputFile getFileWithSuffix(String[] path) {
        Node currentNode = this.root;
        for (int i = path.length - 1; i >= 0; --i) {
            currentNode = currentNode.children.get(path[i]);
            if (currentNode != null) continue;
            return null;
        }
        return ReversePathTree.getFirstLeaf(currentNode);
    }

    private static InputFile getFirstLeaf(Node node) {
        while (!node.children.isEmpty()) {
            node = node.children.values().iterator().next();
        }
        return node.file;
    }

    static class Node {
        Map<String, Node> children = new LinkedHashMap<String, Node>();
        InputFile file = null;

        Node() {
        }
    }
}

