/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.common;

import com.google.common.collect.Sets;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonException;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BundleConfigurationReader {
    private final JsonObject bundleConfigurationJson;

    public BundleConfigurationReader(File bundleConfigurationFile) {
        String fileContents;
        Objects.requireNonNull(bundleConfigurationFile, "Bundle configuration file cannot be null.");
        try {
            fileContents = new String(Files.readAllBytes(bundleConfigurationFile.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to read specified bundle configuration file %s.", bundleConfigurationFile), e);
        }
        try {
            this.bundleConfigurationJson = Json.parse((String)fileContents);
        }
        catch (JsonException e) {
            throw new IllegalArgumentException(String.format("Specified bundle configuration file '%s' does not contain valid Json.", bundleConfigurationFile), e);
        }
    }

    public Map<String, Set<String>> getFragments() {
        JsonArray fragmentsArray;
        HashMap<String, Set<String>> fragments = new HashMap<String, Set<String>>();
        if (this.bundleConfigurationJson == null || !this.bundleConfigurationJson.hasKey("fragments")) {
            return fragments;
        }
        try {
            fragmentsArray = this.bundleConfigurationJson.getArray("fragments");
        }
        catch (JsonException | ClassCastException e) {
            throw new IllegalStateException("The 'fragments' property of a given bundle configuration should be an array.", e);
        }
        for (int i = 0; i < fragmentsArray.length(); ++i) {
            JsonObject fragment;
            try {
                fragment = fragmentsArray.getObject(i);
            }
            catch (JsonException | ClassCastException e) {
                throw new IllegalStateException("The 'fragments' array of a given bundle configuration should contain fragment objects only.", e);
            }
            String fragmentName = this.extractFragmentName(fragment);
            fragments.put(fragmentName, this.extractFragmentFiles(fragment, fragmentName));
        }
        return fragments;
    }

    private String extractFragmentName(JsonObject fragment) {
        String fragmentName;
        try {
            fragmentName = fragment.getString("name");
        }
        catch (JsonException | ClassCastException | NullPointerException e) {
            throw new IllegalStateException("Each fragment object in json configuration should have `name` string field specified", e);
        }
        if (fragmentName == null || fragmentName.isEmpty()) {
            throw new IllegalStateException("Each fragment object in json configuration should have non empty name");
        }
        return fragmentName;
    }

    private Set<String> extractFragmentFiles(JsonObject fragment, String fragmentName) {
        JsonArray fragmentFiles;
        try {
            fragmentFiles = fragment.getArray("files");
            if (fragmentFiles == null) {
                throw new IllegalStateException(String.format("Fragment with name '%s' has no `files` array field specified.", fragmentName));
            }
        }
        catch (JsonException | ClassCastException e) {
            throw new IllegalStateException(String.format("Fragment with name '%s' has no `files` array field specified.", fragmentName), e);
        }
        HashSet files = Sets.newHashSetWithExpectedSize((int)fragmentFiles.length());
        for (int j = 0; j < fragmentFiles.length(); ++j) {
            try {
                files.add(fragmentFiles.getString(j));
                continue;
            }
            catch (JsonException | ClassCastException e) {
                throw new IllegalStateException(String.format("The 'files' array of a fragment with name '%s' should only contain string file paths", fragmentName), e);
            }
        }
        if (files.isEmpty()) {
            throw new IllegalStateException(String.format("Fragment with name '%s' has no files specified, each fragment should have at least one file specified", fragmentName));
        }
        return files;
    }
}

