/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.models.AzureChatEnhancementConfiguration;
import com.azure.ai.openai.models.AzureChatExtensionConfiguration;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.http.ProxyOptions;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.ChatRequestValidationUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.azure.InternalAzureOpenAiHelper;
import dev.langchain4j.model.azure.spi.AzureOpenAiChatModelBuilderFactory;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureOpenAiChatModel
implements ChatModel {
    private static final Logger logger = LoggerFactory.getLogger(AzureOpenAiChatModel.class);
    private OpenAIClient client;
    private final String deploymentName;
    private final Integer maxTokens;
    private final Double temperature;
    private final Double topP;
    private final Map<String, Integer> logitBias;
    private final String user;
    private final List<String> stop;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final List<AzureChatExtensionConfiguration> dataSources;
    private final AzureChatEnhancementConfiguration enhancements;
    private final Long seed;
    @Deprecated
    private ChatCompletionsResponseFormat chatCompletionsResponseFormat;
    private final ResponseFormat responseFormat;
    private final Boolean strictJsonSchema;
    private final List<ChatModelListener> listeners;
    private Set<Capability> supportedCapabilities;

    public AzureOpenAiChatModel(OpenAIClient client, String deploymentName, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, List<String> stop, Double presencePenalty, Double frequencyPenalty, List<AzureChatExtensionConfiguration> dataSources, AzureChatEnhancementConfiguration enhancements, Long seed, @Deprecated ChatCompletionsResponseFormat chatCompletionsResponseFormat, ResponseFormat responseFormat, Boolean strictJsonSchema, List<ChatModelListener> listeners, Set<Capability> capabilities) {
        this(deploymentName, maxTokens, temperature, topP, logitBias, user, stop, presencePenalty, frequencyPenalty, dataSources, enhancements, seed, chatCompletionsResponseFormat, responseFormat, strictJsonSchema, listeners, capabilities);
        this.client = client;
    }

    public AzureOpenAiChatModel(String endpoint, String serviceVersion, String apiKey, HttpClientProvider httpClientProvider, String deploymentName, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, List<String> stop, Double presencePenalty, Double frequencyPenalty, List<AzureChatExtensionConfiguration> dataSources, AzureChatEnhancementConfiguration enhancements, Long seed, @Deprecated ChatCompletionsResponseFormat chatCompletionsResponseFormat, ResponseFormat responseFormat, Boolean strictJsonSchema, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, List<ChatModelListener> listeners, String userAgentSuffix, Map<String, String> customHeaders, Set<Capability> capabilities) {
        this(deploymentName, maxTokens, temperature, topP, logitBias, user, stop, presencePenalty, frequencyPenalty, dataSources, enhancements, seed, chatCompletionsResponseFormat, responseFormat, strictJsonSchema, listeners, capabilities);
        this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, apiKey, timeout, maxRetries, httpClientProvider, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
    }

    public AzureOpenAiChatModel(String endpoint, String serviceVersion, KeyCredential keyCredential, HttpClientProvider httpClientProvider, String deploymentName, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, List<String> stop, Double presencePenalty, Double frequencyPenalty, List<AzureChatExtensionConfiguration> dataSources, AzureChatEnhancementConfiguration enhancements, Long seed, @Deprecated ChatCompletionsResponseFormat chatCompletionsResponseFormat, ResponseFormat responseFormat, Boolean strictJsonSchema, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, List<ChatModelListener> listeners, String userAgentSuffix, Map<String, String> customHeaders, Set<Capability> capabilities) {
        this(deploymentName, maxTokens, temperature, topP, logitBias, user, stop, presencePenalty, frequencyPenalty, dataSources, enhancements, seed, chatCompletionsResponseFormat, responseFormat, strictJsonSchema, listeners, capabilities);
        this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, keyCredential, timeout, maxRetries, httpClientProvider, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
    }

    public AzureOpenAiChatModel(String endpoint, String serviceVersion, TokenCredential tokenCredential, HttpClientProvider httpClientProvider, String deploymentName, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, List<String> stop, Double presencePenalty, Double frequencyPenalty, List<AzureChatExtensionConfiguration> dataSources, AzureChatEnhancementConfiguration enhancements, Long seed, @Deprecated ChatCompletionsResponseFormat chatCompletionsResponseFormat, ResponseFormat responseFormat, Boolean strictJsonSchema, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses, List<ChatModelListener> listeners, String userAgentSuffix, Map<String, String> customHeaders, Set<Capability> capabilities) {
        this(deploymentName, maxTokens, temperature, topP, logitBias, user, stop, presencePenalty, frequencyPenalty, dataSources, enhancements, seed, chatCompletionsResponseFormat, responseFormat, strictJsonSchema, listeners, capabilities);
        this.client = InternalAzureOpenAiHelper.setupSyncClient(endpoint, serviceVersion, tokenCredential, timeout, maxRetries, httpClientProvider, proxyOptions, logRequestsAndResponses, userAgentSuffix, customHeaders);
    }

    private AzureOpenAiChatModel(String deploymentName, Integer maxTokens, Double temperature, Double topP, Map<String, Integer> logitBias, String user, List<String> stop, Double presencePenalty, Double frequencyPenalty, List<AzureChatExtensionConfiguration> dataSources, AzureChatEnhancementConfiguration enhancements, Long seed, @Deprecated ChatCompletionsResponseFormat chatCompletionsResponseFormat, ResponseFormat responseFormat, Boolean strictJsonSchema, List<ChatModelListener> listeners, Set<Capability> capabilities) {
        this.deploymentName = (String)Utils.getOrDefault((Object)deploymentName, (Object)"gpt-35-turbo");
        this.maxTokens = maxTokens;
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.logitBias = logitBias;
        this.user = user;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.dataSources = dataSources;
        this.enhancements = enhancements;
        this.seed = seed;
        this.chatCompletionsResponseFormat = chatCompletionsResponseFormat;
        this.responseFormat = responseFormat;
        if (this.chatCompletionsResponseFormat != null && this.responseFormat != null) {
            throw new IllegalArgumentException("You can't set both chatCompletionsResponseFormat and responseFormat");
        }
        this.strictJsonSchema = (Boolean)Utils.getOrDefault((Object)strictJsonSchema, (Object)false);
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
        this.supportedCapabilities = Utils.copyIfNotNull(capabilities);
    }

    public Set<Capability> supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public ChatResponse chat(ChatRequest request) {
        ChatRequestParameters parameters = request.parameters();
        ChatRequestValidationUtils.validateParameters((ChatRequestParameters)parameters);
        if (parameters.toolChoice() == ToolChoice.REQUIRED && parameters.toolSpecifications().size() != 1) {
            throw new UnsupportedFeatureException(String.format("%s.%s is currently supported only when there is a single tool", ToolChoice.class.getSimpleName(), ToolChoice.REQUIRED.name()));
        }
        ResponseFormat responseFormat = parameters.responseFormat();
        if (responseFormat == null) {
            responseFormat = this.responseFormat;
        }
        ToolSpecification toolThatMustBeExecuted = null;
        if (parameters.toolChoice() == ToolChoice.REQUIRED) {
            toolThatMustBeExecuted = (ToolSpecification)parameters.toolSpecifications().get(0);
        }
        Response<AiMessage> response = this.generate(request.messages(), parameters.toolSpecifications(), toolThatMustBeExecuted, responseFormat);
        return ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted, ResponseFormat responseFormat) {
        ChatCompletionsResponseFormat chatCompletionsResponseFormat = null;
        chatCompletionsResponseFormat = responseFormat != null ? InternalAzureOpenAiHelper.toAzureOpenAiResponseFormat(responseFormat, this.strictJsonSchema) : this.chatCompletionsResponseFormat;
        ChatCompletionsOptions options = new ChatCompletionsOptions(InternalAzureOpenAiHelper.toOpenAiMessages(messages)).setModel(this.deploymentName).setMaxTokens(this.maxTokens).setTemperature(this.temperature).setTopP(this.topP).setLogitBias(this.logitBias).setUser(this.user).setStop(this.stop).setPresencePenalty(this.presencePenalty).setFrequencyPenalty(this.frequencyPenalty).setDataSources(this.dataSources).setEnhancements(this.enhancements).setSeed(this.seed).setResponseFormat(chatCompletionsResponseFormat);
        if (toolThatMustBeExecuted != null) {
            options.setTools(InternalAzureOpenAiHelper.toToolDefinitions(Collections.singletonList(toolThatMustBeExecuted)));
            options.setToolChoice(InternalAzureOpenAiHelper.toToolChoice(toolThatMustBeExecuted));
        }
        if (!Utils.isNullOrEmpty(toolSpecifications)) {
            options.setTools(InternalAzureOpenAiHelper.toToolDefinitions(toolSpecifications));
        }
        ChatRequest listenerRequest = InternalAzureOpenAiHelper.createListenerRequest(options, messages, toolSpecifications);
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(listenerRequest, this.provider(), attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                logger.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        try {
            ChatCompletions chatCompletions = this.client.getChatCompletions(this.deploymentName, options);
            Response response = Response.from((Object)InternalAzureOpenAiHelper.aiMessageFrom(((ChatChoice)chatCompletions.getChoices().get(0)).getMessage()), (TokenUsage)InternalAzureOpenAiHelper.tokenUsageFrom(chatCompletions.getUsage()), (FinishReason)InternalAzureOpenAiHelper.finishReasonFrom(((ChatChoice)chatCompletions.getChoices().get(0)).getFinishReason()));
            ChatResponse listenerResponse = InternalAzureOpenAiHelper.createListenerResponse(chatCompletions.getId(), options.getModel(), (Response<AiMessage>)response);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(listenerResponse, listenerRequest, this.provider(), attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    logger.warn("Exception while calling model listener", (Throwable)e);
                }
            });
            return response;
        }
        catch (Exception exception) {
            ChatModelErrorContext errorContext = new ChatModelErrorContext((Throwable)exception, listenerRequest, this.provider(), attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onError(errorContext);
                }
                catch (Exception e2) {
                    logger.warn("Exception while calling model listener", (Throwable)e2);
                }
            });
            throw exception;
        }
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.AZURE_OPEN_AI;
    }

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(AzureOpenAiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            AzureOpenAiChatModelBuilderFactory factory = (AzureOpenAiChatModelBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return new Builder();
    }

    public static class Builder {
        private String endpoint;
        private String serviceVersion;
        private String apiKey;
        private KeyCredential keyCredential;
        private TokenCredential tokenCredential;
        private HttpClientProvider httpClientProvider;
        private String deploymentName;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private Map<String, Integer> logitBias;
        private String user;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private List<AzureChatExtensionConfiguration> dataSources;
        private AzureChatEnhancementConfiguration enhancements;
        private Long seed;
        private ChatCompletionsResponseFormat chatCompletionsResponseFormat;
        private ResponseFormat responseFormat;
        private Boolean strictJsonSchema;
        private Duration timeout;
        private Integer maxRetries;
        private ProxyOptions proxyOptions;
        private boolean logRequestsAndResponses;
        private OpenAIClient openAIClient;
        private String userAgentSuffix;
        private List<ChatModelListener> listeners;
        private Map<String, String> customHeaders;
        private Set<Capability> capabilities;

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder nonAzureApiKey(String nonAzureApiKey) {
            this.keyCredential = new KeyCredential(nonAzureApiKey);
            this.endpoint = "https://api.openai.com/v1";
            return this;
        }

        public Builder tokenCredential(TokenCredential tokenCredential) {
            this.tokenCredential = tokenCredential;
            return this;
        }

        public Builder httpClientProvider(HttpClientProvider httpClientProvider) {
            this.httpClientProvider = httpClientProvider;
            return this;
        }

        public Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder dataSources(List<AzureChatExtensionConfiguration> dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public Builder enhancements(AzureChatEnhancementConfiguration enhancements) {
            this.enhancements = enhancements;
            return this;
        }

        public Builder seed(Long seed) {
            this.seed = seed;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder responseFormat(ChatCompletionsResponseFormat chatCompletionsResponseFormat) {
            this.chatCompletionsResponseFormat = chatCompletionsResponseFormat;
            return this;
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public Builder strictJsonSchema(Boolean strictJsonSchema) {
            this.strictJsonSchema = strictJsonSchema;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxyOptions(ProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        public Builder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        public Builder userAgentSuffix(String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public Builder openAIClient(OpenAIClient openAIClient) {
            this.openAIClient = openAIClient;
            return this;
        }

        public Builder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public Builder supportedCapabilities(Set<Capability> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public AzureOpenAiChatModel build() {
            if (this.capabilities == null) {
                this.capabilities = new HashSet<Capability>();
            }
            if (this.openAIClient == null) {
                if (this.tokenCredential != null) {
                    return new AzureOpenAiChatModel(this.endpoint, this.serviceVersion, this.tokenCredential, this.httpClientProvider, this.deploymentName, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.stop, this.presencePenalty, this.frequencyPenalty, this.dataSources, this.enhancements, this.seed, this.chatCompletionsResponseFormat, this.responseFormat, this.strictJsonSchema, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.listeners, this.userAgentSuffix, this.customHeaders, this.capabilities);
                }
                if (this.keyCredential != null) {
                    return new AzureOpenAiChatModel(this.endpoint, this.serviceVersion, this.keyCredential, this.httpClientProvider, this.deploymentName, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.stop, this.presencePenalty, this.frequencyPenalty, this.dataSources, this.enhancements, this.seed, this.chatCompletionsResponseFormat, this.responseFormat, this.strictJsonSchema, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.listeners, this.userAgentSuffix, this.customHeaders, this.capabilities);
                }
                return new AzureOpenAiChatModel(this.endpoint, this.serviceVersion, this.apiKey, this.httpClientProvider, this.deploymentName, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.stop, this.presencePenalty, this.frequencyPenalty, this.dataSources, this.enhancements, this.seed, this.chatCompletionsResponseFormat, this.responseFormat, this.strictJsonSchema, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses, this.listeners, this.userAgentSuffix, this.customHeaders, this.capabilities);
            }
            return new AzureOpenAiChatModel(this.openAIClient, this.deploymentName, this.maxTokens, this.temperature, this.topP, this.logitBias, this.user, this.stop, this.presencePenalty, this.frequencyPenalty, this.dataSources, this.enhancements, this.seed, this.chatCompletionsResponseFormat, this.responseFormat, this.strictJsonSchema, this.listeners, this.capabilities);
        }
    }
}

