/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge;

import org.sonar.api.Plugin;
import org.sonar.api.PropertyType;
import org.sonar.api.SonarProduct;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.plugins.openedge.decorator.CommonDBMetricsDecorator;
import org.sonar.plugins.openedge.decorator.CommonMetricsDecorator;
import org.sonar.plugins.openedge.foundation.BasicChecksRegistration;
import org.sonar.plugins.openedge.foundation.OpenEdge;
import org.sonar.plugins.openedge.foundation.OpenEdgeComponents;
import org.sonar.plugins.openedge.foundation.OpenEdgeDB;
import org.sonar.plugins.openedge.foundation.OpenEdgeDBProfile;
import org.sonar.plugins.openedge.foundation.OpenEdgeMetrics;
import org.sonar.plugins.openedge.foundation.OpenEdgeProfile;
import org.sonar.plugins.openedge.foundation.OpenEdgeRulesDefinition;
import org.sonar.plugins.openedge.foundation.OpenEdgeSettings;
import org.sonar.plugins.openedge.sensor.OpenEdgeCPDSensor;
import org.sonar.plugins.openedge.sensor.OpenEdgeCodeColorizer;
import org.sonar.plugins.openedge.sensor.OpenEdgeDBColorizer;
import org.sonar.plugins.openedge.sensor.OpenEdgeDBRulesSensor;
import org.sonar.plugins.openedge.sensor.OpenEdgeDBSensor;
import org.sonar.plugins.openedge.sensor.OpenEdgeProparseSensor;
import org.sonar.plugins.openedge.sensor.OpenEdgeSensor;
import org.sonar.plugins.openedge.sensor.OpenEdgeWarningsSensor;

public class OpenEdgePlugin
implements Plugin {
    private static final String CATEGORY_OPENEDGE = "OpenEdge";
    private static final String SUBCATEGORY_GENERAL = "General";
    private static final String SUBCATEGORY_DEBUG = "Debug";

    public void define(Plugin.Context context) {
        context.addExtensions(OpenEdge.class, OpenEdgeDB.class, new Object[]{OpenEdgeSettings.class});
        if (context.getRuntime().getProduct() == SonarProduct.SONARQUBE) {
            context.addExtension(OpenEdgeRulesDefinition.class);
        }
        context.addExtensions(BasicChecksRegistration.class, OpenEdgeProfile.class, new Object[]{OpenEdgeDBProfile.class, OpenEdgeMetrics.class, OpenEdgeComponents.class});
        if (context.getRuntime().getProduct() == SonarProduct.SONARQUBE) {
            context.addExtensions(OpenEdgeCodeColorizer.class, OpenEdgeDBColorizer.class, new Object[]{OpenEdgeCPDSensor.class});
        }
        context.addExtensions(OpenEdgeSensor.class, OpenEdgeDBSensor.class, new Object[]{OpenEdgeWarningsSensor.class, OpenEdgeProparseSensor.class, OpenEdgeDBRulesSensor.class});
        context.addExtensions(CommonMetricsDecorator.class, CommonDBMetricsDecorator.class, new Object[0]);
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.oe.rcode.skip").name("Skip rcode parsing").description("Don't parse rcode in the build directory and from dependencies").type(PropertyType.BOOLEAN).category(CATEGORY_OPENEDGE).subCategory(SUBCATEGORY_GENERAL).onQualifiers("TRK", new String[0]).defaultValue(Boolean.FALSE.toString()).build());
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.oe.skipProparse").name("Skip Proparse step").description("Don't generate syntax tree and skip lint rules").type(PropertyType.BOOLEAN).category(CATEGORY_OPENEDGE).subCategory(SUBCATEGORY_GENERAL).onQualifiers("TRK", new String[0]).defaultValue(Boolean.FALSE.toString()).build());
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.oe.simplecpd").name("Simple CPD engine").description("Use this simple CPD engine only when the parser can't compile your code (missing dependencies or encrypted source code)").type(PropertyType.BOOLEAN).category(CATEGORY_OPENEDGE).subCategory(SUBCATEGORY_GENERAL).onQualifiers("TRK", new String[0]).defaultValue(Boolean.FALSE.toString()).build());
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.oe.proparse.debug").name("Proparse debug files").description("Generate parser debug files in .proparse directory").type(PropertyType.BOOLEAN).category(CATEGORY_OPENEDGE).subCategory(SUBCATEGORY_DEBUG).defaultValue(Boolean.FALSE.toString()).onQualifiers("TRK", new String[0]).build());
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.oe.file.suffixes").name("File suffixes").description("Comma-separated list of suffixes of OpenEdge files").type(PropertyType.STRING).defaultValue("p,w,i,cls").category(CATEGORY_OPENEDGE).subCategory(SUBCATEGORY_GENERAL).onQualifiers("TRK", new String[0]).build());
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.oe.include.suffixes").name("File suffixes of ABL include files").description("Comma-separated list of suffixes of OpenEdge include files").type(PropertyType.STRING).defaultValue("i").category(CATEGORY_OPENEDGE).subCategory(SUBCATEGORY_GENERAL).onQualifiers("TRK", new String[0]).build());
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.oe.cpd.annotations").name("CPD annotations").description("Comma-separated list of annotations disabling CPD").type(PropertyType.STRING).defaultValue("Generated").category(CATEGORY_OPENEDGE).subCategory(SUBCATEGORY_GENERAL).onQualifiers("TRK", new String[0]).build());
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.oe.issues.annotations").name("Skip issue annotations").description("Comma-separated list of annotations where issues will be skipped").type(PropertyType.STRING).defaultValue("@InitializeComponent").category(CATEGORY_OPENEDGE).subCategory(SUBCATEGORY_GENERAL).onQualifiers("TRK", new String[0]).build());
        context.addExtension((Object)PropertyDefinition.builder((String)"sonar.oe.backslash.escape").name("Backslash as escape char").description("Force or prevent backslash from escaping next character").type(PropertyType.BOOLEAN).defaultValue(Boolean.FALSE.toString()).category(CATEGORY_OPENEDGE).subCategory(SUBCATEGORY_GENERAL).onQualifiers("TRK", new String[0]).build());
    }
}

