/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.checks;

import java.util.List;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.JPNode;
import org.prorefactor.treeparser.ParseUnit;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.openedge.api.checks.OpenEdgeProparseCheck;
import org.sonar.plugins.openedge.api.model.SqaleConstantRemediation;

@Rule(priority=Priority.BLOCKER, name="Valid yet clumsy ABL syntax", tags={"clumsy", "confusing"})
@SqaleConstantRemediation(value="2min")
public class ClumsySyntax
extends OpenEdgeProparseCheck {
    public void execute(InputFile file, ParseUnit unit) {
        block5: for (JPNode node : unit.getTopNode().queryStateHead()) {
            switch (node.getNodeType()) {
                case CATCH: 
                case CASE: 
                case DO: 
                case FOR: 
                case REPEAT: 
                case FINALLY: 
                case PROCEDURE: {
                    this.handleDoBlock(file, node);
                    continue block5;
                }
                case FUNCTION: {
                    this.handleFunctionBlock(file, node);
                    continue block5;
                }
                case METHOD: {
                    this.handleMethodBlock(unit, file, node);
                    continue block5;
                }
            }
            this.handleStatement(file, node);
        }
    }

    private void handleFunctionBlock(InputFile file, JPNode node) {
        List ch = node.getDirectChildren();
        boolean containsForward = ch.stream().map(JPNode::getNodeType).anyMatch(type -> type == ABLNodeType.FORWARDS);
        boolean containsIn = ch.stream().map(JPNode::getNodeType).anyMatch(type -> type == ABLNodeType.IN);
        boolean containsMap = ch.stream().map(JPNode::getNodeType).anyMatch(type -> type == ABLNodeType.MAP);
        if (containsForward || containsIn || containsMap) {
            JPNode lastCh = (JPNode)ch.get(ch.size() - 1);
            if (lastCh.getNodeType() != ABLNodeType.PERIOD) {
                this.reportIssue(file, node, "FUNCTION declaration should end with a period", true);
            }
        } else {
            JPNode lastCh = (JPNode)ch.get(ch.size() - 1);
            JPNode lastCh2 = (JPNode)ch.get(ch.size() - 2);
            if (lastCh.getNodeType() != ABLNodeType.PERIOD || lastCh2.getNodeType() != ABLNodeType.END) {
                this.reportIssue(file, node, "FUNCTION declaration should end with END [FUNCTION] followed by a period", true);
            }
        }
    }

    private void handleMethodBlock(ParseUnit unit, InputFile file, JPNode node) {
        List ch = node.getDirectChildren();
        boolean containsAbstract = ch.stream().map(JPNode::getNodeType).anyMatch(type -> type == ABLNodeType.ABSTRACT);
        JPNode lastCh = (JPNode)ch.get(ch.size() - 1);
        if (unit.isInterface() || containsAbstract) {
            NewIssue issue;
            if (lastCh.getNodeType() == ABLNodeType.LEXCOLON && (issue = this.createIssue(file, node, "METHOD prototype declaration...", true)) != null) {
                this.addLocation(issue, file, lastCh, "... should end with a period and not a colon", true);
                issue.save();
            }
        } else {
            for (int zz = 1; zz < ch.size() - 1; ++zz) {
                NewIssue issue;
                if (((JPNode)ch.get(zz)).getNodeType() != ABLNodeType.PARAMETER_LIST || ((JPNode)ch.get(zz + 1)).getNodeType() != ABLNodeType.PERIOD || (issue = this.createIssue(file, node, "METHOD block...", true)) == null) continue;
                this.addLocation(issue, file, (JPNode)ch.get(zz + 1), "... should end with a colon and not a period", true);
                issue.save();
            }
        }
    }

    private void handleDoBlock(InputFile file, JPNode node) {
        List ch = node.getDirectChildren();
        if (ch.size() <= 1) {
            return;
        }
        JPNode lastCh = (JPNode)ch.get(ch.size() - 1);
        JPNode lastCh2 = (JPNode)ch.get(ch.size() - 2);
        if (lastCh.getNodeType() != ABLNodeType.PERIOD || lastCh2.getNodeType() != ABLNodeType.END) {
            this.reportIssue(file, node, "Block should end with END [blockType] followed by a period", true);
        }
    }

    private void handleStatement(InputFile file, JPNode node) {
        if (node.getNodeType() == ABLNodeType.IF || node.getNodeType() == ABLNodeType.WHEN || node.getNodeType() == ABLNodeType.OTHERWISE || node.getNodeType() == ABLNodeType.ON || node.getNodeType() == ABLNodeType.EXPR_STATEMENT) {
            return;
        }
        if (node.getNodeType() == ABLNodeType.DEFINE && node.isIStatement() && node.asIStatement().getNodeType2() == ABLNodeType.PROPERTY) {
            return;
        }
        List ch = node.getDirectChildren();
        if (ch.size() < 1) {
            return;
        }
        JPNode lastCh = (JPNode)ch.get(ch.size() - 1);
        if (lastCh.getNodeType() != ABLNodeType.PERIOD) {
            this.reportIssue(file, node.firstNaturalChild(), "Statement should end with a period", true);
        }
    }
}

