/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.checks;

import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.JPNode;
import org.prorefactor.treeparser.ParseUnit;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.openedge.api.checks.OpenEdgeProparseCheck;
import org.sonar.plugins.openedge.api.model.SqaleConstantRemediation;

@Rule(priority=Priority.CRITICAL, name="Large transaction scope")
@SqaleConstantRemediation(value="3h")
public class LargeTransactionScope
extends OpenEdgeProparseCheck {
    public void execute(InputFile file, ParseUnit unit) {
        if (unit.getTransactionBlocks() == null) {
            return;
        }
        for (JPNode node : unit.getTopNode().queryStateHead(ABLNodeType.TRIGGER, new ABLNodeType[0])) {
            if (node.getFirstChild().getNodeType() != ABLNodeType.PROCEDURE) continue;
            return;
        }
        for (Integer line : unit.getTransactionBlocks()) {
            if (line != 0) continue;
            this.reportIssue(file, "Transaction scope of main block spans the entire procedure");
        }
    }
}

