/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.decorator;

import java.util.Arrays;
import org.sonar.api.ce.measure.Component;
import org.sonar.api.ce.measure.Measure;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.foundation.OpenEdgeMetrics;

public class CommonDBMetricsDecorator
implements MeasureComputer {
    private static final Logger LOG = Loggers.get(CommonDBMetricsDecorator.class);
    private final Metric[] intMetrics;

    public CommonDBMetricsDecorator(OpenEdgeMetrics metrics) {
        this.intMetrics = (Metric[])metrics.getMetrics().stream().filter(m -> m.isNumericType() && "OpenEdgeDB".equals(m.getDomain())).toArray(Metric[]::new);
    }

    public MeasureComputer.MeasureComputerDefinition define(MeasureComputer.MeasureComputerDefinitionContext defContext) {
        String[] keys = (String[])Arrays.stream(this.intMetrics).map(Metric::getKey).toArray(String[]::new);
        return defContext.newDefinitionBuilder().setInputMetrics(keys).setOutputMetrics(keys).build();
    }

    public void compute(MeasureComputer.MeasureComputerContext context) {
        LOG.debug("Decorating " + context.getComponent().getKey());
        if (context.getComponent().getType() == Component.Type.DIRECTORY || context.getComponent().getType() == Component.Type.PROJECT) {
            for (Metric m : this.intMetrics) {
                int rslt = 0;
                for (Measure measure : context.getChildrenMeasures(m.getKey())) {
                    rslt += measure.getIntValue();
                }
                context.addMeasure(m.getKey(), rslt);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

