/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.decorator;

import java.util.Arrays;
import org.sonar.api.ce.measure.Component;
import org.sonar.api.ce.measure.Measure;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.foundation.OpenEdgeMetrics;

public class CommonMetricsDecorator
implements MeasureComputer {
    private static final Logger LOG = Loggers.get(CommonMetricsDecorator.class);
    private final Metric[] intMetrics;

    public CommonMetricsDecorator(OpenEdgeMetrics metrics) {
        this.intMetrics = (Metric[])metrics.getMetrics().stream().filter(m -> m.isNumericType() && ("OpenEdge".equals(m.getDomain()) || CoreMetrics.DOMAIN_SIZE.equals(m.getDomain()))).toArray(Metric[]::new);
    }

    public MeasureComputer.MeasureComputerDefinition define(MeasureComputer.MeasureComputerDefinitionContext defContext) {
        String[] keys = (String[])Arrays.stream(this.intMetrics).map(Metric::getKey).toArray(String[]::new);
        return defContext.newDefinitionBuilder().setInputMetrics(keys).setOutputMetrics(keys).build();
    }

    public void compute(MeasureComputer.MeasureComputerContext context) {
        LOG.debug("Decorating " + context.getComponent().getKey());
        if (context.getComponent().getType() == Component.Type.DIRECTORY || context.getComponent().getType() == Component.Type.PROJECT) {
            int numClasses = 0;
            int numPackages = 0;
            for (Metric m : this.intMetrics) {
                int rslt = 0;
                for (Measure measure : context.getChildrenMeasures(m.getKey())) {
                    rslt += measure.getIntValue();
                }
                if (m == OpenEdgeMetrics.CLASSES) {
                    numClasses = rslt;
                    context.addMeasure(m.getKey(), rslt);
                    continue;
                }
                if (m == OpenEdgeMetrics.PACKAGES) {
                    numPackages = rslt;
                    continue;
                }
                context.addMeasure(m.getKey(), rslt);
            }
            if (context.getComponent().getType() == Component.Type.DIRECTORY) {
                if (numClasses > 0) {
                    context.addMeasure(OpenEdgeMetrics.PACKAGES.getKey(), 1);
                }
            } else if (context.getComponent().getType() == Component.Type.PROJECT) {
                context.addMeasure(OpenEdgeMetrics.PACKAGES.getKey(), numPackages);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

