/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.foundation;

import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.api.CheckRegistration;
import org.sonar.plugins.openedge.api.checks.OpenEdgeDumpFileCheck;
import org.sonar.plugins.openedge.api.checks.OpenEdgeProparseCheck;
import org.sonar.plugins.openedge.checks.ClumsySyntax;
import org.sonar.plugins.openedge.checks.LargeTransactionScope;
import org.sonar.plugins.openedge.checks.NoOpDatabaseRule;

public class BasicChecksRegistration
implements CheckRegistration {
    private static final Logger LOGGER = Loggers.get(BasicChecksRegistration.class);

    public void register(CheckRegistration.Registrar registrar) {
        LOGGER.debug("Registering CheckRegistrar {}", (Object)BasicChecksRegistration.class.toString());
        for (Class<? extends OpenEdgeProparseCheck> clazz : BasicChecksRegistration.ppCheckClasses()) {
            registrar.registerParserCheck(clazz);
        }
        for (Class<? extends OpenEdgeProparseCheck> clazz : BasicChecksRegistration.dbCheckClasses()) {
            registrar.registerDumpFileCheck(clazz);
        }
    }

    public static Class<? extends OpenEdgeProparseCheck>[] ppCheckClasses() {
        return new Class[]{LargeTransactionScope.class, ClumsySyntax.class};
    }

    public static Class<? extends OpenEdgeDumpFileCheck>[] dbCheckClasses() {
        return new Class[]{NoOpDatabaseRule.class};
    }
}

