/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.foundation;

import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.ICallback;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.ProToken;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.foundation.OpenEdgeSettings;

public class CPDCallback
implements ICallback<NewCpdTokens> {
    private static final Logger LOG = Loggers.get(CPDCallback.class);
    private final NewCpdTokens cpdTokens;
    private final OpenEdgeSettings settings;
    private final InputFile file;

    public CPDCallback(SensorContext context, InputFile file, OpenEdgeSettings settings) {
        this.cpdTokens = context.newCpdTokens().onFile(file);
        this.file = file;
        this.settings = settings;
    }

    public NewCpdTokens getResult() {
        return this.cpdTokens;
    }

    public boolean visitNode(JPNode node) {
        JPNode procName;
        JPNode methodName;
        if (!node.isNatural()) {
            return true;
        }
        if (node.getNodeType() == ABLNodeType.ANNOTATION && this.settings.skipCPD(node.getAnnotationName())) {
            return false;
        }
        if (this.preprocessorLookup(node)) {
            return false;
        }
        for (JPNode prevSibling = node.getPreviousSibling(); prevSibling != null && prevSibling.getNodeType() == ABLNodeType.ANNOTATION; prevSibling = prevSibling.getPreviousSibling()) {
            if (!this.settings.skipCPD(prevSibling.getAnnotationName())) continue;
            this.insertFakeNode(node);
            return false;
        }
        if (node.getNodeType() == ABLNodeType.METHOD && (methodName = node.findDirectChild(ABLNodeType.ID)) != null && this.settings.skipMethod(methodName.getText())) {
            this.insertFakeNode(node);
            return false;
        }
        if ((node.getNodeType() == ABLNodeType.PROCEDURE || node.getNodeType() == ABLNodeType.FUNCTION) && (procName = node.findDirectChild(ABLNodeType.ID)) != null && this.settings.skipProcedure(procName.getText())) {
            this.insertFakeNode(node);
            return false;
        }
        this.visitCpdNode(node);
        return true;
    }

    private boolean preprocessorLookup(JPNode node) {
        for (ProToken n : node.getHiddenTokens()) {
            if (n.getNodeType() != ABLNodeType.AMPANALYZESUSPEND || !n.getText().startsWith("&ANALYZE-SUSPEND _CREATE-WINDOW") && !n.getText().startsWith("&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE adm-create-objects")) continue;
            return true;
        }
        return false;
    }

    private void visitCpdNode(JPNode node) {
        String str;
        if (node.isMacroExpansion() || node.getFileIndex() > 0 || node.getLine() <= 0 || node.getFileIndex() != node.getEndFileIndex()) {
            return;
        }
        String string = str = node.getNodeType() == ABLNodeType.NUMBER ? node.getText() : node.getNodeType().getText();
        if (str == null || str.trim().length() == 0) {
            str = node.getNodeType() == ABLNodeType.ID ? node.getText().toLowerCase(Locale.ENGLISH) : node.getText().trim();
        }
        try {
            TextRange range = this.file.newRange(node.getLine(), node.getColumn() - 1, node.getEndLine(), node.getEndColumn());
            this.cpdTokens.addToken(range, str);
        }
        catch (IllegalArgumentException | IllegalStateException uncaught) {
            LOG.debug("Unable to create CPD token at position {}:{} to {}:{} - Cause {}", new Object[]{node.getLine(), node.getColumn(), node.getEndLine(), node.getEndColumn(), uncaught.getMessage()});
        }
    }

    private void insertFakeNode(JPNode node) {
        List children = node.getDirectChildren();
        JPNode lastSibling = children.isEmpty() ? node : (JPNode)children.get(children.size() - 1);
        try {
            TextRange range = this.file.newRange(node.getLine(), node.getColumn() - 1, lastSibling.getEndLine(), lastSibling.getEndColumn() - 1);
            this.cpdTokens.addToken(range, UUID.randomUUID().toString());
        }
        catch (IllegalArgumentException | IllegalStateException uncaught) {
            LOG.debug("Unable to create CPD token at position {}:{} to {}:{} - Cause {}", new Object[]{node.getLine(), node.getColumn(), lastSibling.getEndLine(), lastSibling.getEndColumn(), uncaught.getMessage()});
        }
    }
}

