/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.foundation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.PathUtils;

public class InputFileUtils {
    private InputFileUtils() {
    }

    public static InputStream getInputStream(InputFile file) {
        try {
            return file.inputStream();
        }
        catch (IOException caught) {
            throw new UncheckedIOException(caught);
        }
    }

    public static File getFile(InputFile file) {
        return Paths.get(file.uri()).toFile();
    }

    public static String getAbsolutePath(InputFile file) {
        return PathUtils.sanitize((String)Paths.get(file.uri()).toString());
    }

    public static String getRelativePath(InputFile file, FileSystem fs) {
        try {
            return fs.baseDir().toPath().toAbsolutePath().relativize(Paths.get(file.uri())).toString().replace('\\', '/');
        }
        catch (IllegalArgumentException caught) {
            return file.filename();
        }
    }
}

