/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.foundation;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.prorefactor.proparse.antlr4.ProparseListener;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.platform.Server;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.openedge.api.CheckRegistration;
import org.sonar.plugins.openedge.api.InvalidLicenseException;
import org.sonar.plugins.openedge.api.LicenseRegistration;
import org.sonar.plugins.openedge.api.TreeParserRegistration;
import org.sonar.plugins.openedge.api.checks.OpenEdgeCheck;
import org.sonar.plugins.openedge.api.checks.OpenEdgeDumpFileCheck;
import org.sonar.plugins.openedge.api.checks.OpenEdgeProparseCheck;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide
@ServerSide
public class OpenEdgeComponents {
    private static final Logger LOG = Loggers.get(OpenEdgeComponents.class);
    private final Map<ActiveRule, OpenEdgeProparseCheck> ppChecksMap = new HashMap<ActiveRule, OpenEdgeProparseCheck>();
    private final Map<ActiveRule, OpenEdgeDumpFileCheck> dfChecksMap = new HashMap<ActiveRule, OpenEdgeDumpFileCheck>();
    private final Server server;
    private final CheckRegistrar checkRegistrar = new CheckRegistrar();
    private final LicenseRegistrar licenseRegistrar = new LicenseRegistrar();
    private final TreeParserRegistrar parserRegistrar = new TreeParserRegistrar();
    private boolean initialized = false;
    private String analytics = "";
    private int ncLoc = 0;

    public OpenEdgeComponents() {
        this(null, null, null, null);
    }

    public OpenEdgeComponents(Server server) {
        this(server, null, null, null);
    }

    public OpenEdgeComponents(CheckRegistration[] checkRegistrars) {
        this(null, checkRegistrars, null, null);
    }

    public OpenEdgeComponents(Server server, CheckRegistration[] checkRegistrars) {
        this(server, checkRegistrars, null, null);
    }

    public OpenEdgeComponents(CheckRegistration[] checkRegistrars, LicenseRegistration[] licRegistrars) {
        this(null, checkRegistrars, licRegistrars, null);
    }

    public OpenEdgeComponents(Server server, CheckRegistration[] checkRegistrars, LicenseRegistration[] licRegistrars) {
        this(server, checkRegistrars, licRegistrars, null);
    }

    public OpenEdgeComponents(CheckRegistration[] checkRegistrars, LicenseRegistration[] licRegistrars, TreeParserRegistration[] tpRegistrars) {
        this(null, checkRegistrars, licRegistrars, tpRegistrars);
    }

    public OpenEdgeComponents(Server server, CheckRegistration[] checkRegistrars, LicenseRegistration[] licRegistrars, TreeParserRegistration[] tpRegistrars) {
        this.server = server;
        if (checkRegistrars != null) {
            for (CheckRegistration checkRegistration : checkRegistrars) {
                checkRegistration.register((CheckRegistration.Registrar)this.checkRegistrar);
            }
        }
        if (licRegistrars != null) {
            for (CheckRegistration checkRegistration : licRegistrars) {
                checkRegistration.register((LicenseRegistration.Registrar)this.licenseRegistrar);
            }
        }
        if (tpRegistrars != null) {
            for (CheckRegistration checkRegistration : tpRegistrars) {
                checkRegistration.register((TreeParserRegistration.Registrar)this.parserRegistrar);
            }
        }
    }

    public Iterable<Class<? extends ProparseListener>> getProparseListeners() {
        return Collections.unmodifiableList(this.parserRegistrar.allListeners);
    }

    public Collection<LicenseRegistration.License> getLicenses() {
        return this.licenseRegistrar.getLicenses();
    }

    public LicenseRegistration.License getLicense(SonarProduct product, String permId, String repoName) {
        return this.licenseRegistrar.getLicense(product, permId, repoName);
    }

    public void init(SensorContext context) {
        if (this.initialized) {
            return;
        }
        this.initializeChecks(context);
        this.initialized = true;
    }

    private void initializeChecks(SensorContext context) {
        OpenEdgeCheck<?> lint;
        String permId = this.getServerId();
        for (ActiveRule rule : context.activeRules().findByLanguage("oe")) {
            lint = this.initializeCheck(context, rule, context.runtime().getProduct(), permId);
            if (lint == null || lint.getCheckType() != OpenEdgeCheck.CheckType.PROPARSE) continue;
            this.ppChecksMap.put(rule, (OpenEdgeProparseCheck)lint);
        }
        for (ActiveRule rule : context.activeRules().findByLanguage("oedb")) {
            lint = this.initializeCheck(context, rule, context.runtime().getProduct(), permId);
            if (lint == null || lint.getCheckType() != OpenEdgeCheck.CheckType.DUMP_FILE) continue;
            this.dfChecksMap.put(rule, (OpenEdgeDumpFileCheck)lint);
        }
    }

    public void setAnalytics(String analytics) {
        this.analytics = analytics;
    }

    public String getAnalytics() {
        return this.analytics;
    }

    public void setNcLoc(int ncLoc) {
        this.ncLoc = ncLoc;
    }

    public int getNcLoc() {
        return this.ncLoc;
    }

    public Map<ActiveRule, OpenEdgeProparseCheck> getProparseRules() {
        return Collections.unmodifiableMap(this.ppChecksMap);
    }

    public Map<ActiveRule, OpenEdgeDumpFileCheck> getDumpFileRules() {
        return Collections.unmodifiableMap(this.dfChecksMap);
    }

    private OpenEdgeCheck<?> initializeCheck(SensorContext context, ActiveRule rule, SonarProduct product, String permId) {
        RuleKey ruleKey = rule.ruleKey();
        String clsName = rule.templateRuleKey() == null ? ruleKey.rule() : rule.templateRuleKey();
        try {
            Class<OpenEdgeCheck<?>> clz = this.checkRegistrar.getCheck(clsName);
            if (clz == null) {
                return null;
            }
            OpenEdgeCheck<?> check = clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            check.setContext(ruleKey, context, this.getLicense(product, permId, ruleKey.repository()));
            OpenEdgeComponents.configureFields(rule, check);
            check.initialize();
            return check;
        }
        catch (ReflectiveOperationException caught) {
            LOG.error("Unable to instantiate rule " + clsName, (Throwable)caught);
            throw new RuntimeException("Stopping analyzer due to previous exception");
        }
        catch (InvalidLicenseException caught) {
            LOG.error("Unable to instantiate rule {} - {}", (Object)clsName, (Object)caught.getMessage());
            throw new RuntimeException("Stopping analyzer due to previous exception");
        }
    }

    private static void configureFields(ActiveRule activeRule, Object check) {
        for (String param : activeRule.params().keySet()) {
            Field field = OpenEdgeComponents.getField(check, param);
            if (field == null) {
                throw MessageException.of((String)("The field " + param + " does not exist or is not annotated with @RuleProperty in the class " + check.getClass().getName()));
            }
            if (Strings.nullToEmpty((String)activeRule.param(param)).trim().length() <= 0) continue;
            OpenEdgeComponents.configureField(check, field, activeRule.param(param));
        }
    }

    private static void configureField(Object check, Field field, String value) {
        block13: {
            try {
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(check, value);
                    break block13;
                }
                if (Integer.TYPE == field.getType()) {
                    field.setInt(check, Integer.parseInt(value));
                    break block13;
                }
                if (Short.TYPE == field.getType()) {
                    field.setShort(check, Short.parseShort(value));
                    break block13;
                }
                if (Long.TYPE == field.getType()) {
                    field.setLong(check, Long.parseLong(value));
                    break block13;
                }
                if (Double.TYPE == field.getType()) {
                    field.setDouble(check, Double.parseDouble(value));
                    break block13;
                }
                if (Boolean.TYPE == field.getType()) {
                    field.setBoolean(check, Boolean.parseBoolean(value));
                    break block13;
                }
                if (Byte.TYPE == field.getType()) {
                    field.setByte(check, Byte.parseByte(value));
                    break block13;
                }
                if (Integer.class == field.getType()) {
                    field.set(check, Integer.parseInt(value));
                    break block13;
                }
                if (Long.class == field.getType()) {
                    field.set(check, Long.parseLong(value));
                    break block13;
                }
                if (Double.class == field.getType()) {
                    field.set(check, Double.parseDouble(value));
                    break block13;
                }
                if (Boolean.class == field.getType()) {
                    field.set(check, Boolean.parseBoolean(value));
                    break block13;
                }
                throw MessageException.of((String)("The type of the field " + field + " is not supported: " + field.getType()));
            }
            catch (IllegalAccessException e) {
                throw MessageException.of((String)("Can not set the value of the field " + field + " in the class: " + check.getClass().getName()), (Throwable)e);
            }
        }
    }

    private static Field getField(Object check, String key) {
        Field[] fields;
        for (Field field : fields = check.getClass().getDeclaredFields()) {
            RuleProperty propertyAnnotation = field.getAnnotation(RuleProperty.class);
            if (propertyAnnotation == null || !key.equals(field.getName()) && !key.equals(propertyAnnotation.key())) continue;
            return field;
        }
        return null;
    }

    public String getServerId() {
        return this.server == null ? "" : this.server.getId();
    }

    private static class TreeParserRegistrar
    implements TreeParserRegistration.Registrar {
        private final List<Class<? extends ProparseListener>> allListeners = new ArrayList<Class<? extends ProparseListener>>();

        private TreeParserRegistrar() {
        }

        public void registerTreeParser(Class<? extends ProparseListener> listener) {
            this.allListeners.add(listener);
        }
    }

    private static class CheckRegistrar
    implements CheckRegistration.Registrar {
        private final Collection<Class<? extends OpenEdgeCheck<?>>> allChecks = new ArrayList();

        private CheckRegistrar() {
        }

        public void registerParserCheck(Class<? extends OpenEdgeProparseCheck> check) {
            this.allChecks.add(check);
        }

        public void registerDumpFileCheck(Class<? extends OpenEdgeDumpFileCheck> check) {
            this.allChecks.add(check);
        }

        public Class<? extends OpenEdgeCheck<?>> getCheck(String className) {
            for (Class<OpenEdgeCheck<?>> clz : this.allChecks) {
                if (!clz.getCanonicalName().equalsIgnoreCase(className)) continue;
                return clz;
            }
            return null;
        }
    }

    private static class LicenseRegistrar
    implements LicenseRegistration.Registrar {
        private final Collection<LicenseRegistration.License> licenses = new ArrayList<LicenseRegistration.License>();

        private LicenseRegistrar() {
        }

        public void registerLicense(int version, String permanentId, SonarProduct product, String customerName, String salt, String repoName, LicenseRegistration.LicenseType type, byte[] signature, long expirationDate, long lines) {
            if (Strings.isNullOrEmpty((String)repoName)) {
                return;
            }
            LOG.debug("Found {} license - Permanent ID '{}' - Customer '{}' - Repository '{}' - Expiration date {}", new Object[]{type.toString(), permanentId, customerName, repoName, DateFormat.getDateTimeInstance(3, 3).format(new Date(expirationDate))});
            LicenseRegistration.License existingLic = this.hasRegisteredLicense(product, repoName, permanentId);
            LicenseRegistration.License newLic = new LicenseRegistration.License.Builder().setVersion(version).setPermanentId(permanentId).setProduct(product).setCustomerName(customerName).setSalt(salt).setRepositoryName(repoName).setType(type).setSignature(signature).setExpirationDate(expirationDate).setLines(lines).build();
            if (existingLic == null) {
                this.licenses.add(newLic);
            } else if (existingLic.getExpirationDate() < newLic.getExpirationDate()) {
                this.licenses.remove(existingLic);
                this.licenses.add(newLic);
            }
        }

        private Collection<LicenseRegistration.License> getLicenses() {
            return this.licenses;
        }

        private LicenseRegistration.License hasRegisteredLicense(SonarProduct product, String repoName, String permId) {
            if (permId == null || repoName == null) {
                return null;
            }
            for (LicenseRegistration.License lic : this.licenses) {
                if (lic.getType() != LicenseRegistration.LicenseType.COMMERCIAL && lic.getType() != LicenseRegistration.LicenseType.PARTNER || lic.getProduct() != product || !repoName.equals(lic.getRepositoryName()) || !permId.equals(lic.getPermanentId())) continue;
                return lic;
            }
            return null;
        }

        private LicenseRegistration.License getLicense(SonarProduct product, String permId, String repoName) {
            if (permId == null || repoName == null) {
                return null;
            }
            String miniPermId = permId.indexOf(45) == 8 && permId.length() >= 20 ? permId.substring(permId.indexOf(45) + 1) : permId;
            Optional<LicenseRegistration.License> srch = this.licenses.stream().filter(lic -> lic.getType() == LicenseRegistration.LicenseType.COMMERCIAL || lic.getType() == LicenseRegistration.LicenseType.PARTNER).filter(lic -> lic.getProduct() == product).filter(lic -> repoName.equals(lic.getRepositoryName())).filter(lic -> lic.getVersion() >= 3 && permId.equals(lic.getPermanentId()) || miniPermId.equals(lic.getPermanentId())).findFirst();
            if (srch.isPresent()) {
                return srch.get();
            }
            srch = this.licenses.stream().filter(lic -> lic.getType() == LicenseRegistration.LicenseType.EVALUATION).filter(lic -> lic.getProduct() == product).filter(lic -> repoName.equals(lic.getRepositoryName())).filter(lic -> lic.getVersion() >= 3 && permId.equals(lic.getPermanentId()) || miniPermId.equals(lic.getPermanentId())).findFirst();
            if (srch.isPresent()) {
                return srch.get();
            }
            return null;
        }
    }
}

