/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.foundation;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.sonar.api.SonarRuntime;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.check.Priority;
import org.sonar.plugins.openedge.api.AnnotationBasedRulesDefinition;
import org.sonar.plugins.openedge.foundation.BasicChecksRegistration;

public class OpenEdgeRulesDefinition
implements RulesDefinition {
    public static final String REPOSITORY_NAME = "Standard rules";
    private static final int[] WARNING_MSGS = new int[]{214, 1688, 2750, 2965, 4788, 4958, 4983, 5378, 12115, 14786, 14789, 15090, 18494, 19822};
    public static final String COMPILER_WARNING_RULEKEY = "compiler.warning";
    public static final String COMPILER_WARNING_214_RULEKEY = "compiler.warning.214";
    public static final String COMPILER_WARNING_1688_RULEKEY = "compiler.warning.1688";
    public static final String COMPILER_WARNING_2750_RULEKEY = "compiler.warning.2750";
    public static final String COMPILER_WARNING_2965_RULEKEY = "compiler.warning.2965";
    public static final String COMPILER_WARNING_4788_RULEKEY = "compiler.warning.4788";
    public static final String COMPILER_WARNING_4958_RULEKEY = "compiler.warning.4958";
    public static final String COMPILER_WARNING_5378_RULEKEY = "compiler.warning.5378";
    public static final String COMPILER_WARNING_12115_RULEKEY = "compiler.warning.12115";
    public static final String COMPILER_WARNING_14786_RULEKEY = "compiler.warning.14786";
    public static final String COMPILER_WARNING_14789_RULEKEY = "compiler.warning.14789";
    public static final String COMPILER_WARNING_15090_RULEKEY = "compiler.warning.15090";
    public static final String COMPILER_WARNING_18494_RULEKEY = "compiler.warning.18494";
    public static final String COMPILER_WARNING_19822_RULEKEY = "compiler.warning.19822";
    public static final String PROPARSE_ERROR_RULEKEY = "proparse.error";
    private static final String COMPILER_WARNING_TAG = "compiler-warnings";
    private static final String HTML_DOC_PATH = "/org/sonar/l10n/%s/rules/%s/%s.html";
    private final SonarRuntime runtime;

    public OpenEdgeRulesDefinition(SonarRuntime runtime) {
        this.runtime = runtime;
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository("rssw-oe", "oe").setName(REPOSITORY_NAME);
        AnnotationBasedRulesDefinition annotationLoader = new AnnotationBasedRulesDefinition(repository, "oe", this.runtime);
        annotationLoader.addRuleClasses(false, Arrays.asList(BasicChecksRegistration.ppCheckClasses()));
        this.createWarningRule(repository, COMPILER_WARNING_RULEKEY, "Compiler warnings", "15min", Priority.MINOR);
        this.createWarningRule(repository, COMPILER_WARNING_214_RULEKEY, "TRANSACTION keyword given within actual transaction level", "30min", Priority.CRITICAL);
        this.createWarningRule(repository, COMPILER_WARNING_1688_RULEKEY, "Subscript on array field in CONTAINS phrase ignored", "5min");
        this.createWarningRule(repository, COMPILER_WARNING_2750_RULEKEY, "RETURN statement in UDF or method is missing a return value expression", "5min");
        this.createWarningRule(repository, COMPILER_WARNING_2965_RULEKEY, "Invalid use of nonconstant elements in preprocessor expression", "10min", Priority.BLOCKER);
        this.createWarningRule(repository, COMPILER_WARNING_4788_RULEKEY, "Translation exceeds allocated length", "30min", Priority.CRITICAL, new String[]{COMPILER_WARNING_TAG, "tranman"});
        this.createWarningRule(repository, COMPILER_WARNING_4958_RULEKEY, "IMPORT UNFORMATTED statement references more than one field", "5min");
        this.createWarningRule(repository, COMPILER_WARNING_5378_RULEKEY, "The EXCEPT or USING phrase of the BUFFER-COPY statement only honors fields in the source buffer", "5min");
        this.createWarningRule(repository, COMPILER_WARNING_12115_RULEKEY, "Expression evaluates to a constant", "5min");
        this.createWarningRule(repository, COMPILER_WARNING_14786_RULEKEY, "Table and field names must appear as they are in the schema", "2min", Priority.MAJOR);
        this.createWarningRule(repository, COMPILER_WARNING_14789_RULEKEY, "Fields must be qualified with table name", "2min", Priority.MAJOR);
        this.createWarningRule(repository, COMPILER_WARNING_15090_RULEKEY, "Dead code", "30min", Priority.CRITICAL);
        this.createWarningRule(repository, COMPILER_WARNING_18494_RULEKEY, "Abbreviated keywords are not authorized", "1min", Priority.INFO);
        this.createWarningRule(repository, COMPILER_WARNING_19822_RULEKEY, "All code paths in a function or a method must return a value", "15min", Priority.CRITICAL);
        RulesDefinition.NewRule proparseRule = repository.createRule(PROPARSE_ERROR_RULEKEY).setName("Proparse error").setSeverity(Priority.INFO.name());
        proparseRule.setType(RuleType.BUG);
        proparseRule.setHtmlDescription(this.getClass().getResource(String.format(HTML_DOC_PATH, "oe", "rssw-oe", proparseRule.key())));
        repository.done();
        RulesDefinition.NewRepository repository2 = context.createRepository("rssw-oedb", "oedb").setName(REPOSITORY_NAME);
        AnnotationBasedRulesDefinition annotationLoader2 = new AnnotationBasedRulesDefinition(repository2, "oedb", this.runtime);
        annotationLoader2.addRuleClasses(false, Arrays.asList(BasicChecksRegistration.dbCheckClasses()));
        repository2.done();
    }

    public static boolean isWarningManagedByCABL(int warningNum) {
        return IntStream.of(WARNING_MSGS).anyMatch(x -> x == warningNum);
    }

    private void createWarningRule(RulesDefinition.NewRepository repository, String ruleKey, String name, String remediationCost) {
        this.createWarningRule(repository, ruleKey, name, remediationCost, Priority.MINOR);
    }

    private void createWarningRule(RulesDefinition.NewRepository repository, String ruleKey, String name, String remediationCost, Priority priority) {
        this.createWarningRule(repository, ruleKey, name, remediationCost, priority, new String[]{COMPILER_WARNING_TAG});
    }

    private void createWarningRule(RulesDefinition.NewRepository repository, String ruleKey, String name, String remediationCost, Priority priority, String[] tags) {
        RulesDefinition.NewRule warning = repository.createRule(ruleKey).setName(name).setSeverity(priority.name());
        warning.setTags(tags);
        warning.setDebtRemediationFunction(warning.debtRemediationFunctions().constantPerIssue(remediationCost));
        warning.setType(RuleType.CODE_SMELL);
        warning.setHtmlDescription(this.getClass().getResource(String.format(HTML_DOC_PATH, "oe", "rssw-oe", warning.key())));
    }
}

