/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.foundation;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import eu.rssw.antlr.database.DumpFileUtils;
import eu.rssw.antlr.database.objects.DatabaseDescription;
import eu.rssw.pct.FileEntry;
import eu.rssw.pct.PLReader;
import eu.rssw.pct.RCodeInfo;
import eu.rssw.pct.elements.ITypeInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.prorefactor.core.schema.IDatabase;
import org.prorefactor.core.schema.ISchema;
import org.prorefactor.core.schema.Schema;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.refactor.settings.IProparseSettings;
import org.prorefactor.refactor.settings.ProparseSettings;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.platform.Server;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.api.objects.DatabaseWrapper;
import org.sonar.plugins.openedge.foundation.IRefactorSessionEnv;
import org.sonar.plugins.openedge.foundation.RefactorSessionEnv;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide
public class OpenEdgeSettings {
    private static final Logger LOG = Loggers.get(OpenEdgeSettings.class);
    private final Configuration config;
    private final FileSystem fileSystem;
    private final SonarRuntime runtime;
    private final Server server;
    private boolean init = false;
    private final List<Path> sourcePaths = new ArrayList<Path>();
    private final List<Path> binariesDirs = new ArrayList<Path>();
    private final List<Path> pctDirs = new ArrayList<Path>();
    private final List<File> propath = new ArrayList<File>();
    private final List<File> propathDlc = new ArrayList<File>();
    private final List<File> propathFull = new ArrayList<File>();
    private final Set<String> includeExtensions = new HashSet<String>();
    private final Set<String> cpdAnnotations = new HashSet<String>();
    private final Set<String> cpdMethods = new HashSet<String>();
    private final Set<String> cpdProcedures = new HashSet<String>();
    private RefactorSessionEnv sessionsEnv;
    private RefactorSession defaultSession;
    private String oePluginVersion;

    public OpenEdgeSettings(Configuration config, FileSystem fileSystem, SonarRuntime runtime) {
        this(config, fileSystem, runtime, null);
    }

    public OpenEdgeSettings(Configuration config, FileSystem fileSystem, SonarRuntime runtime, Server server) {
        this.config = config;
        this.fileSystem = fileSystem;
        this.runtime = runtime;
        this.server = server;
    }

    public final void init() {
        if (this.init) {
            return;
        }
        this.oePluginVersion = this.readPluginVersion(this.getClass().getClassLoader(), "sonar-openedge.txt");
        LOG.info("OpenEdge plugin version: {}", (Object)this.oePluginVersion);
        LOG.info("Loading OpenEdge settings for server ID '{}'", (Object)(this.server == null ? "" : this.server.getId()));
        this.initializeDirectories(this.config, this.fileSystem);
        this.initializePropathDlc(this.config);
        this.initializeDefaultPropath(this.config, this.fileSystem);
        this.initializeCPD(this.config);
        this.initializeIncludeExtensions(this.config);
        LOG.debug("Using backslash as escape character : {}", (Object)this.config.getBoolean("sonar.oe.backslash.escape").orElse(false));
        LOG.info("XML XREF filter activated");
        this.init = true;
    }

    private final void initializeDirectories(Configuration config, FileSystem fileSystem) {
        Optional sonarSources = config.get("sonar.sources");
        if (sonarSources.isPresent()) {
            this.initializeDirectory(fileSystem, (String)sonarSources.get(), "source", this.sourcePaths);
        } else {
            this.sourcePaths.add(fileSystem.baseDir().toPath().normalize());
            LOG.debug("No sonar.sources property, defaults to base directory");
        }
        Optional binariesSetting = config.get("sonar.oe.binaries");
        if (binariesSetting.isPresent()) {
            this.initializeDirectory(fileSystem, (String)binariesSetting.get(), "binaries", this.binariesDirs);
        } else {
            LOG.debug("No sonar.oe.binaries property, defaults to source directories");
            this.binariesDirs.addAll(this.sourcePaths);
        }
        Optional dotPctSetting = config.get("sonar.oe.dotpct");
        if (dotPctSetting.isPresent()) {
            this.initializeDirectory(fileSystem, (String)dotPctSetting.get(), ".pct", this.pctDirs);
        } else {
            LOG.debug("No sonar.oe.dotpct property, defaults to <binaries>/.pct directories");
            this.binariesDirs.forEach(dir -> this.pctDirs.add(Paths.get(dir.toString(), ".pct")));
        }
    }

    private final void initializeDirectory(FileSystem fileSystem, String prop, String type, List<Path> paths) {
        for (String str : Splitter.on((char)',').trimResults().split((CharSequence)prop)) {
            LOG.debug("Adding {} directory '{}' ...", (Object)type, (Object)str);
            try {
                Path p = fileSystem.baseDir().toPath().resolve(str).normalize();
                LOG.debug("  ... resolved to '{}'", (Object)p);
                paths.add(p);
            }
            catch (InvalidPathException caught) {
                LOG.error("Unable to resolve {} directory '{}'", (Object)type, (Object)str);
            }
        }
    }

    private final void initializePropathDlc(Configuration config) {
        String dlcInstallDir = config.get("sonar.oe.dlc").orElse(null);
        boolean dlcInPropath = config.getBoolean("sonar.oe.propath.dlc").orElse(false);
        if (dlcInPropath && !Strings.isNullOrEmpty((String)dlcInstallDir)) {
            File dlc = new File(dlcInstallDir);
            LOG.info("DLC directory '{}' will be added to PROPATH", (Object)dlc.getAbsolutePath());
            this.propathDlc.add(new File(dlc, "gui"));
            this.propathDlc.add(new File(dlc, "tty"));
            this.propathDlc.add(new File(dlc, "src"));
            this.propathDlc.add(dlc);
        }
    }

    private final void initializeDefaultPropath(Configuration config, FileSystem fileSystem) {
        this.propath.addAll(this.readPropath(fileSystem, config.get("sonar.oe.propath").orElse("")));
        this.propathFull.addAll(this.propath);
        this.propathFull.addAll(this.propathDlc);
    }

    private final List<File> readPropath(FileSystem fileSystem, String propValue) {
        ArrayList<File> retVal = new ArrayList<File>();
        LOG.info("Using PROPATH : {}", (Object)propValue);
        for (String str : Splitter.on((char)',').trimResults().split((CharSequence)propValue)) {
            File entry = this.resolvePath(str);
            LOG.debug("Adding {} to PROPATH", (Object)entry.getAbsolutePath());
            retVal.add(entry);
        }
        return retVal;
    }

    private final void initializeCPD(Configuration config) {
        for (String str : config.get("sonar.oe.cpd.annotations").orElse("").split(",")) {
            LOG.debug("CPD annotation : '{}'", (Object)str);
            this.cpdAnnotations.add(str);
        }
        for (String str : config.get("sonar.oe.cpd.skip_methods").orElse("").split(",")) {
            LOG.debug("CPD skip method : '{}'", (Object)str);
            this.cpdMethods.add(str.toLowerCase(Locale.ENGLISH));
        }
        for (String str : config.get("sonar.oe.cpd.skip_procedures").orElse("").split(",")) {
            LOG.debug("CPD skip procedure : '{}'", (Object)str);
            this.cpdProcedures.add(str.toLowerCase(Locale.ENGLISH));
        }
    }

    private final void initializeIncludeExtensions(Configuration config) {
        this.includeExtensions.addAll(Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)config.get("sonar.oe.include.suffixes").orElse("i")).stream().map(String::toLowerCase).collect(Collectors.toList()));
    }

    public final void parseHierarchy(InputFile file) {
        ITypeInfo info;
        String relPath = this.getRelativePathToSourceDirs(file);
        LOG.debug("Parsing hierarchy of '{}' - Relative '{}'", (Object)file, (Object)relPath);
        if (relPath == null) {
            return;
        }
        File rcd = this.getRCode(relPath);
        LOG.debug("  RCode found: '{}'", (Object)rcd);
        if (rcd != null && rcd.exists() && (info = this.parseRCode(rcd)) != null) {
            this.parseHierarchy(info);
        }
    }

    private final void parseHierarchy(ITypeInfo info) {
        ITypeInfo inf;
        LOG.info("Injecting type info '{}'", (Object)info);
        this.defaultSession.injectTypeInfo(info);
        if (info.getParentTypeName() != null && (inf = this.getRCode2(info.getParentTypeName())) != null) {
            this.parseHierarchy(inf);
        }
        for (String iface : info.getInterfaces()) {
            ITypeInfo inf2 = this.getRCode2(iface);
            if (inf2 == null) continue;
            this.parseHierarchy(inf2);
        }
    }

    private final void parseBuildDirectory() {
        if (this.config.getBoolean("sonar.oe.rcode.skip").orElse(false).booleanValue()) {
            return;
        }
        long currTime = System.currentTimeMillis();
        RCodeInjectorService srv = new RCodeInjectorService();
        for (Path binDir : this.binariesDirs) {
            this.parseRCodeInPath(binDir.toFile(), srv);
        }
        String dlcInstallDir = this.config.get("sonar.oe.dlc").orElse(null);
        boolean dlcInPropath = this.config.getBoolean("sonar.oe.propath.dlc").orElse(false);
        if (dlcInPropath && !Strings.isNullOrEmpty((String)dlcInstallDir)) {
            File dlc = new File(dlcInstallDir);
            this.parseRCodeInPath(new File(dlc, "gui"), srv);
        }
        for (File entry : this.propath) {
            if (entry.getName().endsWith(".pl")) {
                srv.service.submit(() -> this.parseLibrary(entry));
                continue;
            }
            this.parseRCodeInPath(entry, srv);
        }
        try {
            srv.service.shutdown();
            srv.service.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException caught) {
            LOG.error("Unable to finish parsing rcode...", (Throwable)caught);
            Thread.currentThread().interrupt();
        }
        LOG.info("{} RCode read in {} ms - {} classes - {} methods - {} properties", new Object[]{srv.numRCode.get(), System.currentTimeMillis() - currTime, srv.numClasses.get(), srv.numMethods.get(), srv.numProperties.get()});
    }

    private void parseRCodeInPath(File path, RCodeInjectorService srv) {
        LOG.debug("Parsing rcode in directory {}", (Object)path.getAbsolutePath());
        Files.fileTraverser().depthFirstPreOrder((Object)path).forEach(f -> {
            if (f.getName().endsWith(".r")) {
                srv.numRCode.incrementAndGet();
                srv.service.submit(() -> {
                    ITypeInfo info = this.parseRCode((File)f);
                    if (info != null) {
                        srv.numClasses.incrementAndGet();
                        srv.numMethods.addAndGet(info.getMethods().size());
                        srv.numProperties.addAndGet(info.getProperties().size());
                        this.defaultSession.injectTypeInfo(info);
                    }
                });
            } else if (f.getName().endsWith(".pl")) {
                srv.service.submit(() -> this.parseLibrary((File)f));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITypeInfo parseRCode(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            LOG.debug("Parsing rcode {}", (Object)file.getAbsolutePath());
            RCodeInfo rci = new RCodeInfo((InputStream)fis);
            if (!rci.isClass()) return null;
            ITypeInfo iTypeInfo = rci.getTypeInfo();
            return iTypeInfo;
        }
        catch (RCodeInfo.InvalidRCodeException | IOException | RuntimeException caught) {
            LOG.error("Unable to parse rcode {} - Please open issue on GitHub - {}", (Object)file.getAbsolutePath(), (Object)caught.getClass().getName());
        }
        return null;
    }

    private void parseLibrary(File lib) {
        LOG.debug("Parsing PL {}", (Object)lib.getAbsolutePath());
        PLReader pl = new PLReader(lib.toPath());
        for (FileEntry entry : pl.getFileList()) {
            if (!entry.getFileName().endsWith(".r")) continue;
            try {
                RCodeInfo rci = new RCodeInfo(pl.getInputStream(entry));
                if (!rci.isClass()) continue;
                this.defaultSession.injectTypeInfo(rci.getTypeInfo());
            }
            catch (RCodeInfo.InvalidRCodeException | IOException caught) {
                LOG.error("Unable to open file " + entry.getFileName() + " in PL " + lib.getAbsolutePath(), caught);
            }
        }
    }

    public File getSonarLintXrefDir() {
        return this.resolvePath(this.config.get("sonar.oe.lint.xref").orElse(""));
    }

    public File getPctDir() {
        return new File(this.binariesDirs.get(0).toFile(), ".pct");
    }

    public List<Path> getBinariesDirs() {
        return this.binariesDirs;
    }

    public boolean skipCPD(String annotation) {
        return this.cpdAnnotations.contains(annotation);
    }

    public boolean displayStackTraceOnError() {
        return this.config.getBoolean("sonar.oe.proparse.error.stacktrace").orElse(this.runtime.getProduct() == SonarProduct.SONARQUBE);
    }

    public boolean parseXrefDocument() {
        return this.config.getBoolean("sonar.oe.xml.doc").orElse(false);
    }

    public boolean skipMethod(String name) {
        if (name == null) {
            return false;
        }
        return this.cpdMethods.contains(name.toLowerCase(Locale.ENGLISH));
    }

    public File getRCode(String fileName) {
        for (Path binariesDir : this.binariesDirs) {
            Path rCode = binariesDir.resolve(FilenameUtils.removeExtension((String)fileName) + ".r");
            if (rCode.toFile().exists()) {
                return rCode.toFile();
            }
            Path rCode2 = binariesDir.resolve(fileName.replace('.', '/') + ".r");
            if (!rCode2.toFile().exists()) continue;
            return rCode2.toFile();
        }
        return null;
    }

    public ITypeInfo getRCode2(String fileName) {
        for (Path binariesDir : this.binariesDirs) {
            Path rCode = binariesDir.resolve(fileName.replace('.', '/') + ".r");
            if (!rCode.toFile().exists()) continue;
            return this.parseRCode(rCode.toFile());
        }
        for (File ppEntry : this.propathFull) {
            boolean isPL = "pl".equalsIgnoreCase(FilenameUtils.getExtension((String)ppEntry.getName()));
            if (isPL) {
                PLReader reader = new PLReader(ppEntry.toPath());
                FileEntry entry = reader.getEntry(fileName.replace('.', '/') + ".r");
                if (entry == null) continue;
                try {
                    RCodeInfo rci = new RCodeInfo(reader.getInputStream(entry));
                    if (!rci.isClass()) continue;
                    return rci.getTypeInfo();
                }
                catch (RCodeInfo.InvalidRCodeException | IOException throwable) {
                    continue;
                }
            }
            Path rCode = ppEntry.toPath().resolve(fileName.replace('.', '/') + ".r");
            if (!rCode.toFile().exists()) continue;
            return this.parseRCode(rCode.toFile());
        }
        return null;
    }

    public File getWarningsFile(InputFile file) {
        String relPath = this.getRelativePathToSourceDirs(file);
        if (Strings.isNullOrEmpty((String)relPath)) {
            return null;
        }
        return this.getFileFromPctDirs(relPath + ".warnings");
    }

    public File getXrefFile(InputFile file) {
        String relPath = this.getRelativePathToSourceDirs(file);
        if (Strings.isNullOrEmpty((String)relPath)) {
            return null;
        }
        return this.getFileFromPctDirs(relPath + ".xref");
    }

    public File getSonarlintXrefFile(InputFile file) {
        String s = this.getRelativePathToSourceDirs(file);
        if (!Strings.isNullOrEmpty((String)s) && !s.endsWith(".") && s.indexOf(46) > -1) {
            return new File(this.getSonarLintXrefDir(), s.subSequence(0, s.lastIndexOf(46)) + ".xref.xml");
        }
        return null;
    }

    public File getListingFile(InputFile file) {
        String relPath = this.getRelativePathToSourceDirs(file);
        if (Strings.isNullOrEmpty((String)relPath)) {
            return null;
        }
        return this.getFileFromPctDirs(relPath);
    }

    private File getFileFromPctDirs(String relPath) {
        for (Path dir : this.pctDirs) {
            Path path = dir.resolve(relPath);
            if (!path.toFile().exists()) continue;
            return path.toFile();
        }
        return null;
    }

    private String getRelativePathToSourceDirs(InputFile file) {
        for (Path p : this.sourcePaths) {
            try {
                String s = p.toAbsolutePath().relativize(Paths.get(file.uri())).toString();
                if (Strings.isNullOrEmpty((String)s) || s.startsWith("..")) continue;
                return s;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return "";
    }

    public String getFilePath(String fileName) {
        File f = new File(fileName);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        for (File file : this.propathFull) {
            File stdName = new File(file, fileName);
            if (stdName.exists()) {
                return stdName.getAbsolutePath();
            }
            File clsName = new File(file, fileName.replace('.', '/') + ".cls");
            if (!clsName.exists()) continue;
            return clsName.getAbsolutePath();
        }
        return fileName;
    }

    public boolean isIncludeFile(String name) {
        return this.includeExtensions.contains(Files.getFileExtension((String)name).toLowerCase());
    }

    public boolean skipProcedure(String name) {
        if (name == null) {
            return false;
        }
        return this.cpdProcedures.contains(name.toLowerCase(Locale.ENGLISH));
    }

    public boolean skipProparseSensor() {
        return this.config.getBoolean("sonar.oe.skipProparse").orElse(false);
    }

    public boolean skipXCode() {
        return this.config.getBoolean("sonar.oe.xcode.skip").orElse(true);
    }

    public boolean useProparseDebug() {
        return this.config.getBoolean("sonar.oe.proparse.debug").orElse(false);
    }

    public boolean useANTLR4() {
        return this.config.getBoolean("sonar.oe.antlr4").orElse(false);
    }

    public boolean useANTLR4Profiler() {
        return this.config.getBoolean("sonar.oe.antlr4.profiler").orElse(false);
    }

    public boolean useSimpleCPD() {
        return this.config.getBoolean("sonar.oe.simplecpd").orElse(false);
    }

    public boolean useAnalytics() {
        return this.config.getBoolean("sonar.oe.analytics").orElse(true);
    }

    public List<File> getPropath() {
        return this.propathFull;
    }

    public String getOpenEdgePluginVersion() {
        return this.oePluginVersion;
    }

    public String getPropathAsString() {
        return Joiner.on((char)',').skipNulls().join(this.propathFull);
    }

    public IRefactorSessionEnv getProparseSessions() {
        if (this.sessionsEnv == null) {
            this.sessionsEnv = new RefactorSessionEnv(this.getProparseSession());
            if (this.runtime.getProduct() == SonarProduct.SONARLINT) {
                return this.sessionsEnv;
            }
            int modNum = 1;
            while (true) {
                LOG.info("Looking for submodule #{}", (Object)modNum);
                String prefix = "sonar.oe.module" + modNum;
                String modDatabases = this.config.get(prefix + ".databases").orElse(this.config.get("sonar.oe.databases").orElse("")).trim();
                String modAliases = this.config.get(prefix + ".aliases").orElse(this.config.get("sonar.oe.aliases").orElse("")).trim();
                String modulePropath = this.config.get(prefix + ".propath").orElse(this.config.get("sonar.oe.propath").orElse("")).trim();
                String modPattern = this.config.get(prefix + ".pattern").orElse("").trim();
                if ("".equals(modPattern)) {
                    LOG.info("  No pattern found - Leaving...");
                    return this.sessionsEnv;
                }
                LOG.info(" Found pattern '{}' for submodule #{}", (Object)modPattern, (Object)modNum);
                List<File> pp = this.readPropath(this.fileSystem, modulePropath);
                pp.addAll(this.propathDlc);
                ProparseSettings ppSettings = new ProparseSettings(Joiner.on((char)',').skipNulls().join(pp), this.config.getBoolean("sonar.oe.backslash.escape").orElse(false).booleanValue());
                Schema sch = this.readSchema(this.config, this.fileSystem, modDatabases, modAliases);
                RefactorSession rf = new RefactorSession((IProparseSettings)ppSettings, (ISchema)sch, this.encoding(), this.getProparseSession());
                this.sessionsEnv.addSession(rf, modPattern);
                ++modNum;
            }
        }
        return this.sessionsEnv;
    }

    private RefactorSession getProparseSession() {
        if (this.defaultSession == null) {
            Optional skipXCode;
            Optional processArch;
            Integer processArchInt;
            Optional batchMode;
            Optional proVersion;
            Optional windowSystem;
            Optional opsys;
            Schema sch = this.readSchema(this.config, this.fileSystem, this.config.get("sonar.oe.databases").orElse(""), this.config.get("sonar.oe.aliases").orElse(""));
            ProparseSettings ppSettings = new ProparseSettings(this.getPropathAsString(), this.config.getBoolean("sonar.oe.backslash.escape").orElse(false).booleanValue());
            Optional tokenStartChars = this.config.get("sonar.oe.proparse.tokenStartChars");
            if (tokenStartChars.isPresent()) {
                ppSettings.setTokenStartChars(((String)tokenStartChars.get()).toCharArray());
            }
            if ((opsys = this.config.get("sonar.oe.preprocessor.opsys")).isPresent()) {
                ppSettings.setCustomOpsys((String)opsys.get());
            }
            if ((windowSystem = this.config.get("sonar.oe.preprocessor.window-system")).isPresent()) {
                ppSettings.setCustomWindowSystem((String)windowSystem.get());
            }
            if ((proVersion = this.config.get("sonar.oe.preprocessor.proversion")).isPresent()) {
                ppSettings.setCustomProversion((String)proVersion.get());
            }
            if ((batchMode = this.config.getBoolean("sonar.oe.preprocessor.batch-mode")).isPresent()) {
                ppSettings.setCustomBatchMode(((Boolean)batchMode.get()).booleanValue());
            }
            Integer n = processArchInt = (processArch = this.config.get("sonar.oe.preprocessor.process-architecture")).isPresent() ? Ints.tryParse((String)((String)processArch.get())) : null;
            if (processArchInt != null) {
                ppSettings.setCustomProcessArchitecture(processArchInt.intValue());
            }
            if ((skipXCode = this.config.getBoolean("sonar.oe.xcode.skip")).isPresent()) {
                ppSettings.setCustomSkipXCode(((Boolean)skipXCode.get()).booleanValue());
            }
            ppSettings.setAntlrTokenDeletion(this.config.getBoolean("sonar.oe.proparse.token.deletion").orElse(false).booleanValue());
            ppSettings.setAntlrTokenInsertion(this.config.getBoolean("sonar.oe.proparse.token.insertion").orElse(false).booleanValue());
            ppSettings.setAntlrRecover(this.config.getBoolean("sonar.oe.proparse.recover").orElse(false).booleanValue());
            this.defaultSession = new RefactorSession((IProparseSettings)ppSettings, (ISchema)sch, this.encoding());
            Optional assemblyCatalog = this.config.get("sonar.oe.assembly.catalog");
            if (assemblyCatalog.isPresent()) {
                try (FileReader reader = new FileReader((String)assemblyCatalog.get());){
                    this.defaultSession.injectClassesFromCatalog((Reader)reader);
                }
                catch (IOException caught) {
                    LOG.error("Unable to read assembly catalog '" + (String)assemblyCatalog.get() + "'", (Throwable)caught);
                }
            }
            if (this.runtime.getProduct() == SonarProduct.SONARQUBE) {
                this.parseBuildDirectory();
            }
        }
        return this.defaultSession;
    }

    private Charset encoding() {
        String encoding = this.config.get("sonar.sourceEncoding").orElse("");
        if (Strings.isNullOrEmpty((String)encoding)) {
            return Charset.defaultCharset();
        }
        return Charset.forName(encoding.trim());
    }

    private Collection<IDatabase> readSchemaFromProp1(FileSystem fileSystem, String dbList) {
        ArrayList<IDatabase> dbs = new ArrayList<IDatabase>();
        LOG.info("Using schema : {}", (Object)dbList);
        for (String str : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)dbList)) {
            String dbName;
            int colonPos = str.lastIndexOf(58);
            if (colonPos <= 1) {
                dbName = FilenameUtils.getBaseName((String)str);
            } else {
                dbName = str.substring(colonPos + 1);
                str = str.substring(0, colonPos);
            }
            LOG.debug("Parsing {} with alias {}", (Object)this.resolvePath(str), (Object)dbName);
            File dfFile = this.resolvePath(str);
            File serFile = new File(fileSystem.baseDir(), ".sonarlint/" + str.replace(':', '_').replace('\\', '_').replace('/', '_') + ".bin");
            serFile.getParentFile().mkdir();
            DatabaseDescription desc = null;
            if (this.runtime.getProduct() == SonarProduct.SONARLINT && dfFile.lastModified() < serFile.lastModified()) {
                LOG.debug("SonarLint side, using serialized file");
                try (FileInputStream is = new FileInputStream(serFile);){
                    desc = DatabaseDescription.deserialize((InputStream)is, (String)dbName);
                }
                catch (IOException caught) {
                    LOG.error("Unable to deserialize from '" + serFile + "', deleting file", (Throwable)caught);
                    FileUtils.deleteQuietly((File)serFile);
                }
            } else {
                try {
                    desc = DumpFileUtils.getDatabaseDescription((Path)this.resolvePath(str).toPath(), (String)dbName);
                }
                catch (IOException caught) {
                    if (this.runtime.getProduct() == SonarProduct.SONARLINT) {
                        throw new RuntimeException("Unable to read database schema from '" + dfFile.getName() + "', property value is '" + dbList + "'", caught);
                    }
                    LOG.error("Unable to parse " + str, (Throwable)caught);
                }
                if (desc != null && this.runtime.getProduct() == SonarProduct.SONARLINT) {
                    try (FileOutputStream os = new FileOutputStream(serFile);){
                        desc.serialize((OutputStream)os);
                    }
                    catch (IOException caught) {
                        LOG.error("Unable to serialize to '" + serFile + "'", (Throwable)caught);
                    }
                }
            }
            if (desc == null) continue;
            dbs.add((IDatabase)new DatabaseWrapper(desc));
        }
        return dbs;
    }

    private Collection<IDatabase> readSchemaFromProp2(Configuration config) {
        ArrayList<IDatabase> dbs = new ArrayList<IDatabase>();
        for (String str : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)config.get("sonar.oe.lint.databases").orElse(""))) {
            String dbName = FilenameUtils.getBaseName((String)str);
            LOG.debug("Parsing '{}' with db name {}", (Object)str, (Object)dbName);
            try (FileInputStream is = new FileInputStream(new File(str));){
                dbs.add((IDatabase)new DatabaseWrapper(DatabaseDescription.deserialize((InputStream)is, (String)dbName)));
            }
            catch (IOException caught) {
                LOG.error("Unable to deserialize from '" + str + "'", (Throwable)caught);
            }
        }
        return dbs;
    }

    private Schema readSchema(Configuration config, FileSystem fileSystem, String dbPropValue, String aliasPropValue) {
        Collection<Object> dbs = new ArrayList();
        if (dbPropValue.length() > 0) {
            dbs = this.readSchemaFromProp1(fileSystem, dbPropValue);
        } else if (this.runtime.getProduct() == SonarProduct.SONARLINT && config.get("sonar.oe.lint.databases").orElse("").length() > 0) {
            dbs = this.readSchemaFromProp2(config);
        }
        Schema sch = new Schema(dbs.toArray(new IDatabase[0]));
        if (!sch.getDbSet().isEmpty()) {
            sch.createAlias("dictdb", ((IDatabase)sch.getDbSet().first()).getName());
        }
        for (String str : Splitter.on((char)';').trimResults().omitEmptyStrings().split((CharSequence)aliasPropValue)) {
            List lst = Splitter.on((char)',').trimResults().splitToList((CharSequence)str);
            for (String alias : lst.subList(1, lst.size())) {
                LOG.debug("Adding {} aliases to database {}", (Object)alias, lst.get(0));
                sch.createAlias(alias, (String)lst.get(0));
            }
        }
        return sch;
    }

    public String readPluginVersion(ClassLoader cl, String file) {
        String retVal = "";
        try (InputStream inp = cl.getResourceAsStream(file);
             InputStreamReader r1 = new InputStreamReader(inp);
             BufferedReader r2 = new BufferedReader(r1);){
            retVal = r2.readLine();
        }
        catch (IOException caught) {
            LOG.debug("Unable to read '" + file + "'", (Object)caught);
            retVal = file + " not found";
        }
        return retVal;
    }

    private File resolvePath(String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        try {
            file = new File(this.fileSystem.baseDir(), path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to resolve path '" + path + "'", e);
        }
        return file;
    }

    private class RCodeInjectorService {
        AtomicInteger numClasses = new AtomicInteger(0);
        AtomicInteger numMethods = new AtomicInteger(0);
        AtomicInteger numProperties = new AtomicInteger(0);
        AtomicInteger numRCode = new AtomicInteger(0);
        ExecutorService service = Executors.newFixedThreadPool(4);

        private RCodeInjectorService() {
        }
    }
}

