/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.foundation;

import com.google.common.base.Splitter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.prorefactor.refactor.RefactorSession;
import org.sonar.api.utils.PathUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.foundation.IRefactorSessionEnv;

public class RefactorSessionEnv
implements IRefactorSessionEnv {
    private static final Logger LOG = Loggers.get(RefactorSessionEnv.class);
    private final RefactorSession defaultSession;
    private final List<SessionMapping> extraSessions = new ArrayList<SessionMapping>();
    private int num = 1;

    public RefactorSessionEnv(RefactorSession session) {
        this.defaultSession = session;
    }

    public void addSession(RefactorSession session, String includePattern) {
        this.extraSessions.add(new SessionMapping(this.num++, session, includePattern));
    }

    public RefactorSession getDefaultSession() {
        return this.defaultSession;
    }

    public RefactorSession getSession(String fileName) {
        for (SessionMapping mapping : this.extraSessions) {
            for (WildcardPattern pattern : mapping.patterns) {
                if (!pattern.match(PathUtils.sanitize((String)Paths.get(fileName, new String[0]).toString()))) continue;
                LOG.debug("File {} matches pattern {} in module {}", new Object[]{fileName, pattern, mapping.num});
                return mapping.session;
            }
        }
        return this.defaultSession;
    }

    private static class SessionMapping {
        private final int num;
        private final RefactorSession session;
        private final WildcardPattern[] patterns;

        private SessionMapping(int num, RefactorSession session, String pattern) {
            this.num = num;
            this.session = session;
            if (pattern == null) {
                this.patterns = new WildcardPattern[0];
            } else {
                List strs = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)pattern);
                this.patterns = new WildcardPattern[strs.size()];
                int zz = 0;
                for (String s : strs) {
                    this.patterns[zz++] = WildcardPattern.create((String)s);
                }
            }
        }
    }
}

