/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.sensor;

import java.io.UncheckedIOException;
import java.util.Locale;
import org.antlr.v4.runtime.TokenSource;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.ProToken;
import org.prorefactor.core.ProparseRuntimeException;
import org.prorefactor.proparse.XCodedFileException;
import org.prorefactor.proparse.support.IProparseEnvironment;
import org.prorefactor.treeparser.ParseUnit;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.foundation.IRefactorSessionEnv;
import org.sonar.plugins.openedge.foundation.InputFileUtils;
import org.sonar.plugins.openedge.foundation.OpenEdgeSettings;

public class OpenEdgeCPDSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(OpenEdgeCPDSensor.class);
    private final OpenEdgeSettings settings;

    public OpenEdgeCPDSensor(OpenEdgeSettings settings) {
        this.settings = settings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("oe").name(this.getClass().getSimpleName()).onlyWhenConfiguration(config -> config.getBoolean("sonar.oe.skipProparse").orElse(false) != false && config.getBoolean("sonar.oe.simplecpd").orElse(false) != false);
    }

    public void execute(SensorContext context) {
        if (context.runtime().getProduct() == SonarProduct.SONARLINT || !this.settings.useSimpleCPD()) {
            return;
        }
        this.settings.init();
        IRefactorSessionEnv sessions = this.settings.getProparseSessions();
        for (InputFile file : context.fileSystem().inputFiles(context.fileSystem().predicates().hasLanguage("oe"))) {
            LOG.debug("CPD on {}", (Object)file);
            IProparseEnvironment session = sessions.getSession(file.relativePath());
            try {
                this.processFile(context, session, file);
            }
            catch (UncheckedIOException | ProparseRuntimeException caught) {
                if (caught.getCause() instanceof XCodedFileException) {
                    LOG.error("Unable to process xcode'd file '{}", (Object)file);
                    continue;
                }
                LOG.error("Unable to lex file '{}'", (Object)file, (Object)caught);
            }
        }
    }

    private void processFile(SensorContext context, IProparseEnvironment session, InputFile file) {
        TokenSource stream = new ParseUnit(InputFileUtils.getInputStream(file), InputFileUtils.getRelativePath(file, context.fileSystem()), session).lex();
        if (stream == null) {
            return;
        }
        NewCpdTokens cpdTokens = context.newCpdTokens().onFile(file);
        OpenEdgeCPDSensor.processTokenSource(file, cpdTokens, stream);
    }

    public static void processTokenSource(InputFile file, NewCpdTokens cpdTokens, TokenSource stream) {
        ProToken tok = (ProToken)stream.nextToken();
        boolean suspended = false;
        while (tok.getNodeType() != ABLNodeType.EOF_ANTLR4) {
            if (tok.getNodeType() == ABLNodeType.AMPANALYZESUSPEND && (tok.getText().startsWith("&ANALYZE-SUSPEND _CREATE-WINDOW") || tok.getText().startsWith("&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE adm-create-objects"))) {
                suspended = true;
            } else if (tok.getNodeType() == ABLNodeType.AMPANALYZERESUME) {
                suspended = false;
            }
            if (!suspended) {
                OpenEdgeCPDSensor.processToken(file, cpdTokens, tok);
            }
            tok = (ProToken)stream.nextToken();
        }
        cpdTokens.save();
    }

    private static void processToken(InputFile file, NewCpdTokens cpdTokens, ProToken tok) {
        String str;
        String string = str = tok.getNodeType() == ABLNodeType.NUMBER ? tok.getText() : tok.getNodeType().getText();
        if (str == null || str.trim().length() == 0) {
            str = tok.getNodeType() == ABLNodeType.ID ? tok.getText().toLowerCase(Locale.ENGLISH) : tok.getText().trim();
        }
        try {
            TextRange range = file.newRange(tok.getLine(), tok.getCharPositionInLine() - 1, tok.getEndLine(), tok.getEndCharPositionInLine());
            cpdTokens.addToken(range, str);
        }
        catch (IllegalArgumentException | IllegalStateException uncaught) {
            LOG.debug("Unable to create CPD token at position {}:{} to {}:{} - Cause {}", new Object[]{tok.getLine(), tok.getCharPositionInLine(), tok.getEndLine(), tok.getEndCharPositionInLine(), uncaught.getMessage()});
        }
    }
}

