/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.sensor;

import java.io.UncheckedIOException;
import org.antlr.v4.runtime.TokenSource;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.ProToken;
import org.prorefactor.core.ProparseRuntimeException;
import org.prorefactor.proparse.XCodedFileException;
import org.prorefactor.proparse.support.IProparseEnvironment;
import org.prorefactor.treeparser.ParseUnit;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.foundation.IRefactorSessionEnv;
import org.sonar.plugins.openedge.foundation.InputFileUtils;
import org.sonar.plugins.openedge.foundation.OpenEdgeSettings;

public class OpenEdgeCodeColorizer
implements Sensor {
    private static final Logger LOG = Loggers.get(OpenEdgeCodeColorizer.class);
    private final OpenEdgeSettings settings;

    public OpenEdgeCodeColorizer(OpenEdgeSettings settings) {
        this.settings = settings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("oe").name(this.getClass().getSimpleName());
    }

    public void execute(SensorContext context) {
        if (context.runtime().getProduct() == SonarProduct.SONARLINT) {
            return;
        }
        this.settings.init();
        IRefactorSessionEnv sessions = this.settings.getProparseSessions();
        for (InputFile file : context.fileSystem().inputFiles(context.fileSystem().predicates().hasLanguage("oe"))) {
            LOG.debug("Syntax highlight on {}", (Object)file);
            IProparseEnvironment session = sessions.getSession(file.relativePath());
            try {
                this.highlightFile(context, session, file);
            }
            catch (UncheckedIOException | ProparseRuntimeException caught) {
                if (caught.getCause() instanceof XCodedFileException) {
                    LOG.error("Unable to highlight xcode'd file '{}", (Object)file);
                    continue;
                }
                LOG.error("Unable to lex file '{}'", (Object)file, (Object)caught);
            }
        }
    }

    private void highlightFile(SensorContext context, IProparseEnvironment session, InputFile file) {
        TokenSource stream = new ParseUnit(InputFileUtils.getInputStream(file), InputFileUtils.getRelativePath(file, context.fileSystem()), session).lex();
        ProToken tok = (ProToken)stream.nextToken();
        ProToken nextTok = (ProToken)stream.nextToken();
        NewHighlighting highlighting = context.newHighlighting().onFile(file);
        while (tok.getNodeType() != ABLNodeType.EOF_ANTLR4) {
            TypeOfText textType = null;
            if (tok.getNodeType() == ABLNodeType.QSTRING) {
                textType = TypeOfText.STRING;
            } else if (tok.getNodeType() == ABLNodeType.COMMENT) {
                textType = TypeOfText.COMMENT;
            } else if (tok.getNodeType().isKeyword()) {
                textType = TypeOfText.KEYWORD;
            } else if (tok.getNodeType() == ABLNodeType.INCLUDEDIRECTIVE || tok.getNodeType().isPreprocessor()) {
                textType = TypeOfText.PREPROCESS_DIRECTIVE;
            } else if (tok.getNodeType() == ABLNodeType.NUMBER || tok.getNodeType() == ABLNodeType.QUESTION) {
                textType = TypeOfText.CONSTANT;
            } else if (tok.getNodeType() == ABLNodeType.ANNOTATION) {
                textType = TypeOfText.ANNOTATION;
            }
            if (textType != null) {
                try {
                    TextPointer start = file.newPointer(tok.getLine(), tok.getCharPositionInLine() - 1);
                    int maxChar = file.selectLine(tok.getEndLine()).end().lineOffset();
                    TextPointer end = file.newPointer(tok.getEndLine(), maxChar < tok.getEndCharPositionInLine() ? (maxChar > 0 ? maxChar - 1 : 0) : tok.getEndCharPositionInLine());
                    highlighting.highlight(file.newRange(start, end), textType);
                }
                catch (IllegalArgumentException caught) {
                    LOG.error("File {} - Unable to highlight token type {} - Start {}:{} - End {}:{} - Remaining tokens skipped", new Object[]{file, textType, tok.getLine(), tok.getCharPositionInLine(), tok.getEndLine(), tok.getEndCharPositionInLine()});
                    return;
                }
            }
            tok = nextTok;
            nextTok = (ProToken)stream.nextToken();
        }
        highlighting.save();
    }
}

