/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.sensor;

import eu.rssw.antlr.database.DumpFileGrammarLexer;
import java.io.IOException;
import java.io.InputStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class OpenEdgeDBColorizer
implements Sensor {
    private static final Logger LOG = Loggers.get(OpenEdgeDBColorizer.class);

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("oedb").name(this.getClass().getSimpleName());
    }

    public void execute(SensorContext context) {
        if (context.runtime().getProduct() == SonarProduct.SONARLINT) {
            return;
        }
        for (InputFile file : context.fileSystem().inputFiles(context.fileSystem().predicates().hasLanguage("oedb"))) {
            LOG.debug("DF syntax highlight on {}", (Object)file);
            try {
                this.highlightFile(context, file);
            }
            catch (IOException | RuntimeException caught) {
                LOG.error("Unable to lex file " + file, (Throwable)caught);
            }
        }
    }

    private void highlightFile(SensorContext context, InputFile file) throws IOException {
        DumpFileGrammarLexer lexer = new DumpFileGrammarLexer(CharStreams.fromStream((InputStream)file.inputStream()));
        NewHighlighting highlighting = context.newHighlighting().onFile(file);
        Token tok = lexer.nextToken();
        Token nextTok = lexer.nextToken();
        while (tok.getType() != -1) {
            if (tok.getChannel() != 1) {
                TypeOfText textType = null;
                textType = tok.getType() == 216 || tok.getType() == 215 ? TypeOfText.STRING : (tok.getType() == 213 ? TypeOfText.CONSTANT : (tok.getType() == 214 ? TypeOfText.ANNOTATION : TypeOfText.KEYWORD));
                TextPointer start = file.newPointer(tok.getLine(), tok.getCharPositionInLine());
                TextPointer end = nextTok.getCharPositionInLine() == 0 ? file.selectLine(nextTok.getLine() - 1).end() : file.newPointer(nextTok.getLine(), nextTok.getCharPositionInLine());
                highlighting.highlight(file.newRange(start, end), textType);
            }
            tok = nextTok;
            nextTok = lexer.nextToken();
        }
        highlighting.save();
    }
}

