/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.sensor;

import eu.rssw.antlr.database.DumpFileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.api.checks.OpenEdgeDumpFileCheck;
import org.sonar.plugins.openedge.foundation.OpenEdgeComponents;

public class OpenEdgeDBRulesSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(OpenEdgeDBRulesSensor.class);
    private final OpenEdgeComponents components;

    public OpenEdgeDBRulesSensor(OpenEdgeComponents components) {
        this.components = components;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("oedb").name(this.getClass().getSimpleName());
    }

    public void execute(SensorContext context) {
        HashMap<String, Long> ruleTime = new HashMap<String, Long>();
        long parseTime = 0L;
        this.components.init(context);
        for (Map.Entry<ActiveRule, OpenEdgeDumpFileCheck> entry : this.components.getDumpFileRules().entrySet()) {
            ruleTime.put(entry.getKey().ruleKey().toString(), 0L);
        }
        FilePredicates predicates = context.fileSystem().predicates();
        for (InputFile inputFile : context.fileSystem().inputFiles(predicates.and(predicates.hasLanguage("oedb"), predicates.hasType(InputFile.Type.MAIN)))) {
            try {
                LOG.debug("Generating ParseTree for dump file {}", (Object)inputFile);
                long time = System.currentTimeMillis();
                ParseTree tree = DumpFileUtils.getDumpFileParseTree((InputStream)inputFile.inputStream(), (Charset)inputFile.charset());
                parseTime += System.currentTimeMillis() - time;
                for (Map.Entry<ActiveRule, OpenEdgeDumpFileCheck> entry : this.components.getDumpFileRules().entrySet()) {
                    LOG.debug("ActiveRule - Internal key {} - Repository {} - Rule {}", new Object[]{entry.getKey().internalKey(), entry.getKey().ruleKey().repository(), entry.getKey().ruleKey().rule()});
                    long startTime = System.currentTimeMillis();
                    entry.getValue().execute(inputFile, (Object)tree);
                    ruleTime.put(entry.getKey().ruleKey().toString(), (Long)ruleTime.get(entry.getKey().ruleKey().toString()) + System.currentTimeMillis() - startTime);
                }
            }
            catch (IOException caught) {
                LOG.error("Unable to analyze {}", (Object)inputFile, (Object)caught);
            }
        }
        LOG.info("AST Generation | time={} ms", (Object)parseTime);
        for (Map.Entry entry : ruleTime.entrySet()) {
            LOG.info("Rule {} | time={} ms", entry.getKey(), entry.getValue());
        }
    }
}

