/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.sensor;

import com.google.common.io.Files;
import eu.rssw.antlr.database.DumpFileUtils;
import eu.rssw.antlr.database.objects.DatabaseDescription;
import eu.rssw.antlr.database.objects.Field;
import eu.rssw.antlr.database.objects.Table;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.foundation.OpenEdgeMetrics;

public class OpenEdgeDBSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(OpenEdgeDBSensor.class);

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("oedb").name(this.getClass().getSimpleName());
    }

    public void execute(SensorContext context) {
        this.computeBaseMetrics(context);
    }

    private void computeBaseMetrics(SensorContext sensorContext) {
        FilePredicates predicates = sensorContext.fileSystem().predicates();
        for (InputFile file : sensorContext.fileSystem().inputFiles(predicates.and(predicates.hasLanguage("oedb"), predicates.hasType(InputFile.Type.MAIN)))) {
            try {
                LOG.info("Analyzing {}", (Object)file);
                DatabaseDescription desc = DumpFileUtils.getDatabaseDescription((InputStream)file.inputStream(), (Charset)file.charset(), (String)Files.getNameWithoutExtension((String)file.filename()));
                sensorContext.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.NUM_TABLES).withValue((Serializable)Integer.valueOf(desc.getTables().size())).save();
                sensorContext.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.NUM_SEQUENCES).withValue((Serializable)Integer.valueOf(desc.getSequences().size())).save();
                int numFlds = 0;
                int numIdx = 0;
                int numTriggers = 0;
                for (Table tab : desc.getTables()) {
                    numFlds += tab.getFields().size();
                    numIdx += tab.getIndexes().size();
                    numTriggers += tab.getTriggers().size();
                    for (Field f : tab.getFields()) {
                        numTriggers += f.getTriggers().size();
                    }
                }
                sensorContext.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.NUM_FIELDS).withValue((Serializable)Integer.valueOf(numFlds)).save();
                sensorContext.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.NUM_INDEXES).withValue((Serializable)Integer.valueOf(numIdx)).save();
                sensorContext.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.NUM_TRIGGERS).withValue((Serializable)Integer.valueOf(numTriggers)).save();
            }
            catch (IOException caught) {
                LOG.error("Can not analyze file", (Throwable)caught);
            }
        }
    }
}

