/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.openedge.sensor;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.progress.xref.CrossReference;
import com.progress.xref.CrossReferenceUtils;
import com.progress.xref.InvalidXMLFilterStream;
import eu.rssw.listing.CodeBlock;
import eu.rssw.listing.ListingParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.ICallback;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.JsonNodeLister;
import org.prorefactor.core.ProToken;
import org.prorefactor.core.ProparseRuntimeException;
import org.prorefactor.proparse.IncludeFileNotFoundException;
import org.prorefactor.proparse.XCodedFileException;
import org.prorefactor.proparse.antlr4.Proparse;
import org.prorefactor.proparse.antlr4.ProparseListener;
import org.prorefactor.proparse.support.IProparseEnvironment;
import org.prorefactor.treeparser.ParseUnit;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.openedge.api.checks.OpenEdgeProparseCheck;
import org.sonar.plugins.openedge.foundation.CPDCallback;
import org.sonar.plugins.openedge.foundation.IRefactorSessionEnv;
import org.sonar.plugins.openedge.foundation.InputFileUtils;
import org.sonar.plugins.openedge.foundation.OpenEdgeComponents;
import org.sonar.plugins.openedge.foundation.OpenEdgeMetrics;
import org.sonar.plugins.openedge.foundation.OpenEdgeSettings;
import org.sonar.plugins.openedge.sensor.OpenEdgeCPDSensor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class OpenEdgeProparseSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(OpenEdgeProparseSensor.class);
    private final OpenEdgeSettings settings;
    private final OpenEdgeComponents components;
    private final DocumentBuilderFactory dbFactory;
    private final DocumentBuilder dBuilder;
    private int numFiles;
    private int numXREF;
    private int numListings;
    private int numFailures;
    private int ncLoc;
    private Map<String, Long> ruleTime = new HashMap<String, Long>();
    private long parseTime = 0L;
    private long xmlParseTime = 0L;
    private long maxParseTime = 0L;
    private Map<Integer, Long> decisionTime = new HashMap<Integer, Long>();
    private Map<Integer, Long> maxK = new HashMap<Integer, Long>();
    List<String> debugFiles = new ArrayList<String>();

    public OpenEdgeProparseSensor(OpenEdgeSettings settings, OpenEdgeComponents components) {
        this.settings = settings;
        this.components = components;
        this.dbFactory = DocumentBuilderFactory.newInstance();
        try {
            this.dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            this.dBuilder = this.dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException caught) {
            throw new IllegalStateException(caught);
        }
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("oe").name(this.getClass().getSimpleName()).onlyWhenConfiguration(config -> config.getBoolean("sonar.oe.skipProparse").orElse(false) == false);
    }

    public void execute(SensorContext context) {
        if (this.settings.skipProparseSensor()) {
            return;
        }
        this.settings.init();
        this.components.init(context);
        for (Map.Entry<ActiveRule, OpenEdgeProparseCheck> entry : this.components.getProparseRules().entrySet()) {
            this.ruleTime.put(entry.getKey().ruleKey().toString(), 0L);
        }
        IRefactorSessionEnv sessions = this.settings.getProparseSessions();
        FilePredicates predicates = context.fileSystem().predicates();
        long totFiles = StreamSupport.stream(context.fileSystem().inputFiles(predicates.and(predicates.hasLanguage("oe"), predicates.hasType(InputFile.Type.MAIN))).spliterator(), false).count();
        long prevMessage = System.currentTimeMillis();
        for (InputFile file : context.fileSystem().inputFiles(predicates.and(predicates.hasLanguage("oe"), predicates.hasType(InputFile.Type.MAIN)))) {
            LOG.debug("Parsing {}", (Object)file);
            ++this.numFiles;
            if (System.currentTimeMillis() - prevMessage > 30000L) {
                prevMessage = System.currentTimeMillis();
                LOG.info("{}/{} - Current file: {}", new Object[]{this.numFiles, totFiles, file.relativePath()});
            }
            IProparseEnvironment session = sessions.getSession(file.relativePath());
            if (this.settings.isIncludeFile(file.filename())) {
                this.parseIncludeFile(context, file, session);
            } else {
                this.parseMainFile(context, file, session);
            }
            if (!context.isCancelled()) continue;
            LOG.info("Analysis cancelled...");
            return;
        }
        this.computeAnalytics(context);
        this.logStatistics();
        this.generateProparseDebugIndex();
    }

    private void parseIncludeFile(SensorContext context, InputFile file, IProparseEnvironment session) {
        long startTime = System.currentTimeMillis();
        ParseUnit lexUnit = null;
        try {
            lexUnit = new ParseUnit(InputFileUtils.getInputStream(file), InputFileUtils.getRelativePath(file, context.fileSystem()), session);
            lexUnit.lexAndGenerateMetrics();
        }
        catch (UncheckedIOException caught) {
            ++this.numFailures;
            if (caught.getCause() instanceof XCodedFileException) {
                LOG.error("Unable to generate file metrics for xcode'd file '{}", (Object)file);
            } else {
                LOG.error("Unable to generate file metrics for file '" + file + "'", (Throwable)caught);
            }
            return;
        }
        catch (ProparseRuntimeException caught) {
            LOG.error("Unable to generate file metrics for file '" + file + "'", (Throwable)caught);
            return;
        }
        this.updateParseTime(System.currentTimeMillis() - startTime);
        if (lexUnit.getMetrics() != null) {
            context.newMeasure().on((InputComponent)file).forMetric((Metric)CoreMetrics.NCLOC).withValue((Serializable)Integer.valueOf(lexUnit.getMetrics().getLoc())).save();
            this.ncLoc += lexUnit.getMetrics().getLoc();
            context.newMeasure().on((InputComponent)file).forMetric((Metric)CoreMetrics.COMMENT_LINES).withValue((Serializable)Integer.valueOf(lexUnit.getMetrics().getComments())).save();
        }
        if (!this.settings.useSimpleCPD()) {
            try {
                lexUnit = new ParseUnit(InputFileUtils.getInputStream(file), InputFileUtils.getRelativePath(file, context.fileSystem()), session);
                TokenSource stream = lexUnit.lex();
                OpenEdgeCPDSensor.processTokenSource(file, context.newCpdTokens().onFile(file), stream);
            }
            catch (UncheckedIOException | ProparseRuntimeException throwable) {
                // empty catch block
            }
        }
    }

    private Document parseXREF(File xrefFile) {
        Document doc = null;
        if (xrefFile != null && xrefFile.exists()) {
            LOG.debug("Parsing XML XREF file {}", (Object)xrefFile.getAbsolutePath());
            try (FileInputStream inpStream = new FileInputStream(xrefFile);){
                doc = this.dBuilder.parse((InputStream)new InvalidXMLFilterStream((InputStream)inpStream));
            }
            catch (IOException | SAXException caught) {
                LOG.error("Unable to parse XREF file " + xrefFile.getAbsolutePath(), (Throwable)caught);
            }
        }
        return doc;
    }

    private void parseMainFile(SensorContext context, InputFile file, IProparseEnvironment session) {
        long startTime;
        CrossReference xref = null;
        Document doc = null;
        if (context.runtime().getProduct() == SonarProduct.SONARQUBE) {
            startTime = System.currentTimeMillis();
            xref = CrossReferenceUtils.parseXREF((File)this.settings.getXrefFile(file));
            if (this.settings.parseXrefDocument()) {
                doc = this.parseXREF(this.settings.getXrefFile(file));
            }
            this.xmlParseTime += System.currentTimeMillis() - startTime;
        } else if (context.runtime().getProduct() == SonarProduct.SONARLINT) {
            startTime = System.currentTimeMillis();
            xref = CrossReferenceUtils.parseXREF((File)this.settings.getSonarlintXrefFile(file));
            if (this.settings.parseXrefDocument()) {
                doc = this.parseXREF(this.settings.getSonarlintXrefFile(file));
            }
            this.xmlParseTime += System.currentTimeMillis() - startTime;
            this.settings.parseHierarchy(file);
        }
        if (!xref.getSource().isEmpty()) {
            ++this.numXREF;
        }
        File listingFile = this.settings.getListingFile(file);
        ArrayList<Integer> trxBlocks = new ArrayList<Integer>();
        if (listingFile != null && listingFile.exists() && listingFile.getAbsolutePath().indexOf(32) == -1) {
            try {
                ListingParser parser = new ListingParser(listingFile.toPath(), InputFileUtils.getRelativePath(file, context.fileSystem()));
                for (CodeBlock block : parser.getTransactionBlocks()) {
                    trxBlocks.add(block.getLineNumber());
                }
                ++this.numListings;
            }
            catch (IOException caught) {
                LOG.error("Unable to parse listing file for " + file, (Throwable)caught);
            }
        } else {
            LOG.debug("Listing file for '{}' not found or contains space character - Was looking for '{}'", (Object)file, (Object)listingFile);
        }
        long numShrTT = xref.getSource().stream().mapToLong(src -> src.getReference().stream().filter(ref -> "NEW-SHR-TEMPTABLE".equalsIgnoreCase(ref.getReferenceType())).count()).sum();
        long numShrDS = xref.getSource().stream().mapToLong(src -> src.getReference().stream().filter(ref -> "NEW-SHR-DATASET".equalsIgnoreCase(ref.getReferenceType())).count()).sum();
        long numShrVar = xref.getSource().stream().mapToLong(src -> src.getReference().stream().filter(ref -> "NEW-SHR-VARIABLE".equalsIgnoreCase(ref.getReferenceType())).count()).sum();
        context.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.NUM_TRANSACTIONS).withValue((Serializable)Integer.valueOf(trxBlocks.size())).save();
        context.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.SHR_TT).withValue((Serializable)Integer.valueOf((int)numShrTT)).save();
        context.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.SHR_DS).withValue((Serializable)Integer.valueOf((int)numShrDS)).save();
        context.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.SHR_VAR).withValue((Serializable)Integer.valueOf((int)numShrVar)).save();
        ParseUnit unit = null;
        long startTime2 = System.currentTimeMillis();
        try {
            unit = new ParseUnit(InputFileUtils.getInputStream(file), InputFileUtils.getRelativePath(file, context.fileSystem()), session);
            unit.attachXref(doc);
            unit.attachXref(xref);
            unit.parse();
            unit.treeParser01();
            for (Class<? extends ProparseListener> clz : this.components.getProparseListeners()) {
                Injector injector = Guice.createInjector((Module[])new Module[]{new TreeParserModule(clz, unit)});
                ProparseListener listener = (ProparseListener)injector.getInstance(ProparseListener.class);
                unit.treeParser(listener);
            }
            unit.attachTransactionBlocks(trxBlocks);
            unit.attachTypeInfo(session.getTypeInfo(unit.getClassName()));
            this.updateParseTime(System.currentTimeMillis() - startTime2);
        }
        catch (UncheckedIOException caught) {
            ++this.numFailures;
            if (caught.getCause() instanceof XCodedFileException) {
                XCodedFileException cause = (XCodedFileException)caught.getCause();
                LOG.error("Unable to parse {} - Can't read xcode'd file {}", (Object)file, (Object)cause.getFileName());
            } else if (caught.getCause() instanceof IncludeFileNotFoundException) {
                IncludeFileNotFoundException cause = (IncludeFileNotFoundException)caught.getCause();
                LOG.error("Unable to parse {} - Can't find include file '{}' from '{}'", new Object[]{file, cause.getIncludeName(), cause.getFileName()});
            } else {
                LOG.error("Unable to parse " + file + " - IOException was caught - Please report this issue", (Throwable)caught);
            }
            return;
        }
        catch (ParseCancellationException caught) {
            RecognitionException cause = (RecognitionException)caught.getCause();
            ProToken tok = (ProToken)cause.getOffendingToken();
            if (this.settings.displayStackTraceOnError()) {
                LOG.error("Parser error in '" + file + "' at position " + tok.getFileName() + ":" + tok.getLine() + ":" + tok.getCharPositionInLine(), (Throwable)cause);
            } else {
                LOG.error("Parser error in '{}' at position {}:{}:{}", new Object[]{file, tok.getFileName(), tok.getLine(), tok.getCharPositionInLine()});
            }
            ++this.numFailures;
            TextPointer strt = null;
            TextPointer end = null;
            if (InputFileUtils.getRelativePath(file, context.fileSystem()).equals(tok.getFileName())) {
                try {
                    strt = file.newPointer(tok.getLine(), tok.getCharPositionInLine() - 1);
                    end = file.newPointer(tok.getLine(), tok.getCharPositionInLine());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (context.runtime().getProduct() == SonarProduct.SONARLINT) {
                NewAnalysisError analysisError = context.newAnalysisError();
                analysisError.onFile(file);
                analysisError.message(Strings.nullToEmpty((String)cause.getMessage()) + " in " + tok.getFileName() + ":" + tok.getLine() + ":" + tok.getCharPositionInLine());
                if (strt != null) {
                    analysisError.at(strt);
                }
                analysisError.save();
            } else {
                NewIssue issue = context.newIssue().forRule(RuleKey.of((String)"rssw-oe", (String)"proparse.error"));
                NewIssueLocation loc = issue.newLocation().on((InputComponent)file).message(Strings.nullToEmpty((String)caught.getMessage()) + " in " + tok.getFileName() + ":" + tok.getLine() + ":" + tok.getCharPositionInLine());
                if (strt != null && end != null) {
                    loc.at(file.newRange(strt, end));
                }
                issue.at(loc);
                issue.save();
            }
            return;
        }
        catch (RuntimeException caught) {
            LOG.error("Parser error in '" + InputFileUtils.getRelativePath(file, context.fileSystem()) + "'", (Throwable)caught);
            ++this.numFailures;
            NewIssue issue = context.newIssue();
            issue.forRule(RuleKey.of((String)"rssw-oe", (String)"proparse.error")).at(issue.newLocation().on((InputComponent)file).message(Strings.nullToEmpty((String)caught.getMessage()))).save();
            return;
        }
        if (context.runtime().getProduct() == SonarProduct.SONARQUBE) {
            if (!this.settings.useSimpleCPD()) {
                this.computeCpd(context, file, unit);
            }
            this.computeSimpleMetrics(context, file, unit);
            this.computeCommonMetrics(context, file, unit);
            this.computeComplexity(context, file, unit);
        }
        if (this.settings.useProparseDebug()) {
            this.generateProparseDebugFile(file, unit);
        }
        try {
            for (Map.Entry<ActiveRule, OpenEdgeProparseCheck> entry : this.components.getProparseRules().entrySet()) {
                LOG.debug("ActiveRule - Internal key {} - Repository {} - Rule {}", new Object[]{entry.getKey().internalKey(), entry.getKey().ruleKey().repository(), entry.getKey().ruleKey().rule()});
                startTime2 = System.currentTimeMillis();
                entry.getValue().sensorExecute(file, unit);
                this.ruleTime.put(entry.getKey().ruleKey().toString(), this.ruleTime.get(entry.getKey().ruleKey().toString()) + System.currentTimeMillis() - startTime2);
            }
        }
        catch (RuntimeException caught) {
            LOG.error("Error during rule execution for " + file, (Throwable)caught);
        }
    }

    private void updateParseTime(long elapsedTime) {
        LOG.debug("{} milliseconds to generate ParseUnit", (Object)elapsedTime);
        this.parseTime += elapsedTime;
        if (this.maxParseTime < elapsedTime) {
            this.maxParseTime = elapsedTime;
        }
    }

    private void computeAnalytics(SensorContext context) {
        this.components.setAnalytics(String.format("files=%1$d,failures=%2$d,parseTime=%3$d,maxParseTime=%4$d,ncloc=%5$d,oeversion=\"%6$s\"", this.numFiles, this.numFailures, this.parseTime, this.maxParseTime, this.ncLoc, this.settings.getOpenEdgePluginVersion()));
        this.components.setNcLoc(this.ncLoc);
        context.addContextProperty("sonar.oe.ncloc", Integer.toString(this.ncLoc));
    }

    private void logStatistics() {
        LOG.info("{} files proparse'd, {} XREF files, {} listing files, {} failure(s), {} NCLOCs", new Object[]{this.numFiles, this.numXREF, this.numListings, this.numFailures, this.ncLoc});
        LOG.info("AST Generation | time={} ms", (Object)this.parseTime);
        LOG.info("XREF Parsing   | time={} ms", (Object)this.xmlParseTime);
        LOG.info("Rules          | time={} ms", (Object)this.ruleTime.values().stream().reduce(0L, Long::sum));
        this.ruleTime.entrySet().stream().sorted((obj1, obj2) -> ((String)obj1.getKey()).compareTo((String)obj2.getKey())).forEach(entry -> LOG.info("Rule {} | time={} ms", entry.getKey(), entry.getValue()));
        if (!this.decisionTime.isEmpty()) {
            LOG.info("ANTRL4 - 25 longest rules");
            this.decisionTime.entrySet().stream().sorted((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue())).limit(25L).forEach(entry -> LOG.info("Rule {} - {} | time={} ms", new Object[]{entry.getKey(), Proparse.ruleNames[Proparse._ATN.getDecisionState((int)((Integer)entry.getKey()).intValue()).ruleIndex], entry.getValue()}));
        }
        if (!this.maxK.isEmpty()) {
            LOG.info("ANTRL4 - 25 Max lookeahead rules");
            this.maxK.entrySet().stream().sorted((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue())).limit(25L).forEach(entry -> LOG.info("Rule {} - {} | Max lookahead: {}", new Object[]{entry.getKey(), Proparse.ruleNames[Proparse._ATN.getDecisionState((int)((Integer)entry.getKey()).intValue()).ruleIndex], entry.getValue()}));
        }
    }

    private void generateProparseDebugFile(InputFile file, ParseUnit unit) {
        String fileName = ".proparse/" + file.relativePath() + ".json";
        File dbgFile = new File(fileName);
        dbgFile.getParentFile().mkdirs();
        try (PrintWriter writer = new PrintWriter(dbgFile);){
            JsonNodeLister nodeLister = new JsonNodeLister((JPNode)unit.getTopNode(), (Writer)writer, ABLNodeType.LEFTPAREN, new ABLNodeType[]{ABLNodeType.RIGHTPAREN, ABLNodeType.COMMA, ABLNodeType.PERIOD, ABLNodeType.LEXCOLON, ABLNodeType.OBJCOLON, ABLNodeType.THEN, ABLNodeType.END});
            nodeLister.print();
            this.debugFiles.add(file.relativePath() + ".json");
        }
        catch (IOException caught) {
            LOG.error("Unable to write proparse debug file", (Throwable)caught);
        }
    }

    private void generateProparseDebugIndex() {
        if (this.settings.useProparseDebug()) {
            try (InputStream from = this.getClass().getResourceAsStream("/debug-index.html");
                 FileOutputStream to = new FileOutputStream(new File(".proparse/index.html"));){
                ByteStreams.copy((InputStream)from, (OutputStream)to);
            }
            catch (IOException caught) {
                LOG.error("Error while writing index.html", (Throwable)caught);
            }
            try (PrintWriter writer = new PrintWriter(new File(".proparse/index.json"));){
                boolean first = true;
                writer.println("var data= { \"files\": [");
                for (String str : this.debugFiles) {
                    if (!first) {
                        writer.write(44);
                    } else {
                        first = false;
                    }
                    writer.println("{ \"file\": \"" + str + "\" }");
                }
                writer.println("]}");
            }
            catch (IOException uncaught) {
                LOG.error("Error while writing debug index", (Throwable)uncaught);
            }
        }
    }

    private void computeCpd(SensorContext context, InputFile file, ParseUnit unit) {
        CPDCallback cpdCallback = new CPDCallback(context, file, this.settings);
        unit.getTopNode().walk((ICallback)cpdCallback);
        cpdCallback.getResult().save();
    }

    private void computeSimpleMetrics(SensorContext context, InputFile file, ParseUnit unit) {
        context.newMeasure().on((InputComponent)file).forMetric((Metric)CoreMetrics.NCLOC).withValue((Serializable)Integer.valueOf(unit.getMetrics().getLoc())).save();
        this.ncLoc += unit.getMetrics().getLoc();
        context.newMeasure().on((InputComponent)file).forMetric((Metric)CoreMetrics.COMMENT_LINES).withValue((Serializable)Integer.valueOf(unit.getMetrics().getComments())).save();
        context.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.DIRECTIVES).withValue((Serializable)Integer.valueOf(unit.getMetrics().getDirectives())).save();
    }

    private void computeCommonMetrics(SensorContext context, InputFile file, ParseUnit unit) {
        context.newMeasure().on((InputComponent)file).forMetric((Metric)CoreMetrics.STATEMENTS).withValue((Serializable)Integer.valueOf(unit.getTopNode().queryStateHead().size())).save();
        int numProcs = 0;
        int numFuncs = 0;
        int numMethds = 0;
        Predicate<JPNode> p1 = node -> node.isStateHead() && (node.getNodeType() == ABLNodeType.PROCEDURE || node.getNodeType() == ABLNodeType.FUNCTION || node.getNodeType() == ABLNodeType.METHOD);
        Predicate<JPNode> p2 = node -> node.getPreviousNode() == null || node.getPreviousNode().getNodeType() != ABLNodeType.END;
        for (JPNode node2 : unit.getTopNode().query2(p1.and(p2))) {
            switch (node2.getNodeType()) {
                case PROCEDURE: {
                    if (!node2.getDirectChildren(ABLNodeType.IN, new ABLNodeType[]{ABLNodeType.SUPER, ABLNodeType.EXTERNAL}).isEmpty()) break;
                    ++numProcs;
                    break;
                }
                case FUNCTION: {
                    if (!node2.getDirectChildren(ABLNodeType.IN, new ABLNodeType[]{ABLNodeType.FORWARDS}).isEmpty()) break;
                    ++numFuncs;
                    break;
                }
                case METHOD: {
                    ++numMethds;
                    break;
                }
            }
        }
        context.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.INTERNAL_PROCEDURES).withValue((Serializable)Integer.valueOf(numProcs)).save();
        context.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.INTERNAL_FUNCTIONS).withValue((Serializable)Integer.valueOf(numFuncs)).save();
        context.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.METHODS).withValue((Serializable)Integer.valueOf(numMethds)).save();
    }

    private void computeComplexity(SensorContext context, InputFile file, ParseUnit unit) {
        if (unit.isInterface()) {
            return;
        }
        int complexity = 0;
        int complexityWithInc = 0;
        if (!unit.isClass()) {
            ++complexity;
            ++complexityWithInc;
        }
        ABLNodeType[] aBLNodeTypeArray = new ABLNodeType[]{ABLNodeType.REPEAT, ABLNodeType.FOR, ABLNodeType.WHEN, ABLNodeType.AND, ABLNodeType.OR, ABLNodeType.RETURN, ABLNodeType.PROCEDURE, ABLNodeType.FUNCTION, ABLNodeType.METHOD, ABLNodeType.ENUM};
        context.newMeasure().on((InputComponent)file).forMetric((Metric)CoreMetrics.COMPLEXITY).withValue((Serializable)Integer.valueOf(complexity += unit.getTopNode().queryMainFile(ABLNodeType.IF, new ABLNodeType[]{ABLNodeType.REPEAT, ABLNodeType.FOR, ABLNodeType.WHEN, ABLNodeType.AND, ABLNodeType.OR, ABLNodeType.RETURN, ABLNodeType.PROCEDURE, ABLNodeType.FUNCTION, ABLNodeType.METHOD, ABLNodeType.ENUM}).size())).save();
        context.newMeasure().on((InputComponent)file).forMetric(OpenEdgeMetrics.COMPLEXITY).withValue((Serializable)Integer.valueOf(complexityWithInc += unit.getTopNode().query(ABLNodeType.IF, aBLNodeTypeArray).size())).save();
    }

    private static class TreeParserModule
    implements Module {
        private final Class<? extends ProparseListener> instanceName;
        private final ParseUnit unit;

        public TreeParserModule(Class<? extends ProparseListener> instName, ParseUnit unit) {
            this.instanceName = instName;
            this.unit = unit;
        }

        public void configure(Binder binder) {
            binder.bind(ParseUnit.class).toInstance((Object)this.unit);
            binder.bind(ProparseListener.class).to(this.instanceName);
        }
    }
}

